/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IAirCanister;
import cr0s.warpdrive.data.ComponentType;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemComponent
extends Item
implements IAirCanister {
    private IIcon[] icons;
    private static ItemStack[] itemStackCache;

    public ItemComponent() {
        this.func_77627_a(true);
        this.func_77655_b("warpdrive.crafting.component");
        this.func_77637_a(WarpDrive.creativeTabWarpDrive);
        this.icons = new IIcon[ComponentType.length];
        itemStackCache = new ItemStack[ComponentType.length];
    }

    public static ItemStack getItemStack(ComponentType componentType) {
        if (componentType != null) {
            int damage = componentType.ordinal();
            if (itemStackCache[damage] == null) {
                ItemComponent.itemStackCache[damage] = new ItemStack((Item)WarpDrive.itemComponent, 1, damage);
            }
            return itemStackCache[damage];
        }
        return null;
    }

    public static ItemStack getItemStackNoCache(ComponentType componentType, int amount) {
        return new ItemStack((Item)WarpDrive.itemComponent, amount, componentType.ordinal());
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        for (ComponentType componentType : ComponentType.values()) {
            this.icons[componentType.ordinal()] = par1IconRegister.func_94245_a("warpdrive:component" + componentType.unlocalizedName);
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        int damage = itemStack.func_77960_j();
        if (damage >= 0 && damage < ComponentType.length) {
            return "item.warpdrive.crafting." + ComponentType.get((int)damage).unlocalizedName;
        }
        return this.func_77658_a();
    }

    public IIcon func_77617_a(int damage) {
        if (damage >= 0 && damage < ComponentType.length) {
            return this.icons[damage];
        }
        return this.icons[0];
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (ComponentType componentType : ComponentType.values()) {
            par3List.add(new ItemStack(par1, 1, componentType.ordinal()));
        }
    }

    @Override
    public ItemStack fullDrop(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirCanisterFull.fullDrop(itemStack);
        }
        return null;
    }

    @Override
    public ItemStack emptyDrop(ItemStack itemStack) {
        if (this.canContainAir(itemStack)) {
            return WarpDrive.itemAirCanisterFull.emptyDrop(itemStack);
        }
        return null;
    }

    @Override
    public boolean canContainAir(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ItemComponent && itemStack.func_77960_j() == ComponentType.AIR_CANISTER.ordinal();
    }

    @Override
    public boolean containsAir(ItemStack itemStack) {
        return false;
    }
}

