/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBreathingHelmet;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.world.SpaceTeleporter;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class LivingHandler {
    private HashMap<Integer, Integer> entity_airBlock = new HashMap();
    private HashMap<String, Integer> player_airTank = new HashMap();
    private HashMap<String, Integer> player_cloakTicks = new HashMap();
    private final int CLOAK_CHECK_TIMEOUT_TICKS = 100;
    private final int AIR_BLOCK_TICKS = 20;
    private final int AIR_TANK_TICKS = 300;
    private final int AIR_DROWN_TICKS = 20;

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        EntityLivingBase entity = event.entityLiving;
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        if (WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS > 0 && (Math.abs(x) > WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS || Math.abs(z) > WarpDriveConfig.G_SPACE_WORLDBORDER_BLOCKS)) {
            if (entity instanceof EntityPlayerMP && ((EntityPlayerMP)entity).field_71075_bZ.field_75098_d) {
                return;
            }
            entity.func_70097_a(DamageSource.field_76380_i, 9000.0f);
            return;
        }
        if (entity instanceof EntityPlayerMP) {
            this.updatePlayerCloakState(entity);
            if (((EntityPlayerMP)entity).field_71075_bZ.field_75098_d) {
                return;
            }
        }
        if (entity.field_70128_L || entity.func_85032_ar()) {
            return;
        }
        if (entity.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID || entity.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID) {
            boolean notInVacuum;
            Block block1 = entity.field_70170_p.func_147439_a(x, y, z);
            Block block2 = entity.field_70170_p.func_147439_a(x, y + 1, z);
            boolean bl = notInVacuum = block1.func_149667_c(WarpDrive.blockAir) || block2.func_149667_c(WarpDrive.blockAir);
            if (notInVacuum) {
                Integer air = this.entity_airBlock.get(entity.func_145782_y());
                if (air == null) {
                    this.entity_airBlock.put(entity.func_145782_y(), 20);
                } else if (air <= 1) {
                    this.entity_airBlock.put(entity.func_145782_y(), 20);
                    if (block1.func_149667_c(WarpDrive.blockAir)) {
                        int metadata = entity.field_70170_p.func_72805_g(x, y, z);
                        if (metadata > 0 && metadata < 15) {
                            entity.field_70170_p.func_72921_c(x, y, z, metadata - 1, 2);
                        }
                    } else {
                        int metadata = entity.field_70170_p.func_72805_g(x, y + 1, z);
                        if (metadata > 0 && metadata < 15) {
                            entity.field_70170_p.func_72921_c(x, y + 1, z, metadata - 1, 2);
                        }
                    }
                } else {
                    this.entity_airBlock.put(entity.func_145782_y(), air - 1);
                }
            } else if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                String playerName = player.func_70005_c_();
                Integer air = this.player_airTank.get(playerName);
                boolean hasHelmet = false;
                ItemStack helmetStack = player.func_82169_q(3);
                if (helmetStack != null) {
                    Item helmet = helmetStack.func_77973_b();
                    if (helmet instanceof IBreathingHelmet) {
                        IBreathingHelmet breathHelmet = (IBreathingHelmet)helmet;
                        int airTicks = breathHelmet.ticksPerCanDamage();
                        if (breathHelmet.canBreath((Entity)player)) {
                            hasHelmet = true;
                            if (air == null) {
                                this.player_airTank.put(playerName, airTicks);
                            } else if (air <= 1) {
                                if (breathHelmet.removeAir((Entity)player)) {
                                    this.player_airTank.put(playerName, airTicks);
                                } else {
                                    this.player_airTank.put(playerName, 20);
                                    player.func_70097_a(DamageSource.field_76369_e, 2.0f);
                                }
                            } else {
                                this.player_airTank.put(playerName, air - 1);
                            }
                        }
                    } else if (WarpDriveConfig.ITEMS_BREATHINGIC2.contains(helmet)) {
                        hasHelmet = true;
                        if (air == null) {
                            this.player_airTank.put(playerName, 300);
                        } else if (air <= 1) {
                            if (LivingHandler.consumeCompressedAir(player.field_71071_by.field_70462_a, player)) {
                                this.player_airTank.put(playerName, 300);
                            } else {
                                this.player_airTank.put(playerName, 20);
                                entity.func_70097_a(DamageSource.field_76369_e, 2.0f);
                            }
                        } else {
                            this.player_airTank.put(playerName, air - 1);
                        }
                    }
                }
                if (!hasHelmet) {
                    if (air == null) {
                        this.player_airTank.put(playerName, 300);
                    } else if (air <= 1) {
                        this.player_airTank.put(playerName, 20);
                        entity.func_70097_a(DamageSource.field_76369_e, 2.0f);
                    } else {
                        this.player_airTank.put(playerName, air - 1);
                    }
                }
                if (entity.field_70163_u < -10.0) {
                    player.field_71133_b.func_71203_ab().transferPlayerToDimension(player, 0, (Teleporter)new SpaceTeleporter(DimensionManager.getWorld((int)WarpDriveConfig.G_SPACE_DIMENSION_ID), 0, x, 250, z));
                    player.func_70015_d(30);
                    player.func_70634_a(entity.field_70165_t, 250.0, entity.field_70161_v);
                    player.func_71016_p();
                }
            } else {
                this.entity_airBlock.put(entity.func_145782_y(), 0);
                entity.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        }
    }

    private void updatePlayerCloakState(EntityLivingBase entity) {
        try {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Integer cloakTicks = this.player_cloakTicks.get(player.func_70005_c_());
            if (cloakTicks == null) {
                this.player_cloakTicks.put(player.func_70005_c_(), 0);
                return;
            }
            if (cloakTicks >= 100) {
                this.player_cloakTicks.put(player.func_70005_c_(), 0);
                WarpDrive.cloaks.updatePlayer((EntityPlayer)player);
            } else {
                this.player_cloakTicks.put(player.func_70005_c_(), cloakTicks + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean consumeCompressedAir(ItemStack[] inventory, EntityPlayerMP entityPlayer) {
        for (int j = 0; j < inventory.length; ++j) {
            ItemStack emptyCell;
            if (inventory[j] == null || !inventory[j].func_77969_a(WarpDriveConfig.IC2_compressedAir)) continue;
            --inventory[j].field_77994_a;
            if (inventory[j].field_77994_a <= 0) {
                inventory[j] = null;
            }
            if (WarpDriveConfig.IC2_emptyCell != null && !entityPlayer.field_71071_by.func_70441_a(emptyCell = new ItemStack(WarpDriveConfig.IC2_emptyCell.func_77973_b(), 1, 0))) {
                World world = entityPlayer.field_70170_p;
                EntityItem itemEnt = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, emptyCell);
                entityPlayer.field_70170_p.func_72838_d((Entity)itemEnt);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityLivingBase entity = event.entityLiving;
        float distance = event.distance;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            int check = MathHelper.func_76123_f((float)(distance - 3.0f));
            if (check > 0) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack armor = player.func_82169_q(i);
                    if (armor == null || !WarpDriveConfig.ITEMS_NOFALLDAMAGE.contains(armor.func_77973_b())) continue;
                    event.setCanceled(true);
                }
            }
        }
    }
}

