/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Planet;
import cr0s.warpdrive.data.VectorI;
import java.util.UUID;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;

public class StarMapEntry {
    public StarMapEntryType type = StarMapEntryType.SHIP;
    public UUID uuid = null;
    public int dimensionId = -666;
    public int x;
    public int y;
    public int z = 0;
    public int maxX;
    public int maxY;
    public int maxZ;
    public int minX;
    public int minY;
    public int minZ;
    public int volume;
    public double isolationRate = 0.0;
    public String name = "default";

    public StarMapEntry(int type, UUID uuid, int dimensionId, int x, int y, int z, int maxX, int maxY, int maxZ, int minX, int minY, int minZ, int volume, double isolationRate, String name) {
        this.uuid = uuid;
        this.dimensionId = dimensionId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.volume = volume;
        this.isolationRate = isolationRate;
        this.name = name;
    }

    public StarMapEntry(TileEntityShipCore core) {
        this(0, core.uuid, core.func_145831_w().field_73011_w.field_76574_g, core.field_145851_c, core.field_145848_d, core.field_145849_e, core.maxX, core.maxY, core.maxZ, core.minX, core.minY, core.minZ, core.shipMass, core.isolationRate, core.shipName);
    }

    public WorldServer getWorldServerIfLoaded() {
        WorldServer world = DimensionManager.getWorld((int)this.dimensionId);
        if (world == null) {
            return null;
        }
        boolean isLoaded = false;
        if (world.func_72863_F() instanceof ChunkProviderServer) {
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)world.func_72863_F();
            try {
                isLoaded = chunkProviderServer.field_73244_f.func_76161_b(ChunkCoordIntPair.func_77272_a((int)(this.x >> 4), (int)(this.z >> 4)));
            }
            catch (NoSuchFieldError exception) {
                isLoaded = chunkProviderServer.func_73149_a(this.x >> 4, this.z >> 4);
            }
        } else {
            isLoaded = world.func_72863_F().func_73149_a(this.x >> 4, this.z >> 4);
        }
        if (!isLoaded) {
            return null;
        }
        return world;
    }

    public boolean isLoaded() {
        return this.getWorldServerIfLoaded() != null;
    }

    public VectorI getSpaceCoordinates() {
        if (this.dimensionId == WarpDriveConfig.G_SPACE_DIMENSION_ID) {
            return new VectorI(this.x, this.y + 256, this.z);
        }
        if (this.dimensionId == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID) {
            return new VectorI(this.x, this.y + 512, this.z);
        }
        for (Planet planet : WarpDriveConfig.PLANETS) {
            if (planet.dimensionId != this.dimensionId || Math.abs(this.x - planet.dimensionCenterX) > planet.borderSizeX || Math.abs(this.z - planet.dimensionCenterZ) > planet.borderSizeZ) continue;
            return new VectorI(this.x - planet.dimensionCenterX + planet.spaceCenterX, this.y, this.z - planet.dimensionCenterZ + planet.spaceCenterZ);
        }
        return null;
    }

    public int hashCode() {
        return this.dimensionId << 24 + (this.x >> 10) << 12 + this.y << 10 + (this.z >> 10);
    }

    public static enum StarMapEntryType {
        UNDEFINED(0),
        SHIP(1),
        JUMPGATE(2),
        PLANET(3),
        STAR(4),
        STRUCTURE(5),
        WARPECHO(6);

        private final int code;

        private StarMapEntryType(int code) {
            this.code = code;
        }

        public int getType() {
            return this.code;
        }
    }
}

