/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.data.VectorI;
import net.minecraft.nbt.NBTTagCompound;

public class Planet
implements Cloneable {
    public int dimensionId;
    public int dimensionCenterX;
    public int dimensionCenterZ;
    public int borderSizeX;
    public int borderSizeZ;
    public int spaceCenterX;
    public int spaceCenterZ;

    public Planet() {
        this(0, 0, 0, 5000, 5000, 0, 0);
    }

    public Planet(int parDimensionId, int parDimensionCenterX, int parDimensionCenterZ, int parBorderSizeX, int parBorderSizeZ, int parSpaceCenterX, int parSpaceCenterZ) {
        this.dimensionId = parDimensionId;
        this.spaceCenterX = parSpaceCenterX;
        this.spaceCenterZ = parSpaceCenterZ;
        this.dimensionCenterX = parDimensionCenterX;
        this.dimensionCenterZ = parDimensionCenterZ;
        this.borderSizeX = parBorderSizeX;
        this.borderSizeZ = parBorderSizeZ;
    }

    public Planet(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public Planet clone() {
        return new Planet(this.dimensionId, this.dimensionCenterX, this.dimensionCenterZ, this.borderSizeX, this.borderSizeZ, this.spaceCenterX, this.spaceCenterZ);
    }

    public int isValidToSpace(VectorI currentPosition) {
        if (Math.abs(currentPosition.x - this.dimensionCenterX) <= this.borderSizeX && Math.abs(currentPosition.z - this.dimensionCenterZ) <= this.borderSizeZ) {
            return 0;
        }
        return (int)Math.sqrt(Math.pow(Math.max(0.0, (double)(Math.abs(currentPosition.x - this.dimensionCenterX) - this.borderSizeX)), 2.0) + Math.pow(Math.max(0.0, (double)(Math.abs(currentPosition.z - this.dimensionCenterZ) - this.borderSizeZ)), 2.0));
    }

    public int isValidFromSpace(VectorI currentPosition) {
        if (Math.abs(currentPosition.x - this.spaceCenterX) <= this.borderSizeX && Math.abs(currentPosition.z - this.spaceCenterZ) <= this.borderSizeZ) {
            return 0;
        }
        return (int)Math.sqrt(Math.pow(Math.max(0.0, (double)(Math.abs(currentPosition.x - this.spaceCenterX) - this.borderSizeX)), 2.0) + Math.pow(Math.max(0.0, (double)(Math.abs(currentPosition.z - this.spaceCenterZ) - this.borderSizeZ)), 2.0));
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.dimensionId = tag.func_74762_e("dimensionId");
        this.dimensionCenterX = tag.func_74762_e("dimensionCenterX");
        this.dimensionCenterZ = tag.func_74762_e("dimensionCenterZ");
        this.borderSizeX = tag.func_74762_e("borderSizeX");
        this.borderSizeZ = tag.func_74762_e("borderSizeZ");
        this.spaceCenterX = tag.func_74762_e("spaceCenterX");
        this.spaceCenterZ = tag.func_74762_e("spaceCenterZ");
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("dimensionId", this.dimensionId);
        tag.func_74768_a("dimensionCenterX", this.dimensionCenterX);
        tag.func_74768_a("dimensionCenterZ", this.dimensionCenterZ);
        tag.func_74768_a("borderSizeX", this.borderSizeX);
        tag.func_74768_a("borderSizeZ", this.borderSizeZ);
        tag.func_74768_a("spaceCenterX", this.spaceCenterX);
        tag.func_74768_a("spaceCenterZ", this.spaceCenterZ);
    }

    public int hashCode() {
        return this.dimensionId << 16 + (this.dimensionCenterX >> 10) << 8 + (this.dimensionCenterZ >> 10);
    }

    public boolean equals(Object object) {
        if (object instanceof Planet) {
            Planet planet = (Planet)object;
            return this.dimensionId == planet.dimensionId && this.dimensionCenterX == planet.dimensionCenterX && this.dimensionCenterZ == planet.dimensionCenterZ && this.borderSizeX == planet.borderSizeX && this.borderSizeZ == planet.borderSizeZ && this.spaceCenterX == planet.spaceCenterX && this.spaceCenterZ == planet.spaceCenterZ;
        }
        return false;
    }

    public String toString() {
        return "Planet [Dimension " + this.dimensionId + "(" + this.dimensionCenterX + ", " + this.dimensionCenterZ + ")" + " Border(" + this.borderSizeX + ", " + this.borderSizeZ + ")" + " Space(" + this.spaceCenterX + ", " + this.spaceCenterZ + ")]";
    }
}

