/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class JumpBlock {
    public Block block;
    public int blockMeta;
    public TileEntity blockTileEntity;
    public NBTTagCompound blockNBT;
    public int x;
    public int y;
    public int z;
    public NBTTagCompound nbtArsMagica2;
    public NBTTagList nbtImmersiveEngineering;
    private static Object NetworkManager_instance;
    private static Method NetworkManager_updateTileEntityField;

    public JumpBlock() {
    }

    public JumpBlock(Block block, int blockMeta, int x, int y, int z) {
        this.block = block;
        this.blockMeta = blockMeta;
        this.blockTileEntity = null;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public JumpBlock(Block block, int blockMeta, TileEntity tileEntity, int x, int y, int z) {
        this.block = block;
        this.blockMeta = blockMeta;
        this.blockTileEntity = tileEntity;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean deploy(World targetWorld, int offsetX, int offsetY, int offsetZ) {
        try {
            int newX = this.x + offsetX;
            int newY = this.y + offsetY;
            int newZ = this.z + offsetZ;
            JumpBlock.setBlockNoLight(targetWorld, newX, newY, newZ, this.block, this.blockMeta, 2);
            if (this.block == WarpDrive.blockAir) {
                targetWorld.func_147471_g(newX, newY, newZ);
                targetWorld.func_147464_a(newX, newY, newZ, this.block, 40 + targetWorld.field_73012_v.nextInt(20));
            }
            NBTTagCompound oldnbt = new NBTTagCompound();
            if (this.blockTileEntity != null) {
                NBTTagCompound nbtScreenData;
                this.blockTileEntity.func_145841_b(oldnbt);
                oldnbt.func_74768_a("x", newX);
                oldnbt.func_74768_a("y", newY);
                oldnbt.func_74768_a("z", newZ);
                if (oldnbt.func_74764_b("mainX") && oldnbt.func_74764_b("mainY") && oldnbt.func_74764_b("mainZ")) {
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        WarpDrive.logger.info(this + " deploy: TileEntity has mainXYZ");
                    }
                    oldnbt.func_74768_a("mainX", oldnbt.func_74762_e("mainX") + offsetX);
                    oldnbt.func_74768_a("mainY", oldnbt.func_74762_e("mainY") + offsetY);
                    oldnbt.func_74768_a("mainZ", oldnbt.func_74762_e("mainZ") + offsetZ);
                }
                if (oldnbt.func_74764_b("screenData") && (nbtScreenData = oldnbt.func_74775_l("screenData")).func_74764_b("minX") && nbtScreenData.func_74764_b("minY") && nbtScreenData.func_74764_b("minZ") && nbtScreenData.func_74764_b("maxX") && nbtScreenData.func_74764_b("maxY") && nbtScreenData.func_74764_b("maxZ")) {
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        WarpDrive.logger.info(this + " deploy: TileEntity has screenData.min/maxXYZ");
                    }
                    nbtScreenData.func_74768_a("minX", nbtScreenData.func_74762_e("minX") + offsetX);
                    nbtScreenData.func_74768_a("minY", nbtScreenData.func_74762_e("minY") + offsetY);
                    nbtScreenData.func_74768_a("minZ", nbtScreenData.func_74762_e("minZ") + offsetZ);
                    nbtScreenData.func_74768_a("maxX", nbtScreenData.func_74762_e("maxX") + offsetX);
                    nbtScreenData.func_74768_a("maxY", nbtScreenData.func_74762_e("maxY") + offsetY);
                    nbtScreenData.func_74768_a("maxZ", nbtScreenData.func_74762_e("maxZ") + offsetZ);
                    oldnbt.func_74782_a("screenData", (NBTBase)nbtScreenData);
                }
                if (oldnbt.func_74764_b("hasValidBubble")) {
                    oldnbt.func_74757_a("hasValidBubble", false);
                }
                TileEntity newTileEntity = null;
                boolean isForgeMultipart = false;
                if (WarpDriveConfig.isForgeMultipartLoaded && oldnbt.func_74764_b("id") && oldnbt.func_74779_i("id") == "savedMultipart") {
                    isForgeMultipart = true;
                    newTileEntity = (TileEntity)WarpDriveConfig.forgeMultipart_helper_createTileFromNBT.invoke(null, targetWorld, oldnbt);
                } else if (this.block == WarpDriveConfig.CC_Computer || this.block == WarpDriveConfig.CC_peripheral || this.block == WarpDriveConfig.CCT_Turtle || this.block == WarpDriveConfig.CCT_Expanded || this.block == WarpDriveConfig.CCT_Advanced) {
                    newTileEntity = TileEntity.func_145827_c((NBTTagCompound)oldnbt);
                    newTileEntity.func_145843_s();
                }
                if (newTileEntity == null) {
                    newTileEntity = TileEntity.func_145827_c((NBTTagCompound)oldnbt);
                }
                if (newTileEntity != null) {
                    newTileEntity.func_145834_a(targetWorld);
                    newTileEntity.func_145829_t();
                    targetWorld.func_147455_a(newX, newY, newZ, newTileEntity);
                    if (isForgeMultipart) {
                        WarpDriveConfig.forgeMultipart_tileMultipart_onChunkLoad.invoke((Object)newTileEntity, new Object[0]);
                        WarpDriveConfig.forgeMultipart_helper_sendDescPacket.invoke(null, targetWorld, newTileEntity);
                    }
                } else {
                    WarpDrive.logger.info(" deploy failed to create new tile entity at " + this.x + ", " + this.y + ", " + this.z + " blockId " + this.block + ":" + this.blockMeta);
                    WarpDrive.logger.info("NBT data was " + oldnbt);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String coordinates = "";
            try {
                coordinates = " at " + this.x + ", " + this.y + ", " + this.z + " blockId " + this.block + ":" + this.blockMeta;
            }
            catch (Exception dropMe) {
                coordinates = " (unknown coordinates)";
            }
            WarpDrive.logger.info("moveBlockSimple exception at " + coordinates);
            return false;
        }
        return true;
    }

    public static void refreshBlockStateOnClient(World world, int x, int y, int z) {
        block17: {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity != null) {
                Class<?> teClass = tileEntity.getClass();
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info("Tile at " + x + ", " + y + ", " + z + " is " + teClass + " derived from " + teClass.getSuperclass());
                }
                try {
                    if (teClass.getSuperclass().getName().contains("ic2.core.block")) {
                        Method onUnloaded = teClass.getMethod("onUnloaded", new Class[0]);
                        Method onLoaded = teClass.getMethod("onLoaded", new Class[0]);
                        if (onUnloaded != null && onLoaded != null) {
                            onUnloaded.invoke((Object)tileEntity, new Object[0]);
                            onLoaded.invoke((Object)tileEntity, new Object[0]);
                        } else {
                            WarpDrive.logger.error("Missing IC2 (un)loaded events for TileEntity '" + teClass.getName() + "' at " + x + ", " + y + ", " + z + ". Please report this issue!");
                        }
                        tileEntity.func_145836_u();
                        if (teClass.getName().equals("ic2.core.block.wiring.TileEntityCable")) {
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "color");
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "foamColor");
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "foamed");
                        } else {
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "active");
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "facing");
                            if (teClass.getName().equals("ic2.core.block.reactor.TileEntityNuclearReactorElectric")) {
                                JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, "heat");
                            }
                        }
                        break block17;
                    }
                    try {
                        Method getNetworkedFields = teClass.getMethod("getNetworkedFields", new Class[0]);
                        List fields = (List)getNetworkedFields.invoke((Object)tileEntity, new Object[0]);
                        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                            WarpDrive.logger.info("Tile has " + fields.size() + " networked fields: " + fields);
                        }
                        for (String field : fields) {
                            JumpBlock.NetworkHelper_updateTileEntityField(tileEntity, field);
                        }
                    }
                    catch (NoSuchMethodException exception) {
                    }
                    catch (NoClassDefFoundError exception) {
                        if (WarpDriveConfig.LOGGING_JUMP) {
                            WarpDrive.logger.info("TileEntity " + teClass.getName() + " at " + x + ", " + y + ", " + z + " is missing a class definition");
                            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    WarpDrive.logger.info("Exception involving TileEntity " + teClass.getName() + " at " + x + ", " + y + ", " + z);
                    exception.printStackTrace();
                }
            }
        }
    }

    public static void NetworkHelper_init() {
        try {
            NetworkManager_updateTileEntityField = Class.forName("ic2.core.network.NetworkManager").getMethod("updateTileEntityField", TileEntity.class, String.class);
            NetworkManager_instance = Class.forName("ic2.core.IC2").getDeclaredField("network").get(null);
            if (!NetworkManager_instance.getClass().getName().contains("NetworkManager")) {
                NetworkManager_instance = Class.forName("ic2.core.util.SideGateway").getMethod("get", new Class[0]).invoke(NetworkManager_instance, new Object[0]);
                WarpDrive.logger.error("Patched IC2 API, new instance is '" + NetworkManager_instance + "'");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void NetworkHelper_updateTileEntityField(TileEntity te, String field) {
        try {
            if (NetworkManager_instance == null) {
                JumpBlock.NetworkHelper_init();
            }
            NetworkManager_updateTileEntityField.invoke(NetworkManager_instance, te, field);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean setBlockNoLight(World w, int x, int y, int z, Block block, int blockMeta, int par6) {
        if (x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000) {
            if (y < 0) {
                return false;
            }
            if (y >= 256) {
                return false;
            }
            Chunk chunk = w.func_72964_e(x >> 4, z >> 4);
            Block block1 = null;
            if ((par6 & 1) != 0) {
                block1 = chunk.func_150810_a(x & 0xF, y, z & 0xF);
            }
            boolean flag = JumpBlock.myChunkSBIDWMT(chunk, x & 0xF, y, z & 0xF, block, blockMeta);
            w.markAndNotifyBlock(x, y, z, chunk, block1, block, par6);
            return flag;
        }
        return false;
    }

    public static boolean myChunkSBIDWMT(Chunk c, int x, int y, int z, Block block, int blockMeta) {
        TileEntity tileentity;
        int i1 = z << 4 | x;
        if (y >= c.field_76638_b[i1] - 1) {
            c.field_76638_b[i1] = -999;
        }
        Block block1 = c.func_150810_a(x, y, z);
        int k1 = c.func_76628_c(x, y, z);
        if (block1 == block && k1 == blockMeta) {
            return false;
        }
        ExtendedBlockStorage[] storageArrays = c.func_76587_i();
        ExtendedBlockStorage extendedblockstorage = storageArrays[y >> 4];
        if (extendedblockstorage == null) {
            if (block == Blocks.field_150350_a) {
                return false;
            }
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(y >> 4 << 4, !c.field_76637_e.field_73011_w.field_76576_e);
            storageArrays[y >> 4] = extendedBlockStorage;
            extendedblockstorage = extendedBlockStorage;
        }
        int l1 = c.field_76635_g * 16 + x;
        int i2 = c.field_76647_h * 16 + z;
        extendedblockstorage.func_150818_a(x, y & 0xF, z, block);
        extendedblockstorage.func_76654_b(x, y & 0xF, z, blockMeta);
        if (block1 != Blocks.field_150350_a) {
            TileEntity te;
            if (!c.field_76637_e.field_72995_K) {
                block1.func_149749_a(c.field_76637_e, l1, y, i2, block1, k1);
                te = c.getTileEntityUnsafe(x & 0xF, y, z & 0xF);
                if (te != null && te.shouldRefresh(block1, c.func_150810_a(x & 0xF, y, z & 0xF), k1, c.func_76628_c(x & 0xF, y, z & 0xF), c.field_76637_e, l1, y, i2)) {
                    c.func_150805_f(x & 0xF, y, z & 0xF);
                }
            } else if (block1.hasTileEntity(k1) && (te = c.getTileEntityUnsafe(x & 0xF, y, z & 0xF)) != null && te.shouldRefresh(block1, block, k1, blockMeta, c.field_76637_e, l1, y, i2)) {
                c.field_76637_e.func_147475_p(l1, y, i2);
            }
        }
        if (extendedblockstorage.func_150819_a(x, y & 0xF, z) != block) {
            return false;
        }
        extendedblockstorage.func_76654_b(x, y & 0xF, z, blockMeta);
        if (block1 != Blocks.field_150350_a && block.hasTileEntity(blockMeta) && (tileentity = c.func_150806_e(x, y, z)) != null) {
            tileentity.func_145836_u();
            tileentity.field_145847_g = blockMeta;
        }
        c.field_76643_l = true;
        return true;
    }
}

