/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CameraRegistryItem;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class CamerasRegistry {
    private LinkedList<CameraRegistryItem> registry = new LinkedList();

    public CameraRegistryItem getCameraByFrequency(World worldObj, int frequency) {
        CameraRegistryItem cam = null;
        Iterator it = this.registry.iterator();
        while (it.hasNext()) {
            cam = (CameraRegistryItem)it.next();
            if (cam.frequency != frequency || cam.dimensionId != worldObj.field_73011_w.field_76574_g) continue;
            if (CamerasRegistry.isCamAlive(worldObj, cam)) {
                return cam;
            }
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info("Removing 'dead' camera at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c + " (while searching)");
            }
            it.remove();
        }
        this.printRegistry(worldObj);
        return null;
    }

    private CameraRegistryItem getCamByPosition(World worldObj, ChunkPosition position) {
        CameraRegistryItem cam2 = null;
        for (CameraRegistryItem cam2 : this.registry) {
            if (cam2.position.field_151329_a != position.field_151329_a || cam2.position.field_151327_b != position.field_151327_b || cam2.position.field_151328_c != position.field_151328_c || cam2.dimensionId != worldObj.field_73011_w.field_76574_g) continue;
            return cam2;
        }
        return null;
    }

    private static boolean isCamAlive(World worldObj, CameraRegistryItem cam) {
        if (worldObj.field_73011_w.field_76574_g != cam.dimensionId) {
            WarpDrive.logger.error("Inconsistent worldObj with camera " + worldObj.field_73011_w.field_76574_g + " vs " + cam.dimensionId);
            return false;
        }
        if (!worldObj.func_72938_d((int)cam.position.field_151329_a, (int)cam.position.field_151328_c).field_76636_d) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info("Reporting an 'unloaded' camera in dimension " + cam.dimensionId + " at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c);
            }
            return false;
        }
        Block block = worldObj.func_147439_a(cam.position.field_151329_a, cam.position.field_151327_b, cam.position.field_151328_c);
        if (block != WarpDrive.blockCamera && block != WarpDrive.blockLaserCamera) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info("Reporting a 'dead' camera in dimension " + cam.dimensionId + " at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c);
            }
            return false;
        }
        return true;
    }

    private void removeDeadCams(World worldObj) {
        CameraRegistryItem cam = null;
        Iterator it = this.registry.iterator();
        while (it.hasNext()) {
            cam = (CameraRegistryItem)it.next();
            if (CamerasRegistry.isCamAlive(worldObj, cam)) continue;
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info("Removing 'dead' camera in dimension " + cam.dimensionId + " at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c);
            }
            it.remove();
        }
    }

    public void removeFromRegistry(World worldObj, ChunkPosition position) {
        CameraRegistryItem cam = this.getCamByPosition(worldObj, position);
        if (cam != null) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info("Removing camera by request in dimension " + cam.dimensionId + " at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c);
            }
            this.registry.remove(cam);
        }
    }

    public void updateInRegistry(World worldObj, ChunkPosition position, int frequency, int type) {
        CameraRegistryItem cam = new CameraRegistryItem(worldObj, position, frequency, type);
        this.removeDeadCams(worldObj);
        if (CamerasRegistry.isCamAlive(worldObj, cam)) {
            CameraRegistryItem existingCam = this.getCamByPosition(worldObj, cam.position);
            if (existingCam == null) {
                if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                    WarpDrive.logger.info("Adding 'live' camera at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c + " with frequency '" + cam.frequency + "'");
                }
                this.registry.add(cam);
            } else if (existingCam.frequency != cam.frequency) {
                if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                    WarpDrive.logger.info("Updating 'live' camera at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c + " from frequency '" + existingCam.frequency + "' to frequency '" + cam.frequency + "'");
                }
                existingCam.frequency = cam.frequency;
            }
        } else if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info("Unable to update 'dead' camera at " + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c);
        }
    }

    public void printRegistry(World worldObj) {
        WarpDrive.logger.info("Cameras registry for dimension " + worldObj.field_73011_w.field_76574_g + ":");
        for (CameraRegistryItem cam : this.registry) {
            WarpDrive.logger.info("- " + cam.frequency + " (" + cam.position.field_151329_a + ", " + cam.position.field_151327_b + ", " + cam.position.field_151328_c + ")");
        }
    }
}

