/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import net.minecraft.block.Block;

public class BlockMetaRotation {
    public final Block block;
    public final int[] metaRotation;
    private int bitMask;

    protected BlockMetaRotation(Block block, int[] metarotation, int bitmask) {
        if (metarotation.length != 4) {
            throw new IllegalArgumentException("MetaRotation int array must have length 4");
        }
        this.block = block;
        this.metaRotation = metarotation;
        this.bitMask = bitmask;
    }

    public int getRotatedMeta(int currentmeta, int rotate) {
        for (int i = 0; i < this.metaRotation.length; ++i) {
            if (this.metaRotation[i] != (currentmeta & this.bitMask)) continue;
            int mr = currentmeta & ~this.bitMask | this.metaRotation[BlockMetaRotation.wrapRotationIndex(i + rotate)] & this.bitMask;
            return mr;
        }
        return currentmeta;
    }

    public static int wrapRotationIndex(int i) {
        return i & 3;
    }
}

