/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.core;

import cr0s.warpdrive.core.FMLLoadingPlugin;
import java.util.HashMap;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    private HashMap<String, String> nodemap = new HashMap();
    private final String GRAVITY_MANAGER_CLASS = "cr0s/warpdrive/GravityManager";
    private final String CLOAK_MANAGER_CLASS = "cr0s/warpdrive/data/CloakManager";
    private boolean debugLog = false;

    public ClassTransformer() {
        this.nodemap.put("EntityLivingBase.class", "sv");
        this.nodemap.put("moveEntityWithHeading.name", "func_70612_e");
        this.nodemap.put("moveEntityWithHeading.desc", "(FF)V");
        this.nodemap.put("EntityItem.class", "xk");
        this.nodemap.put("onUpdate.name", "func_70071_h_");
        this.nodemap.put("onUpdate.desc", "()V");
        this.nodemap.put("WorldClient.class", "bjf");
        this.nodemap.put("func_147492_c.name", "func_147492_c");
        this.nodemap.put("func_147492_c.desc", "(IIILnet/minecraft/block/Block;I)Z");
        this.nodemap.put("setBlock.name", "func_147465_d");
        this.nodemap.put("Chunk.class", "apx");
        this.nodemap.put("fillChunk.name", "func_76607_a");
        this.nodemap.put("fillChunk.desc", "([BIIZ)V");
        this.nodemap.put("generateHeightMap.name", "func_76590_a");
        this.nodemap.put("generateHeightMap.desc", "()V");
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (this.nodemap == null) {
            FMLLoadingPlugin.logger.info("Nodemap is null, transformation cancelled");
            return bytes;
        }
        if (transformedName.equals("net.minecraft.entity.EntityLivingBase")) {
            bytes = this.transformMinecraftEntityLivingBase(bytes);
        } else if (transformedName.equals("net.minecraft.entity.item.EntityItem")) {
            bytes = this.transformMinecraftEntityItem(bytes);
        } else if (transformedName.equals("com.creativemd.itemphysic.physics.ServerPhysic")) {
            bytes = this.transformItemPhysicEntityItem(bytes);
        } else if (transformedName.equals("micdoodle8.mods.galacticraft.core.util.WorldUtil")) {
            bytes = this.transformGalacticraftWorldUtil(bytes);
        } else if (transformedName.equals("net.minecraft.client.multiplayer.WorldClient")) {
            bytes = this.transformMinecraftWorldClient(bytes);
        } else if (transformedName.equals("net.minecraft.world.chunk.Chunk")) {
            bytes = this.transformMinecraftChunk(bytes);
        }
        return bytes;
    }

    private byte[] transformMinecraftEntityLivingBase(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 1;
        int injectedCount = 0;
        for (MethodNode methodnode : classNode.methods) {
            if (!methodnode.name.equals(this.nodemap.get("moveEntityWithHeading.name")) && !methodnode.name.equals("moveEntityWithHeading") || !methodnode.desc.equals(this.nodemap.get("moveEntityWithHeading.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodnode.instructions.size(); ++instructionIndex) {
                AbstractInsnNode abstractNode = methodnode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (!nodeAt.cst.equals(0.08)) continue;
                VarInsnNode beforeNode = new VarInsnNode(25, 0);
                MethodInsnNode overwriteNode = new MethodInsnNode(184, "cr0s/warpdrive/GravityManager", "getGravityForEntity", "(Lnet/minecraft/entity/Entity;)D", false);
                methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodnode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodnode.name + " " + methodnode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformMinecraftEntityItem(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 2;
        int injectedCount = 0;
        for (MethodNode methodnode : classNode.methods) {
            if (!methodnode.name.equals(this.nodemap.get("onUpdate.name")) && !methodnode.name.equals("onUpdate") || !methodnode.desc.equals(this.nodemap.get("onUpdate.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodnode.instructions.size(); ++instructionIndex) {
                MethodInsnNode overwriteNode;
                VarInsnNode beforeNode;
                AbstractInsnNode abstractNode = methodnode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (nodeAt.cst.equals(0.04f)) {
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, "cr0s/warpdrive/GravityManager", "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                    methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodnode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    if (this.debugLog) {
                        FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodnode.name + " " + methodnode.desc);
                    }
                    ++injectedCount;
                }
                if (!nodeAt.cst.equals(0.98f)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, "cr0s/warpdrive/GravityManager", "getItemGravity2", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodnode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodnode.name + " " + methodnode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformItemPhysicEntityItem(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 2;
        int injectedCount = 0;
        for (MethodNode methodnode : classNode.methods) {
            if (!methodnode.name.equals("update") || !methodnode.desc.equals("(Lnet/minecraft/entity/item/EntityItem;)V")) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodnode.instructions.size(); ++instructionIndex) {
                MethodInsnNode overwriteNode;
                VarInsnNode beforeNode;
                AbstractInsnNode abstractNode = methodnode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)abstractNode;
                if (nodeAt.cst.equals(0.04)) {
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, "cr0s/warpdrive/GravityManager", "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                    methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodnode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    if (this.debugLog) {
                        FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodnode.name + " " + methodnode.desc);
                    }
                    ++injectedCount;
                }
                if (!nodeAt.cst.equals(0.98)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, "cr0s/warpdrive/GravityManager", "getItemGravity2", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodnode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodnode.name + " " + methodnode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformGalacticraftWorldUtil(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 5;
        int injectedCount = 0;
        for (MethodNode methodnode : classNode.methods) {
            MethodInsnNode overwriteNode;
            VarInsnNode beforeNode;
            LdcInsnNode nodeAt;
            AbstractInsnNode abstractNode;
            int instructionIndex;
            if (methodnode.name.equals("getGravityForEntity") && methodnode.desc.equals("(Lnet/minecraft/entity/Entity;)D")) {
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Method found!");
                }
                for (instructionIndex = 0; instructionIndex < methodnode.instructions.size(); ++instructionIndex) {
                    abstractNode = methodnode.instructions.get(instructionIndex);
                    if (!(abstractNode instanceof LdcInsnNode)) continue;
                    nodeAt = (LdcInsnNode)abstractNode;
                    if (!nodeAt.cst.equals(0.08)) continue;
                    beforeNode = new VarInsnNode(25, 0);
                    overwriteNode = new MethodInsnNode(184, "cr0s/warpdrive/GravityManager", "getGravityForEntity", "(Lnet/minecraft/entity/Entity;)D", false);
                    methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                    methodnode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    if (this.debugLog) {
                        FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodnode.name + " " + methodnode.desc);
                    }
                    ++injectedCount;
                }
            }
            if (!methodnode.name.equals("getItemGravity") || !methodnode.desc.equals("(Lnet/minecraft/entity/item/EntityItem;)D")) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (instructionIndex = 0; instructionIndex < methodnode.instructions.size(); ++instructionIndex) {
                abstractNode = methodnode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof LdcInsnNode)) continue;
                nodeAt = (LdcInsnNode)abstractNode;
                if (!nodeAt.cst.equals(0.04f)) continue;
                beforeNode = new VarInsnNode(25, 0);
                overwriteNode = new MethodInsnNode(184, "cr0s/warpdrive/GravityManager", "getItemGravity", "(Lnet/minecraft/entity/item/EntityItem;)D", false);
                methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                methodnode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodnode.name + " " + methodnode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformMinecraftWorldClient(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 1;
        int injectedCount = 0;
        for (MethodNode methodnode : classNode.methods) {
            if (!methodnode.name.equals(this.nodemap.get("func_147492_c.name")) && !methodnode.name.equals("func_147492_c") || !methodnode.desc.equals(this.nodemap.get("func_147492_c.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodnode.instructions.size(); ++instructionIndex) {
                AbstractInsnNode abstractNode = methodnode.instructions.get(instructionIndex);
                if (!(abstractNode instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)abstractNode;
                if (!nodeAt.name.equals(this.nodemap.get("setBlock.name")) && !nodeAt.name.equals("setBlock")) continue;
                MethodInsnNode overwriteNode = new MethodInsnNode(184, "cr0s/warpdrive/data/CloakManager", "onBlockChange", "(IIILnet/minecraft/block/Block;II)Z", false);
                methodnode.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodnode.name + " " + methodnode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private byte[] transformMinecraftChunk(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        int operationCount = 1;
        int injectedCount = 0;
        for (MethodNode methodnode : classNode.methods) {
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("- Method " + methodnode.name + " " + methodnode.desc);
            }
            if (!methodnode.name.equals(this.nodemap.get("fillChunk.name")) && !methodnode.name.equals("fillChunk") || !methodnode.desc.equals(this.nodemap.get("fillChunk.desc"))) continue;
            if (this.debugLog) {
                FMLLoadingPlugin.logger.info("Method found!");
            }
            for (int instructionIndex = 0; instructionIndex < methodnode.instructions.size(); ++instructionIndex) {
                AbstractInsnNode abstractNode = methodnode.instructions.get(instructionIndex);
                if (this.debugLog) {
                    ClassTransformer.deasm(abstractNode);
                }
                if (!(abstractNode instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)abstractNode;
                if (!nodeAt.name.equals(this.nodemap.get("generateHeightMap.name")) && !nodeAt.name.equals("generateHeightMap") || !nodeAt.desc.equals(this.nodemap.get("generateHeightMap.desc"))) continue;
                MethodInsnNode insertMethodNode = new MethodInsnNode(184, "cr0s/warpdrive/data/CloakManager", "onFillChunk", "(Lnet/minecraft/world/chunk/Chunk;)V", false);
                methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)insertMethodNode);
                ++instructionIndex;
                VarInsnNode insertVarNode = new VarInsnNode(25, 0);
                methodnode.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)insertVarNode);
                ++instructionIndex;
                if (this.debugLog) {
                    FMLLoadingPlugin.logger.info("Injecting into " + classNode.name + "." + methodnode.name + " " + methodnode.desc);
                }
                ++injectedCount;
            }
        }
        if (injectedCount != operationCount) {
            FMLLoadingPlugin.logger.info("Injection failed for " + classNode.name + " (" + injectedCount + " / " + operationCount + "), aborting...");
        } else {
            ClassWriter writer = new ClassWriter(1);
            classNode.accept((ClassVisitor)writer);
            bytes = writer.toByteArray();
            FMLLoadingPlugin.logger.info("Successful injection in " + classNode.name);
        }
        return bytes;
    }

    private static void deasm(AbstractInsnNode abstractNode) {
        if (abstractNode instanceof VarInsnNode) {
            VarInsnNode node = (VarInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Var " + node.var);
        } else if (abstractNode instanceof LabelNode) {
            LabelNode node = (LabelNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Label " + node.getLabel());
        } else if (abstractNode instanceof LineNumberNode) {
            LineNumberNode node = (LineNumberNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Line " + node.line);
        } else if (abstractNode instanceof InsnNode) {
            InsnNode node = (InsnNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Instruction " + node);
        } else if (abstractNode instanceof LdcInsnNode) {
            LdcInsnNode node = (LdcInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Load " + node.cst);
        } else if (abstractNode instanceof FieldInsnNode) {
            FieldInsnNode node = (FieldInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Field " + node.owner + " " + node.name + " " + node.desc);
        } else if (abstractNode instanceof MethodInsnNode) {
            MethodInsnNode node = (MethodInsnNode)abstractNode;
            FMLLoadingPlugin.logger.info("  + Method " + node.owner + " " + node.name + " " + node.desc);
        } else {
            FMLLoadingPlugin.logger.info("  + Instruction " + abstractNode.getOpcode() + " " + abstractNode.getType() + " " + abstractNode.toString());
        }
    }
}

