/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlPreprocessor;
import cr0s.warpdrive.config.XmlRepresentable;
import cr0s.warpdrive.config.structures.Asteroid;
import cr0s.warpdrive.config.structures.DeployableStructure;
import cr0s.warpdrive.config.structures.Planetoid;
import cr0s.warpdrive.config.structures.Star;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StructureManager {
    private static RandomCollection<Star> stars = new RandomCollection();
    private static RandomCollection<Planetoid> moons = new RandomCollection();
    private static RandomCollection<Planetoid> gasClouds = new RandomCollection();
    private static RandomCollection<Asteroid> asteroids = new RandomCollection();

    public static void loadStructures(String structureConfDir) {
        StructureManager.loadStructures(new File(structureConfDir));
    }

    public static void loadStructures(File dir) {
        File[] files;
        dir.mkdir();
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File path " + dir.getPath() + " must be a directory!");
        }
        for (File file : files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file_notUsed, String name) {
                return name.startsWith("structure") && name.endsWith(".xml");
            }
        })) {
            try {
                WarpDrive.logger.info("Loading structure data file " + file.getName());
                StructureManager.loadXmlStructureFile(file);
                WarpDrive.logger.info("Finished loading structure data file " + file.getName());
            }
            catch (Exception e) {
                WarpDrive.logger.error("Error loading file " + file.getName() + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private static void loadXmlStructureFile(File f) throws SAXException, IOException, InvalidXmlException {
        Document base = WarpDriveConfig.getXmlDocumentBuilder().parse(f);
        XmlPreprocessor.ModCheckResults res = XmlPreprocessor.checkModRequirements(base.getDocumentElement());
        if (!res.isEmpty()) {
            WarpDrive.logger.info("Skippping structure data file " + f.getName() + " because of: " + res);
            return;
        }
        XmlPreprocessor.doModReqSanitation(base);
        XmlPreprocessor.doLogicPreprocessing(base);
        NodeList structures = base.getElementsByTagName("structure");
        for (int i = 0; i < structures.getLength(); ++i) {
            Element struct = (Element)structures.item(i);
            String group = struct.getAttribute("group");
            String name = struct.getAttribute("name");
            WarpDrive.logger.info("Loading structure " + name);
            if (group.isEmpty()) {
                throw new InvalidXmlException("Structure must have a group!");
            }
            int radius = 0;
            if (group.equalsIgnoreCase("star")) {
                stars.loadFromXML(new Star(radius), struct);
                continue;
            }
            if (group.equalsIgnoreCase("moon")) {
                moons.loadFromXML(new Planetoid(radius), struct);
                continue;
            }
            if (!group.equalsIgnoreCase("asteroid")) continue;
            asteroids.loadFromXML(new Asteroid(), struct);
        }
    }

    public static DeployableStructure getStructure(Random random, String name, String type) {
        if (name == null || name.length() == 0) {
            if (type == null || type.length() == 0) {
                return stars.next(random);
            }
            if (type.equalsIgnoreCase("star")) {
                return stars.next(random);
            }
            if (type.equalsIgnoreCase("moon")) {
                return moons.next(random);
            }
            if (type.equalsIgnoreCase("asteroid")) {
                return asteroids.next(random);
            }
        } else {
            for (Star star : stars.elements()) {
                if (!star.getName().equals(name)) continue;
                return star;
            }
        }
        return null;
    }

    public static DeployableStructure getStar(Random random, String name) {
        return StructureManager.getStructure(random, name, "star");
    }

    public static DeployableStructure getMoon(Random random, String name) {
        return StructureManager.getStructure(random, name, "moon");
    }

    public static DeployableStructure getAsteroid(Random random, String name) {
        return StructureManager.getStructure(random, name, "asteroid");
    }

    public static DeployableStructure getGasCloud(Random random, String name) {
        return StructureManager.getStructure(random, name, "cloud");
    }

    private static class RandomCollection<E extends XmlRepresentable> {
        private final NavigableMap<Double, E> weightMap = new TreeMap<Double, E>();
        private double totalWeight = 0.0;
        private final NavigableMap<Double, E> ratioMap = new TreeMap<Double, E>();
        private double totalRatio = 0.0;
        private final ArrayList<E> list = new ArrayList();

        private RandomCollection() {
        }

        public void add(double weight, E obj) {
            if (weight <= 0.0) {
                WarpDrive.logger.warn("Structure weight is negative or zero, skipping");
                return;
            }
            this.totalWeight += weight;
            this.weightMap.put(this.totalWeight, obj);
            this.list.add(obj);
        }

        public void addRatio(double ratio, E obj) {
            if (ratio <= 0.0 || ratio >= 1.0) {
                WarpDrive.logger.warn("Structure ratio isn't in (0, 1.0] bounds, skipping");
                return;
            }
            if (this.totalRatio + ratio > 1.0) {
                WarpDrive.logger.warn("Structures total ratio is greater than 1.0, skipping");
                return;
            }
            this.totalRatio += ratio;
            this.ratioMap.put(this.totalRatio, obj);
            this.list.add(obj);
        }

        public E next(Random random) {
            double value = random.nextDouble();
            if (value < this.totalRatio) {
                return (E)((XmlRepresentable)this.ratioMap.ceilingEntry(value).getValue());
            }
            double weight = (value - this.totalRatio) * this.totalWeight;
            return (E)((XmlRepresentable)this.weightMap.ceilingEntry(weight).getValue());
        }

        public ArrayList<E> elements() {
            return this.list;
        }

        public void loadFromXML(E obj, Element struct) throws InvalidXmlException {
            block6: {
                obj.loadFromXmlElement(struct);
                try {
                    String ratioStr = struct.getAttribute("ratio");
                    if (!ratioStr.isEmpty()) {
                        double ratio = Double.parseDouble(ratioStr);
                        this.addRatio(ratio, obj);
                        break block6;
                    }
                    try {
                        int weight = 1;
                        String weightStr = struct.getAttribute("weight");
                        if (!weightStr.isEmpty()) {
                            weight = Integer.parseInt(weightStr);
                            weight = Math.max(1, weight);
                        }
                        this.add(weight, obj);
                    }
                    catch (NumberFormatException gdbg) {
                        throw new InvalidXmlException("Weight must be int!");
                    }
                }
                catch (NumberFormatException gdbg) {
                    throw new InvalidXmlException("Ratio must be double!");
                }
            }
        }
    }
}

