/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.XmlRepresentable;
import cr0s.warpdrive.config.filler.FillerManager;
import cr0s.warpdrive.config.filler.FillerSet;
import cr0s.warpdrive.config.structures.DeployableStructure;
import cr0s.warpdrive.world.EntitySphereGen;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class Orb
extends DeployableStructure
implements XmlRepresentable {
    private OrbShell[] shellRelative;
    private ArrayList<OrbShell> shells;
    private String name;

    public int getRadius() {
        return this.height / 2;
    }

    public void setRadius(int radius) {
        this.height = radius * 2;
        this.length = radius * 2;
        this.width = radius * 2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Orb(int radius) {
        super(radius * 2, radius * 2, radius * 2);
        this.setRadius(radius);
    }

    @Override
    public void loadFromXmlElement(Element e) throws InvalidXmlException {
        this.name = e.getAttribute("name");
        ArrayList<OrbShell> newShells = new ArrayList<OrbShell>();
        int totalThickness = 0;
        NodeList shells = e.getElementsByTagName("shell");
        for (int i = 0; i < shells.getLength(); ++i) {
            Element tmp = (Element)shells.item(i);
            OrbShell shell = new OrbShell();
            shell.loadFromXmlElement(tmp);
            shell.finishContruction();
            totalThickness += shell.thickness;
            newShells.add(shell);
        }
        int index = 0;
        this.shellRelative = new OrbShell[totalThickness];
        for (OrbShell shell : newShells) {
            for (int i = 0; i < shell.thickness; ++i) {
                this.shellRelative[index++] = shell;
            }
        }
        this.setRadius(totalThickness - 1);
    }

    @Override
    public void saveToXmlElement(Element e, Document d) {
        for (OrbShell shell : this.shells) {
            Element tmp = d.createElement("shell");
            shell.saveToXmlElement(tmp, d);
            e.appendChild(tmp);
        }
    }

    public boolean func_76484_a(World world, Random p_76484_2_, int x, int y, int z) {
        EntitySphereGen entitySphereGen = new EntitySphereGen(world, x, y, z, this.getRadius(), this, true);
        world.func_72838_d((Entity)entitySphereGen);
        return false;
    }

    public boolean generate(World world, Random p_76484_2_, int x, int y, int z, int radius) {
        EntitySphereGen entitySphereGen = new EntitySphereGen(world, x, y, z, radius, this, true);
        world.func_72838_d((Entity)entitySphereGen);
        return false;
    }

    public OrbShell getShellForRadius(int r) {
        return this.shellRelative[r];
    }

    public class OrbShell
    extends FillerSet {
        private int thickness;

        public int getThickness() {
            return this.thickness;
        }

        public void setThickness(int thickness) {
            this.thickness = thickness;
        }

        public OrbShell() {
            super("");
        }

        @Override
        public void loadFromXmlElement(Element e) throws InvalidXmlException {
            WarpDrive.logger.info("Loading shell " + e.getAttribute("name"));
            Orb.this.name = e.getAttribute("name");
            super.loadFromXmlElement(e);
            if (e.hasAttribute("fillerSets")) {
                String[] imports;
                for (String imp : imports = e.getAttribute("fillerSets").split(",")) {
                    FillerSet fillSet = FillerManager.getFillerSet(imp);
                    if (fillSet == null) {
                        throw new InvalidXmlException("Shell loading tries to import a non-existant fillerSet!");
                    }
                    super.loadFrom(fillSet);
                }
            }
            try {
                this.thickness = Integer.parseInt(e.getAttribute("maxThickness"));
            }
            catch (NumberFormatException ex) {
                throw new InvalidXmlException("MaxThickness is not valid!");
            }
        }

        @Override
        public void saveToXmlElement(Element e, Document d) {
        }
    }
}

