/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.MetaBlock;
import cr0s.warpdrive.config.structures.Orb;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import org.w3c.dom.Element;

public class Asteroid
extends Orb {
    private static final int MIN_RADIUS = 1;
    private static final int CORE_MAX_TRIES = 10;
    private Block coreBlock;
    private int maxCoreSize;
    private int minCoreSize;
    private double coreRad;

    public Asteroid() {
        super(0);
    }

    @Override
    public void loadFromXmlElement(Element e) throws InvalidXmlException {
        super.loadFromXmlElement(e);
        String coreBlockName = e.getAttribute("coreBlock");
        if (coreBlockName.isEmpty()) {
            throw new InvalidXmlException("Asteroid is missing a coreBlock!");
        }
        this.coreBlock = Block.func_149684_b((String)coreBlockName);
        if (this.coreBlock == null) {
            throw new InvalidXmlException("Asteroid coreBlock doesnt exist!");
        }
        try {
            this.maxCoreSize = Integer.parseInt(e.getAttribute("maxCoreSize"));
            this.minCoreSize = Integer.parseInt(e.getAttribute("minCoreSize"));
        }
        catch (NumberFormatException gdbg) {
            throw new InvalidXmlException("Asteroid core size dimensions are NaN!");
        }
        try {
            String coreRadStr = e.getAttribute("coreRad");
            this.coreRad = coreRadStr.isEmpty() ? 0.1 : Double.parseDouble(e.getAttribute("coreRad"));
        }
        catch (NumberFormatException gdbg) {
            throw new InvalidXmlException("Asteroid core rad must be double!");
        }
    }

    @Override
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int randRadius = 1 + rand.nextInt(Math.max(1, this.getRadius() - 1));
        int numberCoreBlocks = this.minCoreSize + rand.nextInt(Math.max(1, this.maxCoreSize - this.minCoreSize));
        WarpDrive.logger.info("Asteroid generation: radius=" + randRadius + ", numCoreBlocks=" + numberCoreBlocks + ", coreRad=" + this.coreRad);
        ArrayList<Location> coreLocations = this.generateCore(world, rand, x, y, z, numberCoreBlocks, this.coreBlock, numberCoreBlocks, randRadius);
        for (Location coreLocation : coreLocations) {
            int maxRadX = Math.min(x + randRadius - coreLocation.x, coreLocation.x - (x - randRadius));
            int maxRadY = Math.min(y + randRadius - coreLocation.y, coreLocation.y - (y - randRadius));
            int maxRadZ = Math.min(z + randRadius - coreLocation.z, coreLocation.z - (z - randRadius));
            int maxLocalRadius = Math.min(maxRadX, Math.min(maxRadY, maxRadZ));
            this.addShell(world, rand, coreLocation, maxLocalRadius);
        }
        return true;
    }

    private void addShell(World world, Random rand, Location l, int maxRad) {
        int rad = maxRad;
        for (int x = l.x - rad; x <= l.x + rad; ++x) {
            for (int y = l.y - rad; y <= l.y + rad; ++y) {
                for (int z = l.z - rad; z <= l.z + rad; ++z) {
                    int r = (int)Math.round(Math.sqrt((l.x - x) * (l.x - x) + (l.y - y) * (l.y - y) + (l.z - z) * (l.z - z)));
                    if (r > rad || !Asteroid.isBlockEmpty(world, x, y, z)) continue;
                    Orb.OrbShell shell = this.getShellForRadius(r);
                    MetaBlock blType = shell.getRandomBlock(rand);
                    world.func_147465_d(x, y, z, blType.block, blType.metadata, 0);
                }
            }
        }
    }

    private static boolean isBlockEmpty(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).isReplaceableOreGen(world, x, y, z, Blocks.field_150350_a);
    }

    private ArrayList<Location> generateCore(World world, Random rand, int x, int y, int z, int numberOfBlocks, Block block, int metadata, int maxRange) {
        ArrayList<Location> addedBlocks = new ArrayList<Location>();
        int coreRange = (int)Math.round(this.coreRad * (double)maxRange);
        int maxX = x + coreRange;
        int minX = x - coreRange;
        int maxY = y + coreRange;
        int minY = y - coreRange;
        int maxZ = z + coreRange;
        int minZ = z - coreRange;
        for (int i = 0; i < numberOfBlocks; ++i) {
            int curX = x;
            int curY = y;
            int curZ = z;
            boolean stopWalk = false;
            for (int step = 0; step <= 10 && !stopWalk; ++step) {
                curX = rand.nextInt(Math.max(1, maxX - minX)) + minX;
                if (!Asteroid.isBlockEmpty(world, curX, curY = rand.nextInt(Math.max(1, maxY - minY)) + minY, curZ = rand.nextInt(Math.max(1, maxZ - minZ)) + minZ)) continue;
                world.func_147465_d(curX, curY, curZ, block, metadata, 2);
                addedBlocks.add(new Location(curX, curY, curZ));
                stopWalk = true;
            }
        }
        return addedBlocks;
    }

    private class Location {
        public int x;
        public int y;
        public int z;

        public Location(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

