/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.filler;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.MetaBlock;
import cr0s.warpdrive.config.XmlRepresentable;
import cr0s.warpdrive.config.filler.FillerFactory;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FillerSet
implements XmlRepresentable,
Comparable {
    private MetaBlock[] weightedFillerBlocks;
    private FillerFactory factory;
    private String name;

    public String getName() {
        return this.name;
    }

    public FillerSet(MetaBlock[] blocks) {
        this.weightedFillerBlocks = blocks;
    }

    public FillerSet(String name) {
        this.name = name;
        this.weightedFillerBlocks = new MetaBlock[1];
        this.factory = new FillerFactory();
    }

    public MetaBlock getRandomBlock(Random rand) {
        return this.weightedFillerBlocks[rand.nextInt(this.weightedFillerBlocks.length)];
    }

    @Override
    public void loadFromXmlElement(Element element) throws InvalidXmlException {
        NodeList fillers = element.getElementsByTagName("filler");
        for (int i = 0; i < fillers.getLength(); ++i) {
            String stringRatio;
            Element filler = (Element)fillers.item(i);
            if (!filler.hasAttribute("block")) {
                throw new InvalidXmlException("Filler " + filler.getBaseURI() + " is missing a block tag!");
            }
            String blockName = filler.getAttribute("block");
            Block block = Block.func_149684_b((String)blockName);
            if (block == null) {
                WarpDrive.logger.warn("Filler " + filler.getBaseURI() + " refers to missing block " + blockName + ": ignoring that entry...");
                continue;
            }
            int metadata = 0;
            String metaString = filler.getAttribute("metadata");
            if (!metaString.isEmpty()) {
                try {
                    metadata = Integer.parseInt(metaString);
                }
                catch (NumberFormatException exception) {
                    throw new InvalidXmlException("Filler " + filler.getBaseURI() + " metadata attribute is NaN!");
                }
            }
            boolean hasWeightOrRatio = false;
            String stringWeight = filler.getAttribute("weight");
            if (!stringWeight.isEmpty()) {
                hasWeightOrRatio = true;
                try {
                    int weight = Integer.parseInt(stringWeight);
                    this.factory.addWeightedBlock(block, metadata, weight);
                }
                catch (NumberFormatException exception) {
                    throw new InvalidXmlException("Filler " + filler.getBaseURI() + " weight is NaN!");
                }
                catch (IllegalArgumentException exception) {
                    throw new InvalidXmlException(exception.getMessage());
                }
            }
            if (!(stringRatio = filler.getAttribute("ratio")).isEmpty()) {
                hasWeightOrRatio = true;
                try {
                    this.factory.addRatioBlock(block, metadata, stringRatio);
                }
                catch (IllegalArgumentException ex) {
                    throw new InvalidXmlException(ex.getMessage());
                }
            }
            if (hasWeightOrRatio) continue;
            throw new InvalidXmlException("Filler " + filler.getBaseURI() + " is missing a weight or a ratio!");
        }
    }

    @Override
    public void saveToXmlElement(Element e, Document d) throws InvalidXmlException {
        throw new InvalidXmlException("Not supported");
    }

    public void finishContruction() {
        WarpDrive.logger.info("Finishing construction of FillerSet " + this.name);
        this.weightedFillerBlocks = this.factory.constructWeightedMetaBlockList();
        for (int i = 0; i < this.weightedFillerBlocks.length; ++i) {
            if (this.weightedFillerBlocks[i] != null) continue;
            this.weightedFillerBlocks[i] = MetaBlock.getMetaBlock(Blocks.field_150350_a, 0);
        }
        this.factory = null;
    }

    public int compareTo(Object obj) {
        return this.name.compareTo(((FillerSet)obj).name);
    }

    public String toString() {
        return this.name;
    }

    public void loadFrom(FillerSet fillerSet) {
        this.factory.addFromFactory(fillerSet.factory);
    }
}

