/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.filler;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlPreprocessor;
import cr0s.warpdrive.config.filler.FillerSet;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FillerManager {
    private static TreeMap<String, FillerSet> fillerSets = new TreeMap();
    static TreeMap<FillerSet, ArrayList<String>> fillerSetsAdditions = new TreeMap();

    public static void loadOres(String oreConfDirectory) {
        FillerManager.loadOres(new File(oreConfDirectory));
    }

    public static void loadOres(File dir) {
        File[] files;
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File path " + dir.getName() + " must be a directory!");
        }
        for (File file : files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file_notUsed, String name) {
                return name.startsWith("filler") && name.endsWith(".xml");
            }
        })) {
            try {
                WarpDrive.logger.info("Loading filler data file " + file.getName() + "...");
                FillerManager.loadXmlFillerFile(file);
                WarpDrive.logger.info("Loading filler data file " + file.getName() + " done");
            }
            catch (Exception exception) {
                WarpDrive.logger.error("Error loading file " + file.getName() + ": " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private static void loadXmlFillerFile(File file) throws InvalidXmlException, SAXException, IOException {
        Document base = WarpDriveConfig.getXmlDocumentBuilder().parse(file);
        XmlPreprocessor.ModCheckResults res = XmlPreprocessor.checkModRequirements(base.getDocumentElement());
        if (!res.isEmpty()) {
            WarpDrive.logger.info("Skippping filler data file " + file.getName() + " because of: " + res);
            return;
        }
        XmlPreprocessor.doModReqSanitation(base);
        XmlPreprocessor.doLogicPreprocessing(base);
        NodeList nodesFillerSet = base.getElementsByTagName("FillerSet");
        for (int i = 0; i < nodesFillerSet.getLength(); ++i) {
            Element elementFillerSet = (Element)nodesFillerSet.item(i);
            String group = elementFillerSet.getAttribute("group");
            if (group.isEmpty()) {
                throw new InvalidXmlException("FillerSet " + i + " is missing a group attribute!");
            }
            FillerSet fillerSet = fillerSets.get(group);
            if (fillerSet == null) {
                fillerSet = new FillerSet(group);
                fillerSets.put(group, fillerSet);
            }
            if (elementFillerSet.hasAttribute("fillerSets")) {
                ArrayList<String> setUnresolvedDeps = fillerSetsAdditions.get(fillerSet);
                if (setUnresolvedDeps == null) {
                    setUnresolvedDeps = new ArrayList();
                    fillerSetsAdditions.put(fillerSet, setUnresolvedDeps);
                }
                setUnresolvedDeps.addAll(Arrays.asList(elementFillerSet.getAttribute("import").split(",")));
            }
            fillerSet.loadFromXmlElement(elementFillerSet);
        }
    }

    public static void finishLoading() {
        while (!fillerSetsAdditions.isEmpty()) {
            FillerManager.attemptDependencyFilling(fillerSetsAdditions);
        }
        for (FillerSet fillerSet : fillerSets.values()) {
            fillerSet.finishContruction();
        }
    }

    private static void attemptDependencyFilling(TreeMap<FillerSet, ArrayList<String>> fillerSetsDeps) {
        ArrayList<FillerSet> toRemove = new ArrayList<FillerSet>();
        for (Map.Entry<FillerSet, ArrayList<String>> entry : fillerSetsDeps.entrySet()) {
            for (String dep : entry.getValue()) {
                if (!fillerSets.containsKey(dep)) {
                    WarpDrive.logger.error("A fillerSet " + entry.getKey() + " has a dependency that doesnt exist!");
                    fillerSets.remove(entry.getKey().getName());
                    toRemove.add(entry.getKey());
                    continue;
                }
                if (fillerSetsDeps.containsKey(fillerSets.get(dep))) continue;
                entry.getKey().loadFrom(fillerSets.get(dep));
                toRemove.add(entry.getKey());
            }
        }
        for (FillerSet set : toRemove) {
            fillerSetsDeps.remove(set);
        }
    }

    public static FillerSet getFillerSet(String name) {
        return fillerSets.get(name);
    }
}

