/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.filler;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.MetaBlock;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;

public class FillerFactory {
    private TreeMap<MetaBlock, Integer> metaBlocksWeight;
    private TreeMap<MetaBlock, Integer> convertedRatioMetaBlocks;
    private int totalWeightNeeded;
    private int totalWeightWeightedBlocks;
    private Object lock = new Object();
    private TreeMap<MetaBlock, String> addedRatioMetaBlocks;

    public FillerFactory() {
        this.init();
    }

    private void init() {
        this.metaBlocksWeight = new TreeMap();
        this.convertedRatioMetaBlocks = new TreeMap();
        this.totalWeightNeeded = 0;
        this.totalWeightWeightedBlocks = 0;
        this.addedRatioMetaBlocks = new TreeMap();
    }

    public void reset() {
        this.init();
    }

    public void addWeightedBlock(Block b, int metadata, int weight) {
        this.addWeightedMetaBlock(MetaBlock.getMetaBlock(b, metadata), weight);
    }

    public void addWeightedMetaBlock(MetaBlock mb, int weight) {
        this.metaBlocksWeight.put(mb, weight);
        this.totalWeightWeightedBlocks += weight;
    }

    public void addRatioBlock(Block b, int metadata, String ratio) {
        this.addRatioMetaBlock(MetaBlock.getMetaBlock(b, metadata), ratio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRatioMetaBlock(MetaBlock mb, String ratio) {
        this.addedRatioMetaBlocks.put(mb, ratio);
        Object object = this.lock;
        synchronized (object) {
            int sigFig;
            ratio = ratio.trim();
            if (Double.parseDouble(ratio) > 1.0) {
                throw new IllegalArgumentException("Ratio must be less than one");
            }
            int lastDot = ratio.lastIndexOf(46);
            for (sigFig = ratio.length() - 1; sigFig > lastDot && ratio.charAt(sigFig) == '0'; --sigFig) {
            }
            if (sigFig <= lastDot) {
                throw new IllegalArgumentException("Ratio must be greater than zero");
            }
            int ratioInt = Integer.parseInt(ratio.substring(lastDot + 1, sigFig + 1));
            int digits = sigFig - lastDot;
            int weightNeeded = (int)Math.pow(10.0, digits);
            if (weightNeeded > this.totalWeightNeeded) {
                int additionalPowersNeeded = this.totalWeightNeeded / weightNeeded;
                for (Map.Entry<MetaBlock, Integer> entry : this.convertedRatioMetaBlocks.entrySet()) {
                    this.convertedRatioMetaBlocks.put(entry.getKey(), entry.getValue() * additionalPowersNeeded);
                }
                this.totalWeightNeeded = weightNeeded;
            } else if (weightNeeded < this.totalWeightNeeded) {
                int additionalPowersNeeded = weightNeeded / this.totalWeightNeeded;
                ratioInt *= additionalPowersNeeded;
            }
            this.convertedRatioMetaBlocks.put(mb, ratioInt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaBlock[] constructWeightedMetaBlockList() {
        Object object = this.lock;
        synchronized (object) {
            if (this.convertedRatioMetaBlocks.isEmpty()) {
                MetaBlock[] list = new MetaBlock[this.totalWeightWeightedBlocks];
                int index = 0;
                for (Map.Entry<MetaBlock, Integer> entry : this.metaBlocksWeight.entrySet()) {
                    for (int i = 0; i < entry.getValue(); ++i) {
                        list[index++] = entry.getKey();
                    }
                }
                return list;
            }
            MetaBlock[] list = new MetaBlock[this.totalWeightNeeded];
            int ratioTotalWeightUsed = 0;
            int index = 0;
            for (Map.Entry<MetaBlock, Integer> entry : this.convertedRatioMetaBlocks.entrySet()) {
                for (int i = 0; i < entry.getValue(); ++i) {
                    list[index++] = entry.getKey();
                }
                ratioTotalWeightUsed += entry.getValue().intValue();
            }
            int remainingWeight = this.totalWeightNeeded - ratioTotalWeightUsed;
            if (remainingWeight < 0) {
                throw new IllegalArgumentException("Ratios add up to more than 100%");
            }
            if (remainingWeight == 0) {
                WarpDrive.logger.info("Ratios add up perfectly to 100%, skipping weights");
            } else {
                for (Map.Entry<MetaBlock, Integer> entry : this.metaBlocksWeight.entrySet()) {
                    int converted = entry.getValue() * remainingWeight / this.totalWeightWeightedBlocks;
                    for (int i = 0; i < converted; ++i) {
                        list[index++] = entry.getKey();
                    }
                }
            }
            return list;
        }
    }

    public void addFromFactory(FillerFactory factory) {
        for (Map.Entry<MetaBlock, String> entry : factory.addedRatioMetaBlocks.entrySet()) {
            this.addRatioMetaBlock(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<MetaBlock, Object> entry : factory.metaBlocksWeight.entrySet()) {
            this.addWeightedMetaBlock(entry.getKey(), (Integer)entry.getValue());
        }
    }
}

