/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cpw.mods.fml.common.Loader;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlPreprocessor {
    public static ModCheckResults checkModRequirements(Element e) {
        ModCheckResults modErrors = new ModCheckResults();
        for (String mod : e.getAttribute("mods").split(",")) {
            if (mod.isEmpty()) continue;
            if (mod.startsWith("!")) {
                if (!Loader.isModLoaded((String)mod.substring(1))) continue;
                modErrors.addMod(mod, "loaded");
                continue;
            }
            if (Loader.isModLoaded((String)mod)) continue;
            modErrors.addMod(mod, "not loaded");
        }
        return modErrors;
    }

    public static void doModReqSanitation(Node base) {
        NodeList children = base.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            ModCheckResults res = XmlPreprocessor.checkModRequirements((Element)child);
            if (!res.isEmpty()) {
                base.removeChild(child);
                WarpDrive.logger.info("Removed child element " + child.getBaseURI() + " of element " + base.getBaseURI() + ", results: " + res);
                continue;
            }
            XmlPreprocessor.doModReqSanitation(child);
        }
    }

    public static void doLogicPreprocessing(Node root) throws InvalidXmlException {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XmlPreprocessor.doLogicPreprocessing(children.item(i));
        }
        if (root.getNodeType() == 1 && ((Element)root).getTagName().equalsIgnoreCase("for")) {
            Element forTag = (Element)root;
            String varName = forTag.getAttribute("variable");
            if (varName.isEmpty()) {
                throw new InvalidXmlException("A for tag must include a variable attribute!");
            }
            if (forTag.hasAttribute("in")) {
                String inOptions = forTag.getAttribute("in");
                for (String input : inOptions.split(",")) {
                    NodeList allChildren = root.getChildNodes();
                    for (int chI = 0; chI < allChildren.getLength(); ++chI) {
                        Node copy = XmlPreprocessor.getCopyVarReplace(allChildren.item(chI), varName, input);
                        root.getParentNode().appendChild(copy);
                    }
                }
            } else {
                int to;
                String fromStr = forTag.getAttribute("from");
                String toStr = forTag.getAttribute("to");
                if (toStr.isEmpty() || fromStr.isEmpty()) {
                    throw new InvalidXmlException("If a for doesnt have an in attr, it must have a from and to!");
                }
                try {
                    to = Integer.parseInt(toStr);
                }
                catch (NumberFormatException e) {
                    throw new InvalidXmlException(e);
                }
                for (int from = Integer.parseInt(fromStr); from <= to; ++from) {
                    NodeList allChildren = root.getChildNodes();
                    for (int chI = 0; chI < allChildren.getLength(); ++chI) {
                        Node copy = XmlPreprocessor.getCopyVarReplace(allChildren.item(chI), varName, "" + from);
                        root.getParentNode().appendChild(copy);
                    }
                }
            }
            root.getParentNode().removeChild(root);
        }
    }

    private static Node getCopyVarReplace(Node toCopy, String varName, String value) {
        Node copy = toCopy.cloneNode(true);
        XmlPreprocessor.replaceVar(copy, varName, value);
        return copy;
    }

    private static void replaceVar(Node root, String varName, String value) {
        ArrayList<String> toRemove = new ArrayList<String>();
        ArrayList<Attr> toAdd = new ArrayList<Attr>();
        if (root.getNodeType() == 1) {
            NamedNodeMap attrs = root.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String newName;
                Attr attr = (Attr)attrs.item(i);
                String name = attr.getName();
                if (name.equals(newName = name.replace("%" + varName + "%", value))) {
                    attr.setValue(attr.getValue().replace("%" + varName + "%", value));
                    continue;
                }
                toRemove.add(name);
                Attr newAttr = attr.getOwnerDocument().createAttribute(newName);
                newAttr.setValue(attr.getValue().replace("%" + varName + "%", value));
                toAdd.add(newAttr);
            }
            for (String string : toRemove) {
                attrs.removeNamedItem(string);
            }
            for (Attr attr : toAdd) {
                attrs.setNamedItem(attr);
            }
        }
        NodeList children = root.getChildNodes();
        block7: for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    XmlPreprocessor.replaceVar(node, varName, value);
                    continue block7;
                }
                case 3: {
                    node.setTextContent(node.getTextContent().replace("%" + varName + "%", value));
                }
            }
        }
    }

    public static class ModCheckResults {
        private TreeMap<String, String> mods = new TreeMap();

        public void addMod(String name, String error) {
            this.mods.put(name, error);
        }

        public boolean isEmpty() {
            return this.mods.isEmpty();
        }

        public String toString() {
            String s = "{";
            for (Map.Entry<String, String> e : this.mods.entrySet()) {
                s = s + e.getKey() + ": " + e.getValue() + ", ";
            }
            return s + "}";
        }
    }
}

