/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import java.util.HashMap;
import net.minecraft.block.Block;

public class MetaBlock
implements Comparable {
    public static final int MAX_METADATA = 16;
    private static HashMap<String, MetaBlock[]> metablocks = new HashMap();
    public final Block block;
    public final int metadata;

    private MetaBlock(Block block, int metadata) {
        this.block = block;
        this.metadata = metadata;
    }

    public static MetaBlock getMetaBlock(Block block, int metadata) {
        if (block == null) {
            throw new IllegalArgumentException("Block can't be null");
        }
        if (metadata < 0 || metadata >= 16) {
            throw new IllegalArgumentException("Metadata out of range in " + block.func_149739_a() + ":" + metadata + ". Expecting 0 to " + 15);
        }
        MetaBlock[] metablock = metablocks.get(block.func_149739_a());
        if (metablock == null) {
            metablock = new MetaBlock[16];
            metablocks.put(block.func_149739_a(), metablock);
        }
        if (metablock[metadata] == null) {
            metablock[metadata] = new MetaBlock(block, metadata);
        }
        return metablock[metadata];
    }

    public int compareTo(Object object) {
        int strComp = this.block.func_149739_a().compareTo(((MetaBlock)object).block.func_149739_a());
        return strComp != 0 ? strComp : this.metadata - ((MetaBlock)object).metadata;
    }

    public String toString() {
        return this.block.func_149739_a() + ":" + this.metadata;
    }

    public int hashCode() {
        return Block.func_149682_b((Block)this.block) << 4 + this.metadata;
    }
}

