/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.world.SpaceTeleporter;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;

public class CommandSpace
extends CommandBase {
    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "space";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        int newZ;
        int newY;
        int newX;
        WorldServer targetWorld;
        if (sender == null) {
            return;
        }
        MinecraftServer server = MinecraftServer.func_71276_C();
        int targetDimensionId = Integer.MAX_VALUE;
        EntityPlayerMP player = null;
        if (sender instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)sender;
        }
        if (args.length != 0) {
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
                    WarpDrive.addChatMessage(sender, this.func_71518_a(sender));
                    return;
                }
                EntityPlayerMP playerFound = this.getOnlinePlayerByName(args[0]);
                if (playerFound != null) {
                    player = playerFound;
                } else {
                    targetDimensionId = this.getDimensionId(args[0]);
                }
            } else if (args.length == 2) {
                player = this.getOnlinePlayerByName(args[0]);
                targetDimensionId = this.getDimensionId(args[1]);
            } else {
                WarpDrive.addChatMessage(sender, "/space: too many arguments " + args.length);
                return;
            }
        }
        if (player == null) {
            WarpDrive.addChatMessage(sender, "/space: undefined player");
            return;
        }
        if (targetDimensionId == Integer.MAX_VALUE) {
            targetDimensionId = player.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID ? 0 : WarpDriveConfig.G_SPACE_DIMENSION_ID;
        }
        if ((targetWorld = server.func_71218_a(targetDimensionId)) == null) {
            WarpDrive.addChatMessage(sender, "/space: undefined dimension " + targetDimensionId);
            return;
        }
        String message = "Teleporting player " + player.func_70005_c_() + " to dimension " + targetDimensionId + "...";
        WarpDrive.addChatMessage(sender, message);
        WarpDrive.logger.info(message);
        if (sender != player) {
            WarpDrive.addChatMessage((ICommandSender)player, sender.func_70005_c_() + " is teleporting you to dimension " + targetDimensionId);
        }
        if ((targetWorld.func_147437_c(newX = MathHelper.func_76128_c((double)player.field_70165_t), (newY = Math.min(255, Math.max(0, MathHelper.func_76128_c((double)player.field_70163_u)))) - 1, newZ = MathHelper.func_76128_c((double)player.field_70161_v)) && !player.field_71075_bZ.field_75101_c || !targetWorld.func_147437_c(newX, newY, newZ) || !targetWorld.func_147437_c(newX, newY + 1, newZ)) && (newY = targetWorld.func_72825_h(newX, newZ) + 1) == 0) {
            newY = 128;
        }
        SpaceTeleporter teleporter = new SpaceTeleporter(targetWorld, 0, newX, newY, newZ);
        server.func_71203_ab().transferPlayerToDimension(player, targetDimensionId, (Teleporter)teleporter);
        player.func_70634_a((double)newX + 0.5, (double)newY + 0.05, (double)newZ + 0.5);
        player.func_71016_p();
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return "/space (<playerName>) ([overworld|nether|end|theend|space|hyper|hyperspace|<dimensionId>])";
    }

    private EntityPlayerMP getOnlinePlayerByName(String playerName) {
        List onlinePlayers = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayer onlinePlayer : onlinePlayers) {
            if (!onlinePlayer.func_70005_c_().equalsIgnoreCase(playerName) || !(onlinePlayer instanceof EntityPlayerMP)) continue;
            return (EntityPlayerMP)onlinePlayer;
        }
        return null;
    }

    private int getDimensionId(String stringDimension) {
        if (stringDimension.equalsIgnoreCase("overworld")) {
            return 0;
        }
        if (stringDimension.equalsIgnoreCase("nether")) {
            return -1;
        }
        if (stringDimension.equalsIgnoreCase("end") || stringDimension.equalsIgnoreCase("theend")) {
            return 1;
        }
        if (stringDimension.equalsIgnoreCase("space")) {
            return WarpDriveConfig.G_SPACE_DIMENSION_ID;
        }
        if (stringDimension.equalsIgnoreCase("hyper") || stringDimension.equalsIgnoreCase("hyperspace")) {
            return WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID;
        }
        try {
            return Integer.parseInt(stringDimension);
        }
        catch (Exception exception) {
            WarpDrive.logger.info("/space: invalid dimension '" + stringDimension + "', expecting integer or overworld/nether/end/theend/space/hyper/hyperspace");
            return 0;
        }
    }
}

