/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.passive;

import cpw.mods.fml.common.FMLCommonHandler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.render.RenderBlockStandard;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAir
extends Block {
    private final boolean TRANSPARENT_AIR = true;
    private final boolean AIR_DEBUG = false;
    private final int AIR_BLOCK_TICKS = 40;
    private IIcon[] iconBuffer;

    public BlockAir() {
        super(Material.field_151581_o);
        this.func_149711_c(0.0f);
        this.func_149663_c("warpdrive.passive.Air");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isAir(IBlockAccess var1, int var2, int var3, int var4) {
        return true;
    }

    public AxisAlignedBB func_149668_a(World var1, int var2, int var3, int var4) {
        return null;
    }

    public boolean isReplaceable(IBlockAccess var1, int var2, int var3, int var4) {
        return true;
    }

    public boolean func_149742_c(World var1, int var2, int var3, int var4) {
        return true;
    }

    public boolean func_149678_a(int var1, boolean var2) {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("warpdrive:passive/airBlock");
    }

    public IIcon func_149691_a(int side, int metadata) {
        return this.field_149761_L;
    }

    public int func_149656_h() {
        return 1;
    }

    public Item func_149650_a(int var1, Random var2, int var3) {
        return null;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public int func_149738_a(World par1World) {
        return 40;
    }

    public void func_149674_a(World par1World, int x, int y, int z, Random par5Random) {
        boolean isInSpaceWorld;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        int concentration = par1World.func_72805_g(x, y, z);
        boolean bl = isInSpaceWorld = par1World.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID || par1World.field_73011_w.field_76574_g == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID;
        if (concentration <= 0 || !isInSpaceWorld) {
            par1World.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
        } else {
            this.spreadAirBlock(par1World, x, y, z, concentration);
        }
        par1World.func_147464_a(x, y, z, (Block)this, 30 + 2 * concentration);
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Block sideBlock = world.func_147439_a(x, y, z);
        if (sideBlock == this) {
            return false;
        }
        return world.func_147437_c(x, y, z);
    }

    public int func_149645_b() {
        return RenderBlockStandard.renderId;
    }

    private void spreadAirBlock(World world, int x, int y, int z, int concentration) {
        int new_concentration;
        int mid_concentration;
        boolean isGrowth;
        int zn_concentration;
        int zp_concentration;
        int yn_concentration;
        int yp_concentration;
        int xn_concentration;
        int xp_concentration;
        int air_count = 1;
        int empty_count = 0;
        int sum_concentration = concentration + 1;
        int max_concentration = concentration + 1;
        int min_concentration = concentration + 1;
        Block xp_block = world.func_147439_a(x + 1, y, z);
        boolean xp_isAir = world.func_147437_c(x + 1, y, z);
        int n = xp_concentration = xp_block != this ? -1 : world.func_72805_g(x + 1, y, z);
        if (xp_isAir) {
            ++air_count;
            if (xp_concentration >= 0) {
                sum_concentration += xp_concentration + 1;
                max_concentration = Math.max(max_concentration, xp_concentration + 1);
                min_concentration = Math.min(min_concentration, xp_concentration + 1);
            } else {
                ++empty_count;
            }
        }
        Block xn_block = world.func_147439_a(x - 1, y, z);
        boolean xn_isAir = world.func_147437_c(x - 1, y, z);
        int n2 = xn_concentration = xn_block != this ? -1 : world.func_72805_g(x - 1, y, z);
        if (xn_isAir) {
            ++air_count;
            if (xn_concentration >= 0) {
                sum_concentration += xn_concentration + 1;
                max_concentration = Math.max(max_concentration, xn_concentration + 1);
                min_concentration = Math.min(min_concentration, xn_concentration + 1);
            } else {
                ++empty_count;
            }
        }
        Block yp_block = world.func_147439_a(x, y + 1, z);
        boolean yp_isAir = world.func_147437_c(x, y + 1, z);
        int n3 = yp_concentration = yp_block != this ? -1 : world.func_72805_g(x, y + 1, z);
        if (yp_isAir) {
            ++air_count;
            if (yp_concentration >= 0) {
                sum_concentration += yp_concentration + 1;
                max_concentration = Math.max(max_concentration, yp_concentration + 1);
                min_concentration = Math.min(min_concentration, yp_concentration + 1);
            } else {
                ++empty_count;
            }
        }
        Block yn_block = world.func_147439_a(x, y - 1, z);
        boolean yn_isAir = world.func_147437_c(x, y - 1, z);
        int n4 = yn_concentration = yn_block != this ? -1 : world.func_72805_g(x, y - 1, z);
        if (yn_isAir) {
            ++air_count;
            if (yn_concentration >= 0) {
                sum_concentration += yn_concentration + 1;
                max_concentration = Math.max(max_concentration, yn_concentration + 1);
                min_concentration = Math.min(min_concentration, yn_concentration + 1);
            } else {
                ++empty_count;
            }
        }
        Block zp_block = world.func_147439_a(x, y, z + 1);
        boolean zp_isAir = world.func_147437_c(x, y, z + 1);
        int n5 = zp_concentration = zp_block != this ? -1 : world.func_72805_g(x, y, z + 1);
        if (zp_isAir) {
            ++air_count;
            if (zp_concentration >= 0) {
                sum_concentration += zp_concentration + 1;
                max_concentration = Math.max(max_concentration, zp_concentration + 1);
                min_concentration = Math.min(min_concentration, zp_concentration + 1);
            } else {
                ++empty_count;
            }
        }
        Block zn_block = world.func_147439_a(x, y, z - 1);
        boolean zn_isAir = world.func_147437_c(x, y, z - 1);
        int n6 = zn_concentration = zn_block != this ? -1 : world.func_72805_g(x, y, z - 1);
        if (zn_isAir) {
            ++air_count;
            if (zn_concentration >= 0) {
                sum_concentration += zn_concentration + 1;
                max_concentration = Math.max(max_concentration, zn_concentration + 1);
                min_concentration = Math.min(min_concentration, zn_concentration + 1);
            } else {
                ++empty_count;
            }
        }
        if (empty_count > 0) {
            sum_concentration = concentration < 8 ? (sum_concentration -= empty_count) : (concentration < 4 ? (sum_concentration -= empty_count + (world.field_73012_v.nextBoolean() ? 0 : empty_count)) : (sum_concentration -= air_count));
        }
        if (sum_concentration < 0) {
            sum_concentration = 0;
        }
        boolean bl = isGrowth = max_concentration > 8 && max_concentration - min_concentration < 9 || max_concentration > 5 && max_concentration - min_concentration < 4;
        if (isGrowth) {
            mid_concentration = Math.round((float)sum_concentration / (float)air_count) - 1;
            new_concentration = sum_concentration - mid_concentration * (air_count - 1);
            new_concentration = Math.max(Math.max(concentration + 1, max_concentration - 1), new_concentration - 20) - 0;
        } else {
            mid_concentration = 0;
            new_concentration = 0;
            mid_concentration = (int)Math.floor((float)sum_concentration / (float)air_count);
            new_concentration = sum_concentration - mid_concentration * (air_count - 1);
            if (empty_count > 0) {
                new_concentration = Math.max(0, new_concentration - 5);
            }
        }
        if (mid_concentration < 1) {
            mid_concentration = 0;
        } else if (mid_concentration > 14) {
            mid_concentration = 14;
        } else if (mid_concentration > 0) {
            --mid_concentration;
        }
        new_concentration = new_concentration < 1 ? 0 : (new_concentration > max_concentration - 2 ? Math.max(0, max_concentration - 2) : --new_concentration);
        if (WarpDriveConfig.LOGGING_BREATHING && (new_concentration < 0 || mid_concentration < 0 || new_concentration > 14 || mid_concentration > 14)) {
            WarpDrive.logger.info("Invalid concentration at step B " + isGrowth + " " + concentration + " + " + xp_concentration + " " + xn_concentration + " " + yp_concentration + " " + yn_concentration + " " + zp_concentration + " " + zn_concentration + " = " + sum_concentration + " total, " + empty_count + " empty / " + air_count + " -> " + new_concentration + " + " + (air_count - 1) + " * " + mid_concentration);
        }
        if (concentration != new_concentration) {
            if (concentration == 15) {
                if (xp_block != WarpDrive.blockAirGenerator && xn_block != WarpDrive.blockAirGenerator && yp_block != WarpDrive.blockAirGenerator && yn_block != WarpDrive.blockAirGenerator && zp_block != WarpDrive.blockAirGenerator && zn_block != WarpDrive.blockAirGenerator) {
                    if (WarpDriveConfig.LOGGING_BREATHING) {
                        WarpDrive.logger.info("AirGenerator not found, removing air block at " + x + ", " + y + ", " + z);
                    }
                    world.func_72921_c(x, y, z, 1, 2);
                }
            } else {
                world.func_72921_c(x, y, z, new_concentration, 2);
            }
        }
        if (xp_isAir) {
            if (xp_block == this) {
                if (!(xp_concentration == mid_concentration || xp_concentration == 15 || isGrowth && xp_concentration >= mid_concentration)) {
                    world.func_72921_c(x + 1, y, z, mid_concentration, 2);
                }
            } else {
                world.func_147465_d(x + 1, y, z, (Block)this, mid_concentration, 2);
            }
        }
        if (xn_isAir) {
            if (xn_block == this) {
                if (!(xn_concentration == mid_concentration || xn_concentration == 15 || isGrowth && xn_concentration >= mid_concentration)) {
                    world.func_72921_c(x - 1, y, z, mid_concentration, 2);
                }
            } else {
                world.func_147465_d(x - 1, y, z, (Block)this, mid_concentration, 2);
            }
        }
        if (yp_isAir) {
            if (yp_block == this) {
                if (!(yp_concentration == mid_concentration || yp_concentration == 15 || isGrowth && yp_concentration >= mid_concentration)) {
                    world.func_72921_c(x, y + 1, z, mid_concentration, 2);
                }
            } else {
                world.func_147465_d(x, y + 1, z, (Block)this, mid_concentration, 2);
            }
        }
        if (yn_isAir) {
            if (yn_block == this) {
                if (!(yn_concentration == mid_concentration || yn_concentration == 15 || isGrowth && yn_concentration >= mid_concentration)) {
                    world.func_72921_c(x, y - 1, z, mid_concentration, 2);
                }
            } else {
                world.func_147465_d(x, y - 1, z, (Block)this, mid_concentration, 2);
            }
        }
        if (zp_isAir) {
            if (zp_block == this) {
                if (!(zp_concentration == mid_concentration || zp_concentration == 15 || isGrowth && zp_concentration >= mid_concentration)) {
                    world.func_72921_c(x, y, z + 1, mid_concentration, 2);
                }
            } else {
                world.func_147465_d(x, y, z + 1, (Block)this, mid_concentration, 2);
            }
        }
        if (zn_isAir) {
            if (zn_block == this) {
                if (!(zn_concentration == mid_concentration || zn_concentration == 15 || isGrowth && zn_concentration >= mid_concentration)) {
                    world.func_72921_c(x, y, z - 1, mid_concentration, 2);
                }
            } else {
                world.func_147465_d(x, y, z - 1, (Block)this, mid_concentration, 2);
            }
        }
    }

    public boolean func_149703_v() {
        return false;
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        if (par1World.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID || par1World.field_73011_w.field_76574_g == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID) {
            par1World.func_147464_a(par2, par3, par4, (Block)this, this.func_149738_a(par1World));
        } else {
            par1World.func_147468_f(par2, par3, par4);
        }
    }
}

