/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLift
extends TileEntityAbstractEnergy {
    private static final int MODE_REDSTONE = -1;
    private static final int MODE_INACTIVE = 0;
    private static final int MODE_UP = 1;
    private static final int MODE_DOWN = 2;
    private int firstUncoveredY;
    private int mode = 0;
    private boolean isEnabled = false;
    private boolean computerEnabled = true;
    private int computerMode = -1;
    private int tickCount = 0;

    public TileEntityLift() {
        this.IC2_sinkTier = 2;
        this.IC2_sourceTier = 2;
        this.peripheralName = "warpdriveLift";
        this.addMethods(new String[]{"mode", "active"});
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        ++this.tickCount;
        if (this.tickCount >= WarpDriveConfig.LIFT_UPDATE_INTERVAL_TICKS) {
            this.tickCount = 0;
            this.mode = this.computerMode == 2 || this.computerMode == -1 && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) ? 2 : 1;
            boolean bl = this.isEnabled = this.computerEnabled && this.isPassableBlock(this.field_145848_d + 1) && this.isPassableBlock(this.field_145848_d + 2) && this.isPassableBlock(this.field_145848_d - 1) && this.isPassableBlock(this.field_145848_d - 2);
            if (this.getEnergyStored() < WarpDriveConfig.LIFT_ENERGY_PER_ENTITY || !this.isEnabled) {
                this.mode = 0;
                if (this.func_145832_p() != 0) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
                }
                return;
            }
            if (this.func_145832_p() != this.mode) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.mode, 2);
            }
            for (int ny = this.field_145848_d - 2; ny > 0; --ny) {
                if (this.isPassableBlock(ny)) continue;
                this.firstUncoveredY = ny + 1;
                break;
            }
            if (this.field_145848_d - this.firstUncoveredY >= 2) {
                if (this.mode == 1) {
                    PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_145851_c + 0.5, this.firstUncoveredY, (double)this.field_145849_e + 0.5), new Vector3((double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5), 0.0f, 1.0f, 0.0f, 40, 0, 100);
                } else if (this.mode == 2) {
                    PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5), new Vector3((double)this.field_145851_c + 0.5, this.firstUncoveredY, (double)this.field_145849_e + 0.5), 0.0f, 0.0f, 1.0f, 40, 0, 100);
                }
                this.liftEntity();
            }
        }
    }

    private boolean isPassableBlock(int yPosition) {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, yPosition, this.field_145849_e);
        return block.func_149667_c(Blocks.field_150350_a) || block.func_149667_c(Blocks.field_150444_as) || block.func_149667_c(Blocks.field_150472_an) || this.field_145850_b.func_147437_c(this.field_145851_c, yPosition, this.field_145849_e);
    }

    private void liftEntity() {
        block4: {
            AxisAlignedBB aabb;
            List list;
            double zmax;
            double zmin;
            double xmax;
            double xmin;
            block3: {
                double CUBE_RADIUS = 0.4;
                xmin = (double)this.field_145851_c + 0.5 - 0.4;
                xmax = (double)this.field_145851_c + 0.5 + 0.4;
                zmin = (double)this.field_145849_e + 0.5 - 0.4;
                zmax = (double)this.field_145849_e + 0.5 + 0.4;
                if (this.mode != 1) break block3;
                AxisAlignedBB aabb2 = AxisAlignedBB.func_72330_a((double)xmin, (double)this.firstUncoveredY, (double)zmin, (double)xmax, (double)this.field_145848_d, (double)zmax);
                List list2 = this.field_145850_b.func_72839_b(null, aabb2);
                if (list2 == null) break block4;
                for (Object o : list2) {
                    if (o == null || !(o instanceof EntityLivingBase) || !this.consumeEnergy(WarpDriveConfig.LIFT_ENERGY_PER_ENTITY, true)) continue;
                    ((EntityLivingBase)o).func_70634_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5);
                    PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_145851_c + 0.5, this.firstUncoveredY, (double)this.field_145849_e + 0.5), new Vector3((double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5), 1.0f, 1.0f, 0.0f, 40, 0, 100);
                    this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5, "warpdrive:hilaser", 4.0f, 1.0f);
                    this.consumeEnergy(WarpDriveConfig.LIFT_ENERGY_PER_ENTITY, false);
                }
                break block4;
            }
            if (this.mode == 2 && (list = this.field_145850_b.func_72839_b(null, aabb = AxisAlignedBB.func_72330_a((double)xmin, (double)Math.min((double)this.firstUncoveredY + 4.0, (double)this.field_145848_d), (double)zmin, (double)xmax, (double)((double)this.field_145848_d + 2.0), (double)zmax))) != null) {
                for (Object o : list) {
                    if (o == null || !(o instanceof EntityLivingBase) || !this.consumeEnergy(WarpDriveConfig.LIFT_ENERGY_PER_ENTITY, true)) continue;
                    ((EntityLivingBase)o).func_70634_a((double)this.field_145851_c + 0.5, (double)this.firstUncoveredY, (double)this.field_145849_e + 0.5);
                    PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3((double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5), new Vector3((double)this.field_145851_c + 0.5, this.firstUncoveredY, (double)this.field_145849_e + 0.5), 1.0f, 1.0f, 0.0f, 40, 0, 100);
                    this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5, "warpdrive:hilaser", 4.0f, 1.0f);
                    this.consumeEnergy(WarpDriveConfig.LIFT_ENERGY_PER_ENTITY, false);
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
    }

    @Override
    public int getMaxEnergyStored() {
        return WarpDriveConfig.LIFT_MAX_ENERGY_STORED;
    }

    @Override
    public boolean canInputEnergy(ForgeDirection from) {
        return true;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] mode(Context context, Arguments arguments) {
        return this.mode(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] active(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.computerEnabled = arguments.checkBoolean(0);
        }
        return new Object[]{this.computerEnabled ? false : this.isEnabled};
    }

    private Object[] mode(Object[] arguments) {
        if (arguments.length == 1) {
            this.computerMode = arguments[0].toString().equals("up") ? 1 : (arguments[0].toString().equals("down") ? 2 : -1);
        }
        switch (this.computerMode) {
            case -1: {
                return new Object[]{"redstone"};
            }
            case 1: {
                return new Object[]{"up"};
            }
            case 2: {
                return new Object[]{"down"};
            }
        }
        return null;
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("mode")) {
            return this.mode(arguments);
        }
        if (methodName.equals("active")) {
            if (arguments.length == 1) {
                this.computerEnabled = TileEntityLift.toBool(arguments);
            }
            return new Object[]{this.computerEnabled ? false : this.isEnabled};
        }
        return super.callMethod(computer, context, method, arguments);
    }
}

