/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemIC2reactorLaserFocus;
import cr0s.warpdrive.network.PacketHandler;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityIC2reactorLaserMonitor
extends TileEntityAbstractEnergy {
    private int ticks = WarpDriveConfig.IC2_REACTOR_COOLING_INTERVAL_TICKS;
    private static int[] deltaX = new int[]{-2, 2, 0, 0, 0, 0};
    private static int[] deltaY = new int[]{0, 0, -2, 2, 0, 0};
    private static int[] deltaZ = new int[]{0, 0, 0, 0, -2, 2};

    public TileEntityIC2reactorLaserMonitor() {
        this.IC2_sinkTier = 2;
        this.IC2_sourceTier = 2;
    }

    @Optional.Method(modid="IC2")
    private Set<IReactor> findReactors() {
        HashSet<IReactor> output = new HashSet<IReactor>();
        for (int i = 0; i < deltaX.length; ++i) {
            IReactor reactor;
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + deltaX[i], this.field_145848_d + deltaY[i], this.field_145849_e + deltaZ[i]);
            if (tileEntity == null) continue;
            if (tileEntity instanceof IReactor) {
                output.add((IReactor)tileEntity);
                continue;
            }
            if (!(tileEntity instanceof IReactorChamber) || (reactor = ((IReactorChamber)tileEntity).getReactor()) == null) continue;
            ChunkCoordinates coords = reactor.getPosition();
            if (Math.abs(coords.field_71574_a - this.field_145851_c) == 1 || Math.abs(coords.field_71572_b - this.field_145848_d) == 1 || Math.abs(coords.field_71573_c - this.field_145849_e) == 1) continue;
            output.add(reactor);
        }
        return output;
    }

    @Optional.Method(modid="IC2")
    private boolean coolReactor(IReactor reactor) {
        boolean didCoolReactor = false;
        for (int x = 0; x < 9 && !didCoolReactor; ++x) {
            for (int y = 0; y < 6 && !didCoolReactor; ++y) {
                ItemStack item = reactor.getItemAt(x, y);
                if (item == null || !(item.func_77973_b() instanceof ItemIC2reactorLaserFocus)) continue;
                int heatInLaserFocus = item.func_77960_j();
                int heatRemovable = (int)Math.floor(Math.min((double)this.getEnergyStored() / WarpDriveConfig.IC2_REACTOR_ENERGY_PER_HEAT, (double)heatInLaserFocus));
                if (heatRemovable <= 0) continue;
                didCoolReactor = true;
                if (!this.consumeEnergy((int)Math.ceil((double)heatRemovable * WarpDriveConfig.IC2_REACTOR_ENERGY_PER_HEAT), false)) continue;
                item.func_77964_b(heatInLaserFocus - heatRemovable);
            }
        }
        return didCoolReactor;
    }

    @Override
    @Optional.Method(modid="IC2")
    public void func_145845_h() {
        super.func_145845_h();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        --this.ticks;
        if (this.ticks <= 0) {
            this.ticks = WarpDriveConfig.IC2_REACTOR_COOLING_INTERVAL_TICKS;
            Vector3 myPos = new Vector3(this).translate(0.5);
            Set<IReactor> reactors = this.findReactors();
            if (reactors.size() == 0) {
                return;
            }
            for (IReactor reactor : reactors) {
                if (!this.coolReactor(reactor)) continue;
                PacketHandler.sendBeamPacket(this.field_145850_b, myPos, new Vector3(reactor.getPosition()).translate(0.5), 0.0f, 0.8f, 1.0f, 20, 0, 20);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
    }

    @Override
    @Optional.Method(modid="IC2")
    public String getStatus() {
        Set<IReactor> reactors = this.findReactors();
        return this.func_145838_q().func_149732_F() + String.format(" energy level is %.0f/%.0f EU.", TileEntityIC2reactorLaserMonitor.convertInternalToEU(this.getEnergyStored()), TileEntityIC2reactorLaserMonitor.convertInternalToEU(this.getMaxEnergyStored())) + (reactors == null || reactors.size() == 0 ? " No reactor found!" : " " + reactors.size() + " reactor(s) connected.");
    }

    @Override
    public int getMaxEnergyStored() {
        return WarpDriveConfig.IC2_REACTOR_MAX_ENERGY_STORED;
    }

    @Override
    public boolean canInputEnergy(ForgeDirection from) {
        return true;
    }
}

