/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.energy;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractLaser;
import cr0s.warpdrive.block.energy.TileEntityEnanReactorCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityEnanReactorLaser
extends TileEntityAbstractLaser {
    Vector3 myVec;
    Vector3 reactorVec;
    ForgeDirection side = ForgeDirection.UNKNOWN;
    TileEntityEnanReactorCore reactor;
    private boolean isFirstUpdate = true;

    public TileEntityEnanReactorLaser() {
        this.addMethods(new String[]{"hasReactor", "side", "stabilize"});
        this.peripheralName = "warpdriveEnanReactorLaser";
        this.laserMediumMaxCount = 1;
        this.directionsValidLaserMedium = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    }

    public TileEntityEnanReactorCore scanForReactor() {
        this.reactor = null;
        this.side = ForgeDirection.UNKNOWN;
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2);
        if (tileEntity instanceof TileEntityEnanReactorCore && this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) {
            this.side = ForgeDirection.NORTH;
            this.reactor = (TileEntityEnanReactorCore)tileEntity;
        }
        if ((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2)) instanceof TileEntityEnanReactorCore && this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) {
            this.side = ForgeDirection.SOUTH;
            this.reactor = (TileEntityEnanReactorCore)tileEntity;
        }
        if ((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e)) instanceof TileEntityEnanReactorCore && this.field_145850_b.func_147437_c(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)) {
            this.side = ForgeDirection.WEST;
            this.reactor = (TileEntityEnanReactorCore)tileEntity;
        }
        if ((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e)) instanceof TileEntityEnanReactorCore && this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) {
            this.side = ForgeDirection.EAST;
            this.reactor = (TileEntityEnanReactorCore)tileEntity;
        }
        this.setMetadata();
        if (this.reactor != null) {
            this.reactorVec = new Vector3(this.reactor).translate(0.5);
        }
        return this.reactor;
    }

    private void setMetadata() {
        int metadata = 0;
        if (this.side != ForgeDirection.UNKNOWN) {
            metadata = this.side.ordinal() - 1;
        }
        if (this.func_145832_p() != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 3);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.isFirstUpdate) {
            this.isFirstUpdate = false;
            this.scanForReactor();
            this.myVec = new Vector3(this).translate(0.5);
        }
    }

    public void unlink() {
        this.side = ForgeDirection.UNKNOWN;
        this.setMetadata();
    }

    @Override
    public void updatedNeighbours() {
        super.updatedNeighbours();
        this.scanForReactor();
    }

    private void stabilize(int energy) {
        if (energy <= 0) {
            return;
        }
        this.scanForReactor();
        if (this.directionLaserMedium == ForgeDirection.UNKNOWN) {
            return;
        }
        if (this.reactor == null) {
            return;
        }
        if (this.consumeEnergyFromLaserMediums(energy, false)) {
            if (WarpDriveConfig.LOGGING_ENERGY && WarpDriveConfig.LOGGING_LUA) {
                WarpDrive.logger.info("ReactorLaser on " + this.side.toString() + " side sending " + energy);
            }
            this.reactor.decreaseInstability(this.side, energy);
            PacketHandler.sendBeamPacket(this.field_145850_b, this.myVec, this.reactorVec, 0.1f, 0.2f, 1.0f, 25, 50, 100);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] hasReactor(Context context, Arguments arguments) {
        return new Object[]{this.scanForReactor() != null};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] stabilize(Context context, Arguments arguments) {
        if (arguments.count() >= 1) {
            this.stabilize(arguments.checkInteger(0));
        }
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] side(Context context, Arguments arguments) {
        return new Object[]{this.side.ordinal() - 2};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("hasReactor")) {
            return new Object[]{this.scanForReactor() != null};
        }
        if (methodName.equals("stabilize")) {
            if (arguments.length >= 1) {
                this.stabilize(TileEntityEnanReactorLaser.toInt(arguments[0]));
            }
        } else if (methodName.equals("side")) {
            return new Object[]{this.side.ordinal() - 2};
        }
        return super.callMethod(computer, context, method, arguments);
    }
}

