/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractInterfaced;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityMonitor
extends TileEntityAbstractInterfaced {
    private int videoChannel = -1;
    private static final int PACKET_SEND_INTERVAL_TICKS = 1200;
    private int packetSendTicks = 20;

    public TileEntityMonitor() {
        this.peripheralName = "warpdriveMonitor";
        this.addMethods(new String[]{"videoChannel"});
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            --this.packetSendTicks;
            if (this.packetSendTicks <= 0) {
                this.packetSendTicks = 1200;
                PacketHandler.sendFreqPacket(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.videoChannel);
            }
            return;
        }
    }

    public int getVideoChannel() {
        return this.videoChannel;
    }

    public void setVideoChannel(int parVideoChannel) {
        if (this.videoChannel != parVideoChannel) {
            this.videoChannel = parVideoChannel;
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Monitor frequency set to " + this.videoChannel);
            }
            this.packetSendTicks = 0;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.videoChannel = tag.func_74762_e("frequency") + tag.func_74762_e("videoChannel");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("videoChannel", this.videoChannel);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] videoChannel(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setVideoChannel(arguments.checkInteger(0));
        }
        return new Integer[]{this.videoChannel};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("videoChannel")) {
            if (arguments.length == 1) {
                this.setVideoChannel(TileEntityMonitor.toInt(arguments[0]));
            }
            return new Integer[]{this.videoChannel};
        }
        return super.callMethod(computer, context, method, arguments);
    }

    public String toString() {
        return String.format("%s '%d' @ '%s' %d, %d, %d", this.getClass().getSimpleName(), this.videoChannel, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.func_72912_H().func_76065_j(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

