/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.collection;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.collection.TileEntityAbstractMiner;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Arrays;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public class TileEntityMiningLaser
extends TileEntityAbstractMiner {
    private final boolean canSilktouch = WarpDriveConfig.MINING_LASER_SILKTOUCH_DEUTERIUM_L <= 0.0 || FluidRegistry.isFluidRegistered((String)"deuterium");
    private int layerOffset = 1;
    private boolean mineAllBlocks = true;
    private int delayTicksWarmup = 0;
    private int delayTicksScan = 0;
    private int delayTicksMine = 0;
    private final int STATE_IDLE = 0;
    private final int STATE_WARMUP = 1;
    private final int STATE_SCANNING = 2;
    private final int STATE_MINING = 3;
    private int currentState = 0;
    private boolean enoughPower = false;
    private int currentLayer;
    private ArrayList<VectorI> valuablesInLayer = new ArrayList();
    private int valuableIndex = 0;

    private boolean isActive() {
        return this.currentState != 0;
    }

    public TileEntityMiningLaser() {
        this.laserOutputSide = ForgeDirection.DOWN;
        this.peripheralName = "warpdriveMiningLaser";
        this.addMethods(new String[]{"start", "stop", "state", "offset", "onlyOres", "silktouch"});
        this.CC_scripts = Arrays.asList("mine", "stop");
        this.laserMediumMaxCount = WarpDriveConfig.MINING_LASER_MAX_MEDIUMS_COUNT;
    }

    @Override
    public void func_145845_h() {
        boolean isOnEarth;
        super.func_145845_h();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (this.currentState == 0) {
            this.delayTicksWarmup = 0;
            this.delayTicksScan = 0;
            this.delayTicksMine = 0;
            this.updateMetadata(0);
            if (!WarpDriveConfig.isComputerCraftLoaded && !WarpDriveConfig.isOpenComputersLoaded) {
                this.enableSilktouch = false;
                this.layerOffset = 1;
                this.mineAllBlocks = true;
                this.start(null);
            }
            return;
        }
        boolean bl = isOnEarth = this.field_145850_b.field_73011_w.field_76574_g == 0;
        if (this.currentState == 1) {
            ++this.delayTicksWarmup;
            this.updateMetadata(3);
            if (this.delayTicksWarmup >= WarpDriveConfig.MINING_LASER_WARMUP_DELAY_TICKS) {
                this.delayTicksScan = 0;
                this.currentState = 2;
                this.updateMetadata(3);
                return;
            }
        } else if (this.currentState == 2) {
            ++this.delayTicksScan;
            if (this.delayTicksScan == 1) {
                this.enoughPower = this.consumeEnergyFromLaserMediums(isOnEarth ? WarpDriveConfig.MINING_LASER_PLANET_ENERGY_PER_LAYER : WarpDriveConfig.MINING_LASER_SPACE_ENERGY_PER_LAYER, true);
                if (!this.enoughPower) {
                    this.updateMetadata(3);
                    this.delayTicksScan = 0;
                    return;
                }
                this.updateMetadata(4);
                int age = Math.max(40, 5 * WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS);
                double xmax = (double)(this.field_145851_c + WarpDriveConfig.MINING_LASER_RADIUS_BLOCKS) + 1.0;
                double xmin = (double)(this.field_145851_c - WarpDriveConfig.MINING_LASER_RADIUS_BLOCKS) + 0.0;
                double zmax = (double)(this.field_145849_e + WarpDriveConfig.MINING_LASER_RADIUS_BLOCKS) + 1.0;
                double zmin = (double)(this.field_145849_e - WarpDriveConfig.MINING_LASER_RADIUS_BLOCKS) + 0.0;
                double y = (double)this.currentLayer + 1.0;
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xmin, y, zmin), new Vector3(xmax, y, zmin), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xmax, y, zmin), new Vector3(xmax, y, zmax), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xmax, y, zmax), new Vector3(xmin, y, zmax), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xmin, y, zmax), new Vector3(xmin, y, zmin), 0.3f, 0.0f, 1.0f, age, 0, 50);
            } else if (this.delayTicksScan >= WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS) {
                this.delayTicksScan = 0;
                if (this.currentLayer <= 0) {
                    this.stop();
                    return;
                }
                this.enoughPower = this.consumeEnergyFromLaserMediums(isOnEarth ? WarpDriveConfig.MINING_LASER_PLANET_ENERGY_PER_LAYER : WarpDriveConfig.MINING_LASER_SPACE_ENERGY_PER_LAYER, false);
                if (!this.enoughPower) {
                    this.updateMetadata(3);
                    return;
                }
                this.updateMetadata(4);
                this.scanLayer();
                if (this.valuablesInLayer.size() > 0) {
                    int r = (int)Math.ceil((double)WarpDriveConfig.MINING_LASER_RADIUS_BLOCKS / 2.0);
                    int offset = (this.field_145848_d - this.currentLayer) % (2 * r);
                    int age = Math.max(20, Math.round(2.5f * (float)WarpDriveConfig.MINING_LASER_SCAN_DELAY_TICKS));
                    double y = (double)this.currentLayer + 1.0;
                    PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_145851_c - r + offset, y, this.field_145849_e + r).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                    PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_145851_c + r, y, this.field_145849_e + r - offset).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                    PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_145851_c + r - offset, y, this.field_145849_e - r).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                    PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(this.field_145851_c - r, y, this.field_145849_e - r + offset).translate(0.3), 0.0f, 0.0f, 1.0f, age, 0, 50);
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:hilaser", 4.0f, 1.0f);
                    this.delayTicksMine = 0;
                    this.currentState = 3;
                    this.updateMetadata(2);
                    return;
                }
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
                --this.currentLayer;
            }
        } else if (this.currentState == 3) {
            ++this.delayTicksMine;
            if (this.delayTicksMine >= WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS) {
                this.delayTicksMine = 0;
                if (this.valuableIndex >= this.valuablesInLayer.size()) {
                    this.delayTicksScan = 0;
                    this.currentState = 2;
                    this.updateMetadata(4);
                    this.scanLayer();
                    if (this.valuablesInLayer.size() <= 0) {
                        --this.currentLayer;
                    }
                    return;
                }
                this.enoughPower = this.consumeEnergyFromLaserMediums(isOnEarth ? WarpDriveConfig.MINING_LASER_PLANET_ENERGY_PER_BLOCK : WarpDriveConfig.MINING_LASER_SPACE_ENERGY_PER_BLOCK, false);
                if (!this.enoughPower) {
                    this.updateMetadata(1);
                    return;
                }
                this.updateMetadata(2);
                VectorI valuable = this.valuablesInLayer.get(this.valuableIndex);
                ++this.valuableIndex;
                Block block = this.field_145850_b.func_147439_a(valuable.x, valuable.y, valuable.z);
                if (!this.canDig(block, valuable.x, valuable.y, valuable.z)) {
                    this.delayTicksMine = Math.round((float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS * 0.8f);
                }
                int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
                PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(valuable.x, valuable.y, valuable.z).translate(0.5), 1.0f, 1.0f, 0.0f, age, 0, 50);
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
                this.harvestBlock(valuable);
            }
        }
    }

    @Override
    protected void stop() {
        super.stop();
        this.currentState = 0;
        this.updateMetadata(0);
    }

    private boolean canDig(Block block, int x, int y, int z) {
        if (this.field_145850_b.func_147437_c(x, y, z)) {
            return false;
        }
        if (WarpDriveConfig.BLOCKS_NOMINING.contains(block)) {
            this.stop();
            return false;
        }
        if (WarpDriveConfig.BLOCKS_MINING.contains(block) || WarpDriveConfig.BLOCKS_ORES.contains(block)) {
            return true;
        }
        if (block.func_149638_a(null) <= Blocks.field_150343_Z.func_149638_a(null)) {
            return true;
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info(this + " Rejecting " + block + " at (" + x + ", " + y + ", " + z + ")");
        }
        return false;
    }

    private void scanLayer() {
        this.valuablesInLayer.clear();
        this.valuableIndex = 0;
        int x = this.field_145851_c;
        int z = this.field_145849_e;
        Block block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
        if (this.canDig(block, x, this.currentLayer, z) && (this.mineAllBlocks || WarpDriveConfig.BLOCKS_ORES.contains(block))) {
            this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
        }
        for (int radius = 1; radius <= WarpDriveConfig.MINING_LASER_RADIUS_BLOCKS; ++radius) {
            int xmax = this.field_145851_c + radius;
            int xmin = this.field_145851_c - radius;
            int zmax = this.field_145849_e + radius;
            int zmin = this.field_145849_e - radius;
            z = zmin;
            for (x = this.field_145851_c; x <= xmax; ++x) {
                block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
                if (!this.canDig(block, x, this.currentLayer, z) || !this.mineAllBlocks && !WarpDriveConfig.BLOCKS_ORES.contains(block)) continue;
                this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
            }
            x = xmax;
            ++z;
            while (z <= zmax) {
                block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
                if (this.canDig(block, x, this.currentLayer, z) && (this.mineAllBlocks || WarpDriveConfig.BLOCKS_ORES.contains(block))) {
                    this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
                }
                ++z;
            }
            --x;
            z = zmax;
            while (x >= xmin) {
                block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
                if (this.canDig(block, x, this.currentLayer, z) && (this.mineAllBlocks || WarpDriveConfig.BLOCKS_ORES.contains(block))) {
                    this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
                }
                --x;
            }
            x = xmin;
            --z;
            while (z > zmin) {
                block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
                if (this.canDig(block, x, this.currentLayer, z) && (this.mineAllBlocks || WarpDriveConfig.BLOCKS_ORES.contains(block))) {
                    this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
                }
                --z;
            }
            z = zmin;
            for (x = xmin; x < this.field_145851_c; ++x) {
                block = this.field_145850_b.func_147439_a(x, this.currentLayer, z);
                if (!this.canDig(block, x, this.currentLayer, z) || !this.mineAllBlocks && !WarpDriveConfig.BLOCKS_ORES.contains(block)) continue;
                this.valuablesInLayer.add(new VectorI(x, this.currentLayer, z));
            }
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info(this + " Found " + this.valuablesInLayer.size() + " valuables");
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.layerOffset = tag.func_74762_e("layerOffset");
        this.mineAllBlocks = tag.func_74767_n("mineAllBlocks");
        this.currentState = tag.func_74762_e("currentState");
        this.currentLayer = tag.func_74762_e("currentLayer");
        if (this.currentState == 3) {
            this.scanLayer();
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("layerOffset", this.layerOffset);
        tag.func_74757_a("mineAllBlocks", this.mineAllBlocks);
        tag.func_74768_a("currentState", this.currentState);
        tag.func_74768_a("currentLayer", this.currentLayer);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] start(Context context, Arguments arguments) {
        return this.start(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] stop(Context context, Arguments arguments) {
        this.stop();
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] state(Context context, Arguments arguments) {
        return this.state(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] offset(Context context, Arguments arguments) {
        return this.offset(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] onlyOres(Context context, Arguments arguments) {
        return this.onlyOres(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] silktouch(Context context, Arguments arguments) {
        return this.silktouch(this.argumentsOCtoCC(arguments));
    }

    private Object[] start(Object[] arguments) {
        if (this.isActive()) {
            return new Object[]{false, "Already started"};
        }
        this.enableSilktouch &= this.canSilktouch;
        this.delayTicksWarmup = 0;
        this.currentState = 1;
        this.currentLayer = this.field_145848_d - this.layerOffset - 1;
        return new Boolean[]{true};
    }

    private Object[] state(Object[] arguments) {
        int energy = this.getEnergyStored();
        String status = this.getStatus();
        if (this.isActive()) {
            Integer retValuablesInLayer = this.valuablesInLayer.size();
            Integer retValuablesMined = this.valuableIndex;
            return new Object[]{status, this.isActive(), energy, this.currentLayer, retValuablesMined, retValuablesInLayer};
        }
        return new Object[]{status, this.isActive(), energy, this.currentLayer, 0, 0};
    }

    private Object[] onlyOres(Object[] arguments) {
        if (arguments.length == 1) {
            try {
                this.mineAllBlocks = !TileEntityMiningLaser.toBool(arguments[0]);
            }
            catch (Exception exception) {
                return new Object[]{!this.mineAllBlocks};
            }
        }
        return new Object[]{!this.mineAllBlocks};
    }

    private Object[] offset(Object[] arguments) {
        if (arguments.length == 1) {
            try {
                this.layerOffset = Math.min(256, Math.abs(TileEntityMiningLaser.toInt(arguments[0])));
            }
            catch (Exception exception) {
                return new Integer[]{this.layerOffset};
            }
        }
        return new Integer[]{this.layerOffset};
    }

    private Object[] silktouch(Object[] arguments) {
        if (arguments.length == 1) {
            try {
                this.enableSilktouch = !TileEntityMiningLaser.toBool(arguments[0]);
            }
            catch (Exception exception) {
                return new Object[]{this.enableSilktouch};
            }
        }
        return new Object[]{this.enableSilktouch};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("start")) {
            return this.start(arguments);
        }
        if (methodName.equals("stop")) {
            this.stop();
            return null;
        }
        if (methodName.equals("state")) {
            return this.state(arguments);
        }
        if (methodName.equals("offset")) {
            return this.offset(arguments);
        }
        if (methodName.equals("onlyOres")) {
            return this.onlyOres(arguments);
        }
        if (methodName.equals("silktouch")) {
            return this.silktouch(arguments);
        }
        return super.callMethod(computer, context, method, arguments);
    }

    public String getStatus() {
        int energy = this.getEnergyStored();
        String state = "IDLE (not mining)";
        if (this.currentState == 0) {
            state = "IDLE (not mining)";
        } else if (this.currentState == 1) {
            state = "Warming up...";
        } else if (this.currentState == 2) {
            state = this.mineAllBlocks ? "Scanning all" : "Scanning ores";
        } else if (this.currentState == 3) {
            state = this.mineAllBlocks ? "Mining all" : "Mining ores";
            if (this.enableSilktouch) {
                state = state + " with silktouch";
            }
        }
        if (energy <= 0) {
            state = state + " - Out of energy";
        } else if (!(this.currentState != 2 && this.currentState != 3 || this.enoughPower)) {
            state = state + " - Not enough power";
        }
        return state;
    }

    public String toString() {
        return String.format("%s @ '%s' %d, %d, %d", this.getClass().getSimpleName(), this.field_145850_b == null ? "~NULL~" : this.field_145850_b.func_72912_H().func_76065_j(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

