/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.collection;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.collection.TileEntityAbstractMiner;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLaserTreeFarm
extends TileEntityAbstractMiner {
    private boolean breakLeaves = false;
    private boolean tapTrees = false;
    private final int STATE_IDLE = 0;
    private final int STATE_WARMUP = 1;
    private final int STATE_SCAN = 2;
    private final int STATE_HARVEST = 3;
    private final int STATE_TAP = 4;
    private final int STATE_PLANT = 5;
    private int currentState = 0;
    private boolean enoughPower = false;
    private final int TREE_FARM_WARMUP_DELAY_TICKS = 40;
    private final int TREE_FARM_SCAN_DELAY_TICKS = 40;
    private final int TREE_FARM_HARVEST_LOG_DELAY_TICKS = 4;
    private final int TREE_FARM_BREAK_LEAF_DELAY_TICKS = 4;
    private final int TREE_FARM_SILKTOUCH_LEAF_DELAY_TICKS = 4;
    private final int TREE_FARM_TAP_TREE_WET_DELAY_TICKS = 4;
    private final int TREE_FARM_TAP_TREE_DRY_DELAY_TICKS = 1;
    private final int TREE_FARM_PLANT_DELAY_TICKS = 1;
    private final int TREE_FARM_LOWPOWER_DELAY_TICKS = 40;
    private final int TREE_FARM_ENERGY_PER_SURFACE = 1;
    private final int TREE_FARM_ENERGY_PER_WET_SPOT = 1;
    private final double TREE_FARM_ENERGY_PER_LOG = 1.0;
    private final double TREE_FARM_ENERGY_PER_LEAF = 1.0;
    private final double TREE_FARM_SILKTOUCH_ENERGY_FACTOR = 2.0;
    private final int TREE_FARM_ENERGY_PER_SAPLING = 1;
    private int delayTargetTicks = 0;
    private int totalHarvested = 0;
    private boolean bScanOnReload = false;
    private int delayTicks = 0;
    private int radiusX = WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM;
    private int radiusZ = WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM;
    LinkedList<VectorI> soils;
    private int soilIndex = 0;
    ArrayList<VectorI> valuables;
    private int valuableIndex = 0;

    private boolean isFarming() {
        return this.currentState != 0;
    }

    public TileEntityLaserTreeFarm() {
        this.laserOutputSide = ForgeDirection.UP;
        this.peripheralName = "warpdriveLaserTreefarm";
        this.addMethods(new String[]{"start", "stop", "radius", "state", "breakLeaves", "silktouch", "tapTrees"});
        this.laserMediumMaxCount = WarpDriveConfig.TREE_FARM_MAX_MEDIUMS_COUNT;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (this.bScanOnReload) {
            this.soils = this.scanSoils();
            this.valuables = new ArrayList<VectorI>(this.scanTrees());
            this.bScanOnReload = false;
            return;
        }
        if (this.currentState == 0) {
            this.delayTicks = 0;
            this.delayTargetTicks = 40;
            this.updateMetadata(0);
            if (!WarpDriveConfig.isComputerCraftLoaded && !WarpDriveConfig.isOpenComputersLoaded) {
                this.breakLeaves = true;
                this.enableSilktouch = false;
                this.tapTrees = true;
                this.start(null);
            }
            return;
        }
        ++this.delayTicks;
        if (this.currentState == 1) {
            this.updateMetadata(3);
            if (this.delayTicks >= this.delayTargetTicks) {
                this.delayTicks = 0;
                this.delayTargetTicks = 40;
                this.currentState = 2;
                this.updateMetadata(3);
                return;
            }
        } else if (this.currentState == 2) {
            int energyCost = 1 * (1 + 2 * this.radiusX) * (1 + 2 * this.radiusZ);
            if (this.delayTicks == 1) {
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.debug("Scan pre-tick");
                }
                this.enoughPower = this.consumeEnergyFromLaserMediums(energyCost, true);
                if (!this.enoughPower) {
                    this.currentState = 1;
                    this.delayTicks = 0;
                    this.delayTargetTicks = 40;
                    this.updateMetadata(3);
                    return;
                }
                this.updateMetadata(4);
                int age = Math.max(40, 80);
                double xmax = (double)(this.field_145851_c + this.radiusX) + 1.0;
                double xmin = (double)(this.field_145851_c - this.radiusX) + 0.0;
                double zmax = (double)(this.field_145849_e + this.radiusZ) + 1.0;
                double zmin = (double)(this.field_145849_e - this.radiusZ) + 0.0;
                double y = this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(9);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xmin, y, zmin), new Vector3(xmax, y, zmin), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xmax, y, zmin), new Vector3(xmax, y, zmax), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xmax, y, zmax), new Vector3(xmin, y, zmax), 0.3f, 0.0f, 1.0f, age, 0, 50);
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(xmin, y, zmax), new Vector3(xmin, y, zmin), 0.3f, 0.0f, 1.0f, age, 0, 50);
            } else if (this.delayTicks >= this.delayTargetTicks) {
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.debug("Scan tick");
                }
                this.delayTicks = 0;
                this.enoughPower = this.consumeEnergyFromLaserMediums(energyCost, false);
                if (!this.enoughPower) {
                    this.delayTargetTicks = 40;
                    this.updateMetadata(3);
                    return;
                }
                this.delayTargetTicks = 40;
                this.updateMetadata(4);
                this.soils = this.scanSoils();
                this.soilIndex = 0;
                this.valuables = new ArrayList<VectorI>(this.scanTrees());
                this.valuableIndex = 0;
                if (this.valuables != null && this.valuables.size() > 0) {
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:hilaser", 4.0f, 1.0f);
                    this.currentState = this.tapTrees ? 4 : 3;
                    this.delayTargetTicks = 4;
                    this.updateMetadata(2);
                    return;
                }
                if (this.soils != null && this.soils.size() > 0) {
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:hilaser", 4.0f, 1.0f);
                    this.currentState = 5;
                    this.delayTargetTicks = 1;
                    this.updateMetadata(6);
                    return;
                }
                this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
                this.currentState = 1;
                this.delayTargetTicks = 40;
                this.updateMetadata(3);
            }
        } else if (this.currentState == 3 || this.currentState == 4) {
            if (this.delayTicks >= this.delayTargetTicks) {
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.debug("Harvest/tap tick");
                }
                this.delayTicks = 0;
                if (this.valuables == null || this.valuableIndex >= this.valuables.size()) {
                    this.valuableIndex = 0;
                    this.currentState = 5;
                    this.delayTargetTicks = 1;
                    this.updateMetadata(6);
                    return;
                }
                VectorI valuable = this.valuables.get(this.valuableIndex);
                Block block = this.field_145850_b.func_147439_a(valuable.x, valuable.y, valuable.z);
                ++this.valuableIndex;
                boolean isLog = TileEntityLaserTreeFarm.isLog(block);
                boolean isLeaf = TileEntityLaserTreeFarm.isLeaf(block);
                if (this.currentState == 4 && block.func_149667_c(WarpDriveConfig.IC2_rubberWood)) {
                    int metadata = this.field_145850_b.func_72805_g(valuable.x, valuable.y, valuable.z);
                    if (metadata >= 2 && metadata <= 5) {
                        if (WarpDriveConfig.LOGGING_COLLECTION) {
                            WarpDrive.logger.debug("Tap found rubber wood wetspot at " + valuable + " with metadata " + metadata);
                        }
                        int energyCost = 1;
                        this.enoughPower = this.consumeEnergyFromLaserMediums(energyCost, false);
                        if (!this.enoughPower) {
                            this.delayTargetTicks = 40;
                            this.updateMetadata(1);
                            return;
                        }
                        this.delayTargetTicks = 4;
                        this.updateMetadata(2);
                        ItemStack resin = WarpDriveConfig.IC2_Resin.func_77946_l();
                        resin.field_77994_a = (int)Math.round(Math.random() * 4.0);
                        if (this.addToConnectedInventory(resin)) {
                            this.stop();
                        }
                        this.totalHarvested += resin.field_77994_a;
                        int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
                        PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(valuable.x, valuable.y, valuable.z).translate(0.5), 0.8f, 0.8f, 0.2f, age, 0, 50);
                        this.field_145850_b.func_72921_c(valuable.x, valuable.y, valuable.z, metadata + 6, 3);
                        return;
                    }
                    if (metadata != 0 && metadata != 1) {
                        this.delayTargetTicks = 1;
                        return;
                    }
                }
                if (isLog || this.breakLeaves && isLeaf) {
                    double energyCost;
                    double d = energyCost = isLog ? 1.0 : 1.0;
                    if (this.enableSilktouch) {
                        energyCost *= 2.0;
                    }
                    this.enoughPower = this.consumeEnergyFromLaserMediums((int)Math.round(energyCost), false);
                    if (!this.enoughPower) {
                        this.delayTargetTicks = 40;
                        this.updateMetadata(1);
                        return;
                    }
                    this.delayTargetTicks = isLog ? 4 : (this.enableSilktouch ? 4 : 4);
                    this.updateMetadata(2);
                    ++this.totalHarvested;
                    int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
                    PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(valuable.x, valuable.y, valuable.z).translate(0.5), 0.2f, 0.7f, 0.4f, age, 0, 50);
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
                    this.harvestBlock(valuable);
                }
            }
        } else if (this.currentState == 5 && this.delayTicks >= this.delayTargetTicks) {
            if (WarpDriveConfig.LOGGING_COLLECTION) {
                WarpDrive.logger.debug("Plant final tick");
            }
            this.delayTicks = 0;
            if (this.soils == null || this.soilIndex >= this.soils.size()) {
                this.soilIndex = 0;
                this.currentState = 2;
                this.delayTargetTicks = 40;
                this.updateMetadata(4);
                return;
            }
            VectorI soil = this.soils.get(this.soilIndex);
            Block block = this.field_145850_b.func_147439_a(soil.x, soil.y, soil.z);
            ++this.soilIndex;
            IInventory inventory = this.getFirstConnectedInventory();
            if (inventory == null) {
                this.currentState = 1;
                this.delayTargetTicks = 40;
                this.updateMetadata(3);
                return;
            }
            int slotIndex = 0;
            boolean found = false;
            int plantableCount = 0;
            ItemStack itemStack = null;
            while (slotIndex < inventory.func_70302_i_() && !found) {
                itemStack = inventory.func_70301_a(slotIndex);
                if (itemStack != null) {
                    WarpDrive.logger.debug("- " + slotIndex + ": " + itemStack + " => " + itemStack.func_77973_b() + " Plantable: " + (itemStack.func_77973_b() instanceof IPlantable) + " Growable: " + (itemStack.func_77973_b() instanceof IGrowable));
                }
                if (itemStack == null || itemStack.field_77994_a <= 0 || !(itemStack.func_77973_b() instanceof IPlantable)) {
                    ++slotIndex;
                    continue;
                }
                ++plantableCount;
                WarpDrive.logger.debug("IPlantable found: " + itemStack);
                if (!block.canSustainPlant((IBlockAccess)this.field_145850_b, soil.x, soil.y, soil.z, ForgeDirection.UP, (IPlantable)itemStack.func_77973_b())) {
                    ++slotIndex;
                    continue;
                }
                found = true;
            }
            if (plantableCount <= 0) {
                this.currentState = 2;
                this.delayTargetTicks = 40;
                this.updateMetadata(4);
                return;
            }
            if (!found || itemStack == null) {
                WarpDrive.logger.debug("No sapling found");
                return;
            }
            WarpDrive.logger.debug("Sapling found: " + itemStack);
            double energyCost = 1.0;
            this.enoughPower = this.consumeEnergyFromLaserMediums((int)Math.round(energyCost), false);
            if (!this.enoughPower) {
                this.delayTargetTicks = 40;
                this.updateMetadata(5);
                return;
            }
            this.delayTargetTicks = 1;
            this.updateMetadata(6);
            --itemStack.field_77994_a;
            if (itemStack.field_77994_a <= 0) {
                itemStack = null;
            }
            inventory.func_70299_a(slotIndex, itemStack);
            int age = Math.max(10, Math.round((4.0f + this.field_145850_b.field_73012_v.nextFloat()) * (float)WarpDriveConfig.MINING_LASER_MINE_DELAY_TICKS));
            PacketHandler.sendBeamPacket(this.field_145850_b, this.laserOutput, new Vector3(soil.x, soil.y + 1, soil.z).translate(0.5), 0.2f, 0.7f, 0.4f, age, 0, 50);
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
        }
    }

    @Override
    protected void stop() {
        super.stop();
        this.currentState = 0;
        this.updateMetadata(0);
    }

    private static boolean isSoil(Block block) {
        return WarpDriveConfig.BLOCKS_SOILS.contains(block);
    }

    private static boolean isLog(Block block) {
        return WarpDriveConfig.BLOCKS_LOGS.contains(block);
    }

    private static boolean isLeaf(Block block) {
        return WarpDriveConfig.BLOCKS_LEAVES.contains(block);
    }

    private LinkedList<VectorI> scanSoils() {
        int maxRadius = WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM + this.laserMediumCount * WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM;
        int xmin = this.field_145851_c - Math.min(this.radiusX, maxRadius);
        int xmax = this.field_145851_c + Math.min(this.radiusX, maxRadius);
        int ymin = this.field_145848_d + 0;
        int ymax = this.field_145848_d + 8;
        int zmin = this.field_145849_e - Math.min(this.radiusZ, maxRadius);
        int zmax = this.field_145849_e + Math.min(this.radiusZ, maxRadius);
        LinkedList<VectorI> soilPositions = new LinkedList<VectorI>();
        for (int y = ymin; y <= ymax; ++y) {
            for (int x = xmin; x <= xmax; ++x) {
                for (int z = zmin; z <= zmax; ++z) {
                    Block block;
                    if (!this.field_145850_b.func_147437_c(x, y + 1, z) || !TileEntityLaserTreeFarm.isSoil(block = this.field_145850_b.func_147439_a(x, y, z))) continue;
                    VectorI pos = new VectorI(x, y, z);
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.info("Found soil at " + x + "," + y + "," + z);
                    }
                    soilPositions.add(pos);
                }
            }
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info("Found " + soilPositions.size() + " soils");
        }
        return soilPositions;
    }

    private Collection<VectorI> scanTrees() {
        int maxRadius = WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM + this.laserMediumCount * WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_PER_LASER_MEDIUM;
        int xmin = this.field_145851_c - Math.min(this.radiusX, maxRadius);
        int xmax = this.field_145851_c + Math.min(this.radiusX, maxRadius);
        int ymin = this.field_145848_d + 1;
        int ymax = this.field_145848_d + 1 + (this.tapTrees ? 8 : 0);
        int zmin = this.field_145849_e - Math.min(this.radiusZ, maxRadius);
        int zmax = this.field_145849_e + Math.min(this.radiusZ, maxRadius);
        Set<VectorI> logPositions = new HashSet<VectorI>();
        for (int y = ymin; y <= ymax; ++y) {
            for (int x = xmin; x <= xmax; ++x) {
                for (int z = zmin; z <= zmax; ++z) {
                    VectorI pos;
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    if (!TileEntityLaserTreeFarm.isLog(block) || logPositions.contains(pos = new VectorI(x, y, z))) continue;
                    if (WarpDriveConfig.LOGGING_COLLECTION) {
                        WarpDrive.logger.info("Found tree base at " + x + "," + y + "," + z);
                    }
                    logPositions.add(pos);
                }
            }
        }
        if (logPositions.size() > 0) {
            HashSet whitelist = (HashSet)WarpDriveConfig.BLOCKS_LOGS.clone();
            if (this.breakLeaves) {
                // empty if block
            }
            logPositions = TileEntityLaserTreeFarm.getConnectedBlocks(this.field_145850_b, logPositions, UP_DIRECTIONS, (HashSet<Block>)whitelist, WarpDriveConfig.TREE_FARM_MAX_LOG_DISTANCE + this.laserMediumCount * WarpDriveConfig.TREE_FARM_MAX_LOG_DISTANCE_PER_MEDIUM, new VectorI[0]);
        }
        if (WarpDriveConfig.LOGGING_COLLECTION) {
            WarpDrive.logger.info("Found " + logPositions.size() + " valuables");
        }
        return logPositions;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("radiusX", this.radiusX);
        tag.func_74768_a("radiusZ", this.radiusZ);
        tag.func_74757_a("breakLeaves", this.breakLeaves);
        tag.func_74757_a("tapTrees", this.tapTrees);
        tag.func_74768_a("currentState", this.currentState);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.radiusX = tag.func_74762_e("radiusX");
        if (this.radiusX == 0) {
            this.radiusX = 1;
        }
        this.radiusX = TileEntityLaserTreeFarm.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, this.radiusX);
        this.radiusZ = tag.func_74762_e("radiusZ");
        if (this.radiusZ == 0) {
            this.radiusZ = 1;
        }
        this.radiusZ = TileEntityLaserTreeFarm.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, this.radiusZ);
        this.breakLeaves = tag.func_74767_n("breakLeaves");
        this.tapTrees = tag.func_74767_n("tapTrees");
        this.currentState = tag.func_74762_e("currentState");
        if (this.currentState == 3 || this.currentState == 4 || this.currentState == 5) {
            this.bScanOnReload = true;
        }
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] start(Context context, Arguments arguments) {
        return this.start(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] stop(Context context, Arguments arguments) {
        this.stop();
        return null;
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] state(Context context, Arguments arguments) {
        return this.state(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] radius(Context context, Arguments arguments) {
        return this.radius(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] breakLeaves(Context context, Arguments arguments) {
        return this.breakLeaves(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] silktouch(Context context, Arguments arguments) {
        return this.silktouch(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] tapTrees(Context context, Arguments arguments) {
        return this.tapTrees(this.argumentsOCtoCC(arguments));
    }

    private Object[] start(Object[] arguments) {
        if (this.isFarming()) {
            return new Object[]{false, "Already started"};
        }
        this.totalHarvested = 0;
        this.delayTicks = 0;
        this.currentState = 1;
        return new Boolean[]{true};
    }

    private Object[] state(Object[] arguments) {
        int energy = this.getEnergyStored();
        String status = this.getStatus();
        if (this.isFarming()) {
            Integer retValuables = this.valuables.size();
            Integer retValuablesIndex = this.valuableIndex;
            return new Object[]{status, this.isFarming(), energy, this.totalHarvested, retValuablesIndex, retValuables};
        }
        return new Object[]{status, this.isFarming(), energy, this.totalHarvested, 0, 0};
    }

    private Object[] radius(Object[] arguments) {
        try {
            if (arguments.length == 1) {
                this.radiusZ = this.radiusX = TileEntityLaserTreeFarm.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, TileEntityLaserTreeFarm.toInt(arguments[0]));
            } else if (arguments.length == 2) {
                this.radiusX = TileEntityLaserTreeFarm.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, TileEntityLaserTreeFarm.toInt(arguments[0]));
                this.radiusZ = TileEntityLaserTreeFarm.clamp(1, WarpDriveConfig.TREE_FARM_totalMaxRadius, TileEntityLaserTreeFarm.toInt(arguments[1]));
            }
        }
        catch (NumberFormatException exception) {
            this.radiusX = WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM;
            this.radiusZ = WarpDriveConfig.TREE_FARM_MAX_SCAN_RADIUS_NO_LASER_MEDIUM;
        }
        return new Integer[]{this.radiusX, this.radiusZ};
    }

    private Object[] breakLeaves(Object[] arguments) {
        if (arguments.length == 1) {
            try {
                this.breakLeaves = TileEntityLaserTreeFarm.toBool(arguments[0]);
            }
            catch (Exception exception) {
                return new Object[]{this.breakLeaves};
            }
        }
        return new Object[]{this.breakLeaves};
    }

    private Object[] silktouch(Object[] arguments) {
        if (arguments.length == 1) {
            try {
                this.enableSilktouch = TileEntityLaserTreeFarm.toBool(arguments[0]);
            }
            catch (Exception exception) {
                return new Object[]{this.enableSilktouch};
            }
        }
        return new Object[]{this.enableSilktouch};
    }

    private Object[] tapTrees(Object[] arguments) {
        if (arguments.length == 1) {
            try {
                this.tapTrees = TileEntityLaserTreeFarm.toBool(arguments[0]);
            }
            catch (Exception exception) {
                return new Object[]{this.tapTrees};
            }
        }
        return new Object[]{this.tapTrees};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("start")) {
            return this.start(arguments);
        }
        if (methodName.equals("stop")) {
            this.stop();
            return null;
        }
        if (methodName.equals("state")) {
            return this.state(arguments);
        }
        if (methodName.equals("radius")) {
            return this.radius(arguments);
        }
        if (methodName.equals("breakLeaves")) {
            return this.breakLeaves(arguments);
        }
        if (methodName.equals("silktouch")) {
            return this.silktouch(arguments);
        }
        if (methodName.equals("tapTrees")) {
            return this.tapTrees(arguments);
        }
        return super.callMethod(computer, context, method, arguments);
    }

    public String getStatus() {
        int energy = this.getEnergyStored();
        String state = "IDLE (not farming)";
        if (this.currentState == 0) {
            state = "IDLE (not farming)";
        } else if (this.currentState == 1) {
            state = "Warming up...";
        } else if (this.currentState == 2) {
            state = this.breakLeaves ? "Scanning all" : "Scanning logs";
        } else if (this.currentState == 3) {
            state = this.breakLeaves ? "Harvesting all" : "Harvesting logs";
            if (this.enableSilktouch) {
                state = state + " with silktouch";
            }
        } else if (this.currentState == 4) {
            state = this.breakLeaves ? "Tapping trees, harvesting all" : "Tapping trees, harvesting logs";
            if (this.enableSilktouch) {
                state = state + " with silktouch";
            }
        } else if (this.currentState == 5) {
            state = "Planting trees";
        }
        if (energy <= 0) {
            state = state + " - Out of energy";
        } else if (!(this.currentState != 2 && this.currentState != 3 && this.currentState != 4 || this.enoughPower)) {
            state = state + " - Not enough power";
        }
        return state;
    }
}

