/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.building;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityShipScanner
extends TileEntityAbstractEnergy {
    private boolean isActive = false;
    private TileEntityShipCore shipCore = null;
    int laserTicks = 0;
    int scanTicks = 0;
    int deployDelayTicks = 0;
    int searchTicks = 0;
    private String schematicFileName;
    private JumpBlock[] blocksToDeploy;
    private int currentDeployIndex;
    private int blocksToDeployCount;
    private boolean isDeploying = false;
    private int targetX;
    private int targetY;
    private int targetZ;

    public TileEntityShipScanner() {
        this.peripheralName = "warpdriveShipScanner";
        this.addMethods(new String[]{"scan", "fileName", "deploy", "state"});
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (++this.searchTicks > 20) {
            this.shipCore = this.searchShipCore();
            this.searchTicks = 0;
        }
        if (!this.isDeploying && this.shipCore == null) {
            this.setActive(false);
            return;
        }
        if (!this.isActive) {
            if (++this.laserTicks > 20) {
                PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(this.shipCore.field_145851_c, this.shipCore.field_145848_d, this.shipCore.field_145849_e).translate(0.5), 0.0f, 1.0f, 0.0f, 40, 0, 100);
                this.laserTicks = 0;
            }
        } else if (!this.isDeploying) {
            if (++this.laserTicks > 5) {
                this.laserTicks = 0;
                for (int i = 0; i < this.shipCore.maxX - this.shipCore.minX; ++i) {
                    int x = this.shipCore.minX + i;
                    int randomZ = this.shipCore.minZ + this.field_145850_b.field_73012_v.nextInt(this.shipCore.maxZ - this.shipCore.minZ);
                    this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    switch (this.field_145850_b.field_73012_v.nextInt(6)) {
                        case 0: {
                            r = 1.0f;
                            b = 0.0f;
                            g = 0.0f;
                            break;
                        }
                        case 1: {
                            b = 0.0f;
                            r = 0.0f;
                            g = 1.0f;
                            break;
                        }
                        case 2: {
                            g = 0.0f;
                            r = 0.0f;
                            b = 1.0f;
                            break;
                        }
                        case 3: {
                            b = 0.5f;
                            r = 0.5f;
                            g = 0.0f;
                            break;
                        }
                        case 4: {
                            g = 1.0f;
                            r = 1.0f;
                            b = 0.0f;
                            break;
                        }
                        case 5: {
                            r = 1.0f;
                            b = 0.5f;
                            g = 0.0f;
                            break;
                        }
                    }
                    PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(x, this.shipCore.maxY, randomZ).translate(0.5), r, g, b, 15, 0, 100);
                }
            }
            if (++this.scanTicks > 20 * (1 + this.shipCore.shipMass / 10)) {
                this.setActive(false);
                this.scanTicks = 0;
            }
        } else {
            if (++this.deployDelayTicks < 20) {
                return;
            }
            this.deployDelayTicks = 0;
            int blocks = Math.min(WarpDriveConfig.G_BLOCKS_PER_TICK, this.blocksToDeployCount - this.currentDeployIndex);
            if (blocks == 0) {
                this.isDeploying = false;
                this.setActive(false);
                return;
            }
            for (int index = 0; index < blocks; ++index) {
                Block blockAtTarget;
                if (this.currentDeployIndex >= this.blocksToDeployCount) {
                    this.isDeploying = false;
                    this.setActive(false);
                    break;
                }
                JumpBlock jb = this.blocksToDeploy[this.currentDeployIndex];
                if (jb != null && !WarpDriveConfig.BLOCKS_ANCHOR.contains(jb.block) && ((blockAtTarget = this.field_145850_b.func_147439_a(this.targetX + jb.x, this.targetY + jb.y, this.targetZ + jb.z)) == Blocks.field_150350_a || WarpDriveConfig.BLOCKS_EXPANDABLE.contains(blockAtTarget))) {
                    jb.deploy(this.field_145850_b, this.targetX, this.targetY, this.targetZ);
                    if (this.field_145850_b.field_73012_v.nextInt(100) <= 10) {
                        this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)this.field_145848_d, (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
                        PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5), new Vector3(this.targetX + jb.x, this.targetY + jb.y, this.targetZ + jb.z).translate(0.5), 0.0f, 1.0f, 0.0f, 15, 0, 100);
                    }
                }
                ++this.currentDeployIndex;
            }
        }
    }

    private void setActive(boolean newState) {
        this.isActive = newState;
        if (this.func_145832_p() == 1 == newState) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.isActive ? 1 : 0, 2);
        }
    }

    private TileEntityShipCore searchShipCore() {
        StringBuilder reason = new StringBuilder();
        TileEntityShipCore result = null;
        for (int newY = this.field_145848_d + 1; newY <= 255; ++newY) {
            if (!this.field_145850_b.func_147439_a(this.field_145851_c, newY, this.field_145849_e).func_149667_c(WarpDrive.blockShipCore)) continue;
            result = (TileEntityShipCore)this.field_145850_b.func_147438_o(this.field_145851_c, newY, this.field_145849_e);
            if (result == null || result.validateShipSpatialParameters(reason)) break;
            result = null;
            break;
        }
        return result;
    }

    private int getScanningEnergyCost(int size) {
        if (WarpDriveConfig.SS_ENERGY_PER_BLOCK_SCAN > 0) {
            return size * WarpDriveConfig.SS_ENERGY_PER_BLOCK_SCAN;
        }
        return WarpDriveConfig.SS_MAX_ENERGY_STORED;
    }

    private int getDeploymentEnergyCost(int size) {
        if (WarpDriveConfig.SS_ENERGY_PER_BLOCK_DEPLOY > 0) {
            return size * WarpDriveConfig.SS_ENERGY_PER_BLOCK_DEPLOY;
        }
        return WarpDriveConfig.SS_MAX_ENERGY_STORED;
    }

    private boolean saveShipToSchematic(String fileName, StringBuilder reason) {
        NBTTagCompound schematic = new NBTTagCompound();
        int width = this.shipCore.maxX - this.shipCore.minX + 1;
        int length = this.shipCore.maxZ - this.shipCore.minZ + 1;
        int height = this.shipCore.maxY - this.shipCore.minY + 1;
        if (width <= 0 || length <= 0 || height <= 0) {
            reason.append("Invalid ship dimensions, nothing to scan");
            return false;
        }
        schematic.func_74777_a("Width", (short)width);
        schematic.func_74777_a("Length", (short)length);
        schematic.func_74777_a("Height", (short)height);
        int size = width * length * height;
        if (!this.consumeEnergy(this.getScanningEnergyCost(size), false)) {
            reason.append("Insufficient energy (" + this.getScanningEnergyCost(size) + " required)");
            return false;
        }
        NBTTagList localBlocks = new NBTTagList();
        byte[] localMetadata = new byte[size];
        NBTTagList tileEntitiesList = new NBTTagList();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    TileEntity te;
                    Block block = this.field_145850_b.func_147439_a(this.shipCore.minX + x, this.shipCore.minY + y, this.shipCore.minZ + z);
                    if (WarpDriveConfig.BLOCKS_LEFTBEHIND.contains(block) || WarpDriveConfig.BLOCKS_ANCHOR.contains(block)) {
                        block = Blocks.field_150350_a;
                    }
                    localBlocks.func_74742_a((NBTBase)new NBTTagString(block.func_149739_a()));
                    localMetadata[x + (y * length + z) * width] = (byte)this.field_145850_b.func_72805_g(this.shipCore.minX + x, this.shipCore.minY + y, this.shipCore.minZ + z);
                    if (block.func_149667_c(Blocks.field_150350_a) || (te = this.field_145850_b.func_147438_o(this.shipCore.minX + x, this.shipCore.minY + y, this.shipCore.minZ + z)) == null) continue;
                    try {
                        NBTTagCompound tileTag = new NBTTagCompound();
                        te.func_145841_b(tileTag);
                        if (te instanceof IInventory) {
                            TileEntity tmp_te = TileEntity.func_145827_c((NBTTagCompound)tileTag);
                            if (tmp_te instanceof IInventory) {
                                for (int i = 0; i < ((IInventory)tmp_te).func_70302_i_(); ++i) {
                                    ((IInventory)tmp_te).func_70299_a(i, null);
                                }
                            }
                            tmp_te.func_145841_b(tileTag);
                        }
                        if (tileTag.func_74764_b("energy")) {
                            tileTag.func_74768_a("energy", 0);
                        }
                        if (tileTag.func_74764_b("mStoredEnergy")) {
                            tileTag.func_74768_a("mStoredEnergy", 0);
                        }
                        tileTag.func_74768_a("x", te.field_145851_c - this.shipCore.minX);
                        tileTag.func_74768_a("y", te.field_145848_d - this.shipCore.minY);
                        tileTag.func_74768_a("z", te.field_145849_e - this.shipCore.minZ);
                        tileEntitiesList.func_74742_a((NBTBase)tileTag);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        schematic.func_74778_a("Materials", "Alpha");
        schematic.func_74782_a("Blocks", (NBTBase)localBlocks);
        schematic.func_74773_a("Data", localMetadata);
        schematic.func_74782_a("Entities", (NBTBase)new NBTTagList());
        schematic.func_74782_a("TileEntities", (NBTBase)tileEntitiesList);
        this.writeNBTToFile(fileName, schematic);
        return true;
    }

    private void writeNBTToFile(String fileName, NBTTagCompound nbttagcompound) {
        WarpDrive.logger.info(this + " Filename: " + fileName);
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)fileoutputstream);
            fileoutputstream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean scanShip(StringBuilder reason) {
        this.setActive(true);
        File f = new File(WarpDriveConfig.G_SCHEMALOCATION);
        if (!f.exists() || !f.isDirectory()) {
            f.mkdirs();
        }
        do {
            this.schematicFileName = this.shipCore.shipName + System.currentTimeMillis() + ".schematic";
        } while (new File(WarpDriveConfig.G_SCHEMALOCATION + "/" + this.schematicFileName).exists());
        if (!this.saveShipToSchematic(WarpDriveConfig.G_SCHEMALOCATION + "/" + this.schematicFileName, reason)) {
            return false;
        }
        reason.append(this.schematicFileName);
        return true;
    }

    private static NBTTagCompound readNBTFromFile(String fileName) {
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            FileInputStream fileinputstream = new FileInputStream(file);
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
            fileinputstream.close();
            return nbttagcompound;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private int deployShip(String fileName, int offsetX, int offsetY, int offsetZ, StringBuilder reason) {
        NBTTagCompound schematic = TileEntityShipScanner.readNBTFromFile(WarpDriveConfig.G_SCHEMALOCATION + "/" + fileName);
        if (schematic == null) {
            reason.append("Schematic not found or unknow error reading it.");
            return -1;
        }
        int width = schematic.func_74765_d("Width");
        int height = schematic.func_74765_d("Height");
        int length = schematic.func_74765_d("Length");
        this.targetX = this.field_145851_c + offsetX;
        this.targetY = this.field_145848_d + offsetY;
        this.targetZ = this.field_145849_e + offsetZ;
        this.blocksToDeployCount = width * height * length;
        double dX = this.field_145851_c - this.targetX;
        double dY = this.field_145848_d - this.targetY;
        double dZ = this.field_145849_e - this.targetZ;
        double distance = MathHelper.func_76133_a((double)(dX * dX + dY * dY + dZ * dZ));
        if (distance > (double)WarpDriveConfig.SS_MAX_DEPLOY_RADIUS_BLOCKS) {
            reason.append("Cannot deploy ship so far away from scanner.");
            return 5;
        }
        if (!this.consumeEnergy(this.getDeploymentEnergyCost(this.blocksToDeployCount), false)) {
            reason.append("Insufficient energy (" + this.getDeploymentEnergyCost(this.blocksToDeployCount) + " required)");
            return 1;
        }
        int occupiedBlockCount = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    if (this.field_145850_b.func_147437_c(this.targetX + x, this.targetY + y, this.targetZ + z)) continue;
                    ++occupiedBlockCount;
                }
            }
        }
        if (occupiedBlockCount > 0) {
            reason.append("Deploying area occupied with " + occupiedBlockCount + " blocks. Can't deploy ship.");
            return 2;
        }
        this.blocksToDeploy = new JumpBlock[this.blocksToDeployCount];
        this.isDeploying = true;
        this.currentDeployIndex = 0;
        NBTTagList localBlocks = (NBTTagList)schematic.func_74781_a("Blocks");
        byte[] localMetadata = schematic.func_74770_j("Data");
        NBTTagCompound[] tileEntities = new NBTTagCompound[this.blocksToDeployCount];
        NBTTagList tileEntitiesList = schematic.func_150295_c("TileEntities", (int)new NBTTagByteArray(new byte[0]).func_74732_a());
        for (int i = 0; i < tileEntitiesList.func_74745_c(); ++i) {
            NBTTagCompound teTag = tileEntitiesList.func_150305_b(i);
            int teX = teTag.func_74762_e("x");
            int teY = teTag.func_74762_e("y");
            int teZ = teTag.func_74762_e("z");
            tileEntities[teX + (teY * length + teZ) * width] = teTag;
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = x + (y * length + z) * width;
                    JumpBlock jb = new JumpBlock();
                    jb.x = x;
                    jb.y = y;
                    jb.z = z;
                    jb.block = Block.func_149684_b((String)localBlocks.func_150307_f(index));
                    jb.blockMeta = localMetadata[index] & 0xFF;
                    jb.blockNBT = tileEntities[index];
                    if (jb.block != null) {
                        if (WarpDriveConfig.LOGGING_BUILDING) {
                            if (tileEntities[index] == null) {
                                WarpDrive.logger.info("[ShipScanner] Adding block to deploy: " + jb.block.func_149739_a() + " (no tile entity)");
                            } else {
                                WarpDrive.logger.info("[ShipScanner] Adding block to deploy: " + jb.block.func_149739_a() + " with tile entity " + tileEntities[index].func_74779_i("id"));
                            }
                        }
                        this.blocksToDeploy[index] = jb;
                        continue;
                    }
                    this.blocksToDeploy[index] = jb = null;
                }
            }
        }
        this.setActive(true);
        reason.append("Ship deploying...");
        return 3;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] scan(Context context, Arguments arguments) {
        return this.scan(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] filename(Context context, Arguments arguments) {
        return this.filename(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] deploy(Context context, Arguments arguments) {
        return this.deploy(this.argumentsOCtoCC(arguments));
    }

    private Object[] scan(Object[] arguments) {
        if (this.isActive) {
            return new Object[]{false, 0, "Already active"};
        }
        if (this.shipCore == null) {
            return new Object[]{false, 1, "Warp-Core not found"};
        }
        if (!this.consumeEnergy(this.getScanningEnergyCost(this.shipCore.shipMass), true)) {
            return new Object[]{false, 2, "Not enough energy!"};
        }
        StringBuilder reason = new StringBuilder();
        boolean success = this.scanShip(reason);
        return new Object[]{success, 3, reason.toString()};
    }

    private Object[] filename(Object[] arguments) {
        if (this.isActive && !this.schematicFileName.isEmpty()) {
            if (this.isDeploying) {
                return new Object[]{false, "Deployment in progress. Please wait..."};
            }
            return new Object[]{false, "Scan in progress. Please wait..."};
        }
        return new Object[]{true, this.schematicFileName};
    }

    private Object[] deploy(Object[] arguments) {
        if (arguments.length == 4) {
            String fileName = (String)arguments[0];
            int x = TileEntityShipScanner.toInt(arguments[1]);
            int y = TileEntityShipScanner.toInt(arguments[2]);
            int z = TileEntityShipScanner.toInt(arguments[3]);
            if (!new File(WarpDriveConfig.G_SCHEMALOCATION + "/" + fileName).exists()) {
                return new Object[]{0, "Specified .schematic file was not found!"};
            }
            StringBuilder reason = new StringBuilder();
            int result = this.deployShip(fileName, x, y, z, reason);
            return new Object[]{result, reason.toString()};
        }
        return new Object[]{4, "Invalid arguments count, you need .schematic file name, offsetX, offsetY and offsetZ!"};
    }

    private Object[] state(Object[] arguments) {
        if (!this.isActive) {
            return new Object[]{false, "IDLE", 0, 0};
        }
        if (!this.isDeploying) {
            return new Object[]{true, "Scanning", 0, 0};
        }
        return new Object[]{true, "Deploying", this.currentDeployIndex, this.blocksToDeployCount};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("scan")) {
            return this.scan(arguments);
        }
        if (methodName.equals("fileName")) {
            return this.filename(arguments);
        }
        if (methodName.equals("deploy")) {
            return this.deploy(arguments);
        }
        if (methodName.equals("state")) {
            return this.state(arguments);
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public int getMaxEnergyStored() {
        return WarpDriveConfig.SS_MAX_ENERGY_STORED;
    }

    @Override
    public boolean canInputEnergy(ForgeDirection from) {
        return true;
    }
}

