/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractLaser;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.network.PacketHandler;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;

public class TileEntityLaser
extends TileEntityAbstractLaser {
    private final int BEAM_FREQUENCY_SCANNING = 1420;
    private final int BEAM_FREQUENCY_MAX = 65000;
    private float yaw;
    private float pitch;
    private int beamFrequency = -1;
    private int videoChannel = -1;
    private float r;
    private float g;
    private float b;
    public boolean isEmitting = false;
    private int delayTicks = 0;
    private int energyFromOtherBeams = 0;
    private ScanResultType scanResult_type = ScanResultType.IDLE;
    private VectorI scanResult_position = null;
    private String scanResult_blockUnlocalizedName;
    private int scanResult_blockMetadata = 0;
    private float scanResult_blockResistance = -2.0f;
    private static final int REGISTRY_UPDATE_INTERVAL_TICKS = 300;
    private static final int PACKET_SEND_INTERVAL_TICKS = 1200;
    private int registryUpdateTicks = 20;
    private int packetSendTicks = 20;

    public TileEntityLaser() {
        this.peripheralName = "warpdriveLaser";
        this.addMethods(new String[]{"emitBeam", "beamFrequency", "getScanResult", "videoChannel"});
        this.laserMediumMaxCount = WarpDriveConfig.LASER_CANNON_MAX_MEDIUMS_COUNT;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.isWithCamera()) {
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                --this.packetSendTicks;
                if (this.packetSendTicks <= 0) {
                    this.packetSendTicks = 1200;
                    PacketHandler.sendFreqPacket(this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.videoChannel);
                }
            } else {
                --this.registryUpdateTicks;
                if (this.registryUpdateTicks <= 0) {
                    this.registryUpdateTicks = 300;
                    WarpDrive.cameras.updateInRegistry(this.field_145850_b, new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.videoChannel, 1);
                }
            }
        }
        if (this.beamFrequency <= 0 || this.beamFrequency > 65000) {
            return;
        }
        ++this.delayTicks;
        if (this.isEmitting && (this.beamFrequency != 1420 && this.delayTicks > WarpDriveConfig.LASER_CANNON_EMIT_FIRE_DELAY_TICKS || this.beamFrequency == 1420 && this.delayTicks > WarpDriveConfig.LASER_CANNON_EMIT_SCAN_DELAY_TICKS)) {
            this.delayTicks = 0;
            this.isEmitting = false;
            int beamEnergy = Math.min(this.consumeCappedEnergyFromLaserMediums(Integer.MAX_VALUE, false) + MathHelper.func_76128_c((double)((double)this.energyFromOtherBeams * WarpDriveConfig.LASER_CANNON_BOOSTER_BEAM_ENERGY_EFFICIENCY)), WarpDriveConfig.LASER_CANNON_MAX_LASER_ENERGY);
            this.emitBeam(beamEnergy);
            this.energyFromOtherBeams = 0;
            this.sendEvent("laserSend", new Object[]{this.beamFrequency, beamEnergy});
        }
    }

    public void initiateBeamEmission(float parYaw, float parPitch) {
        this.yaw = parYaw;
        this.pitch = parPitch;
        this.delayTicks = 0;
        this.isEmitting = true;
    }

    public void addBeamEnergy(int amount) {
        if (this.isEmitting) {
            this.energyFromOtherBeams += amount;
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(this + " Added energy " + amount);
            }
        } else if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info(this + " Ignored energy " + amount);
        }
    }

    private void emitBeam(int beamEnergy) {
        int energy = beamEnergy;
        int beamLengthBlocks = TileEntityLaser.clamp(0, WarpDriveConfig.LASER_CANNON_RANGE_MAX, energy / WarpDriveConfig.LASER_CANNON_RANGE_ENERGY_PER_BLOCK);
        if (energy == 0 || beamLengthBlocks < 1 || this.beamFrequency > 65000 || this.beamFrequency <= 0) {
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info(this + " Beam canceled (energy " + energy + " over " + beamLengthBlocks + " blocks, beamFrequency " + this.beamFrequency + ")");
            }
            return;
        }
        float yawz = MathHelper.func_76134_b((float)(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawx = MathHelper.func_76126_a((float)(-this.yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchhorizontal = -MathHelper.func_76134_b((float)(-this.pitch * ((float)Math.PI / 180)));
        float pitchvertical = MathHelper.func_76126_a((float)(-this.pitch * ((float)Math.PI / 180)));
        float directionx = yawx * pitchhorizontal;
        float directionz = yawz * pitchhorizontal;
        Vector3 vDirection = new Vector3(directionx, pitchvertical, directionz);
        Vector3 vSource = new Vector3(this).translate(0.5).translate(vDirection);
        Vector3 vReachPoint = Vector3.translate(vSource.clone(), Vector3.scale(vDirection.clone(), beamLengthBlocks));
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info(this + " Energy " + energy + " over " + beamLengthBlocks + " blocks" + ", Orientation " + this.yaw + " " + this.pitch + ", Direction " + vDirection + ", From " + vSource + " to " + vReachPoint);
        }
        this.playSoundCorrespondsEnergy(energy);
        if (this.beamFrequency == 1420) {
            MovingObjectPosition mopResult = this.field_145850_b.func_72933_a(vSource.toVec3(), vReachPoint.toVec3());
            this.scanResult_blockUnlocalizedName = null;
            this.scanResult_blockMetadata = 0;
            this.scanResult_blockResistance = -2.0f;
            if (mopResult != null) {
                this.scanResult_type = ScanResultType.BLOCK;
                this.scanResult_position = new VectorI(mopResult.field_72311_b, mopResult.field_72312_c, mopResult.field_72309_d);
                Block block = this.field_145850_b.func_147439_a(this.scanResult_position.x, this.scanResult_position.y, this.scanResult_position.z);
                if (block != null) {
                    this.scanResult_blockUnlocalizedName = block.func_149739_a();
                    this.scanResult_blockMetadata = this.field_145850_b.func_72805_g(this.scanResult_position.x, this.scanResult_position.y, this.scanResult_position.z);
                    this.scanResult_blockResistance = block.func_149638_a(null);
                }
                PacketHandler.sendBeamPacket(this.field_145850_b, vSource, new Vector3(mopResult.field_72307_f), this.r, this.g, this.b, 50, energy, 200);
            } else {
                this.scanResult_type = ScanResultType.NONE;
                this.scanResult_position = new VectorI(vReachPoint.intX(), vReachPoint.intY(), vReachPoint.intZ());
                PacketHandler.sendBeamPacket(this.field_145850_b, vSource, vReachPoint, this.r, this.g, this.b, 50, energy, 200);
            }
            this.sendEvent("laserScanning", new Object[]{this.scanResult_type.name, this.scanResult_position.x, this.scanResult_position.y, this.scanResult_position.z, this.scanResult_blockUnlocalizedName, this.scanResult_blockMetadata, Float.valueOf(this.scanResult_blockResistance)});
            return;
        }
        TreeMap<Double, MovingObjectPosition> entityHits = this.raytraceEntities(vSource.clone(), vDirection.clone(), true, beamLengthBlocks);
        if (WarpDriveConfig.LOGGING_WEAPON) {
            WarpDrive.logger.info("Entity hits are (" + (entityHits == null ? 0 : entityHits.size()) + ") " + entityHits);
        }
        Vector3 vHitPoint = vReachPoint.clone();
        double distanceTravelled = 0.0;
        for (int passedBlocks = 0; passedBlocks < beamLengthBlocks; ++passedBlocks) {
            TileEntityLaser tileEntityLaser;
            MovingObjectPosition blockHit = this.field_145850_b.func_72933_a(vSource.toVec3(), vReachPoint.toVec3());
            double blockHitDistance = (double)beamLengthBlocks + 0.1;
            if (blockHit != null) {
                blockHitDistance = blockHit.field_72307_f.func_72438_d(vSource.toVec3());
            }
            if (entityHits != null) {
                Map.Entry<Double, MovingObjectPosition> entityHitEntry;
                double entityHitDistance;
                Iterator<Map.Entry<Double, MovingObjectPosition>> i$ = entityHits.entrySet().iterator();
                while (i$.hasNext() && !((entityHitDistance = (entityHitEntry = i$.next()).getKey().doubleValue()) >= blockHitDistance)) {
                    MovingObjectPosition mopEntity = entityHitEntry.getValue();
                    if (mopEntity == null) continue;
                    EntityLivingBase entity = null;
                    if (mopEntity.field_72308_g instanceof EntityLivingBase) {
                        entity = (EntityLivingBase)mopEntity.field_72308_g;
                        if (WarpDriveConfig.LOGGING_WEAPON) {
                            WarpDrive.logger.info("Entity is a valid target (living) " + entity);
                        }
                    } else {
                        String entityId = EntityList.func_75621_b((Entity)mopEntity.field_72308_g);
                        if (!WarpDriveConfig.ENTITIES_NONLIVINGTARGET.contains(entityId)) {
                            if (!WarpDriveConfig.LOGGING_WEAPON) continue;
                            WarpDrive.logger.info("Entity is an invalid target (non-living " + entityId + ") " + mopEntity.field_72308_g);
                            continue;
                        }
                        if (WarpDriveConfig.LOGGING_WEAPON) {
                            WarpDrive.logger.info("Entity is a valid target (non-living " + entityId + ") " + mopEntity.field_72308_g);
                        }
                    }
                    energy = (int)((double)energy - ((double)WarpDriveConfig.LASER_CANNON_ENTITY_HIT_ENERGY + (blockHitDistance - distanceTravelled) * (double)WarpDriveConfig.LASER_CANNON_ENERGY_LOSS_PER_BLOCK));
                    distanceTravelled = blockHitDistance;
                    vHitPoint = new Vector3(mopEntity.field_72307_f);
                    if (energy <= 0) break;
                    mopEntity.field_72308_g.func_70015_d(WarpDriveConfig.LASER_CANNON_ENTITY_HIT_SET_ON_FIRE_SECONDS);
                    if (entity != null) {
                        float damage = (float)TileEntityLaser.clamp(0.0, (double)WarpDriveConfig.LASER_CANNON_ENTITY_HIT_MAX_DAMAGE, (double)(WarpDriveConfig.LASER_CANNON_ENTITY_HIT_BASE_DAMAGE + energy / WarpDriveConfig.LASER_CANNON_ENTITY_HIT_ENERGY_PER_DAMAGE));
                        entity.func_70097_a(DamageSource.field_76372_a, damage);
                    } else {
                        mopEntity.field_72308_g.func_70106_y();
                    }
                    if (energy > WarpDriveConfig.LASER_CANNON_ENTITY_HIT_ENERGY_THRESHOLD_FOR_EXPLOSION) {
                        float strength = (float)TileEntityLaser.clamp(0.0, WarpDriveConfig.LASER_CANNON_ENTITY_HIT_EXPLOSION_MAX_STRENGTH, WarpDriveConfig.LASER_CANNON_ENTITY_HIT_EXPLOSION_BASE_STRENGTH + (float)(energy / WarpDriveConfig.LASER_CANNON_ENTITY_HIT_EXPLOSION_ENERGY_PER_STRENGTH));
                        this.field_145850_b.func_72885_a(null, mopEntity.field_72308_g.field_70165_t, mopEntity.field_72308_g.field_70163_u, mopEntity.field_72308_g.field_70161_v, strength, true, true);
                    }
                    entityHits.put(entityHitDistance, null);
                }
                if (energy <= 0) break;
            }
            if (blockHitDistance >= (double)beamLengthBlocks || blockHit == null) {
                vHitPoint = vReachPoint;
                break;
            }
            Block block = this.field_145850_b.func_147439_a(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d);
            float resistance = block.func_149638_a(null);
            if (block.func_149667_c(Blocks.field_150357_h)) {
                vHitPoint = new Vector3(blockHit.field_72307_f);
                break;
            }
            if ((block.func_149667_c(WarpDrive.blockLaser) || block.func_149667_c(WarpDrive.blockLaserCamera)) && (tileEntityLaser = (TileEntityLaser)this.field_145850_b.func_147438_o(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d)) != null && tileEntityLaser.getBeamFrequency() == this.beamFrequency) {
                tileEntityLaser.addBeamEnergy(energy);
                vHitPoint = new Vector3(blockHit.field_72307_f);
                break;
            }
            if (block.func_149688_o() == Material.field_151592_s) {
                this.field_145850_b.func_147468_f(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d);
                vHitPoint = new Vector3(blockHit.field_72307_f);
            }
            energy = (int)((double)energy - ((double)((float)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ENERGY + resistance * (float)WarpDriveConfig.LASER_CANNON_BLOCK_HIT_ENERGY_PER_BLOCK_RESISTANCE) + (blockHitDistance - distanceTravelled) * (double)WarpDriveConfig.LASER_CANNON_ENERGY_LOSS_PER_BLOCK));
            distanceTravelled = blockHitDistance;
            vHitPoint = new Vector3(blockHit.field_72307_f);
            if (energy <= 0) break;
            if ((double)resistance >= WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_RESISTANCE_THRESHOLD) {
                float strength = (float)TileEntityLaser.clamp(0.0, WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_MAX_STRENGTH, WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_BASE_STRENGTH + (float)(energy / WarpDriveConfig.LASER_CANNON_BLOCK_HIT_EXPLOSION_ENERGY_PER_STRENGTH));
                this.field_145850_b.func_72885_a(null, (double)blockHit.field_72311_b, (double)blockHit.field_72312_c, (double)blockHit.field_72309_d, strength, true, true);
                this.field_145850_b.func_147449_b(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d, (Block)(this.field_145850_b.field_73012_v.nextBoolean() ? Blocks.field_150480_ab : Blocks.field_150350_a));
                continue;
            }
            this.field_145850_b.func_147468_f(blockHit.field_72311_b, blockHit.field_72312_c, blockHit.field_72309_d);
        }
        PacketHandler.sendBeamPacket(this.field_145850_b, new Vector3(this).translate(0.5).translate(vDirection.scale(0.5)), vHitPoint, this.r, this.g, this.b, 50, energy, beamLengthBlocks);
    }

    public TreeMap<Double, MovingObjectPosition> raytraceEntities(Vector3 vSource, Vector3 vDirection, boolean collisionFlag, double reachDistance) {
        double raytraceTolerance = 2.0;
        Vec3 vec3Source = vSource.toVec3();
        Vec3 vec3Target = Vec3.func_72443_a((double)(vec3Source.field_72450_a + vDirection.x * reachDistance), (double)(vec3Source.field_72448_b + vDirection.y * reachDistance), (double)(vec3Source.field_72449_c + vDirection.z * reachDistance));
        AxisAlignedBB boxToScan = AxisAlignedBB.func_72330_a((double)Math.min((double)this.field_145851_c - 2.0, vec3Target.field_72450_a - 2.0), (double)Math.min((double)this.field_145848_d - 2.0, vec3Target.field_72448_b - 2.0), (double)Math.min((double)this.field_145849_e - 2.0, vec3Target.field_72449_c - 2.0), (double)Math.max((double)this.field_145851_c + 2.0, vec3Target.field_72450_a + 2.0), (double)Math.max((double)this.field_145848_d + 2.0, vec3Target.field_72448_b + 2.0), (double)Math.max((double)this.field_145849_e + 2.0, vec3Target.field_72449_c + 2.0));
        List entities = this.field_145850_b.func_72839_b(null, boxToScan);
        if (entities == null || entities.isEmpty()) {
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info("No entity on trajectory (box)");
            }
            return null;
        }
        HashMap<Double, MovingObjectPosition> entityHits = new HashMap<Double, MovingObjectPosition>(entities.size());
        for (Entity entity : entities) {
            if (entity == null || !entity.func_70067_L() || entity.field_70121_D == null) continue;
            double border = entity.func_70111_Y();
            AxisAlignedBB aabbEntity = entity.field_70121_D.func_72314_b(border, border, border);
            MovingObjectPosition hitMOP = aabbEntity.func_72327_a(vec3Source, vec3Target);
            if (WarpDriveConfig.LOGGING_WEAPON) {
                WarpDrive.logger.info("Checking " + entity + " boundingBox " + entity.field_70121_D + " border " + border + " aabbEntity " + aabbEntity + " hitMOP " + hitMOP);
            }
            if (hitMOP == null) continue;
            MovingObjectPosition mopEntity = new MovingObjectPosition(entity);
            mopEntity.field_72307_f = hitMOP.field_72307_f;
            double distance = vec3Source.func_72438_d(hitMOP.field_72307_f);
            if (entityHits.containsKey(distance)) {
                distance += this.field_145850_b.field_73012_v.nextDouble() / 10.0;
            }
            entityHits.put(distance, mopEntity);
        }
        if (entityHits.isEmpty()) {
            return null;
        }
        return new TreeMap<Double, MovingObjectPosition>(entityHits);
    }

    public boolean isWithCamera() {
        return this.func_145838_q().func_149667_c(WarpDrive.blockLaserCamera);
    }

    public int getBeamFrequency() {
        return this.beamFrequency;
    }

    public void setBeamFrequency(int parBeamFrequency) {
        if (this.beamFrequency != parBeamFrequency && parBeamFrequency <= 65000 && parBeamFrequency > 0) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Beam frequency set from " + this.beamFrequency + " to " + parBeamFrequency);
            }
            this.beamFrequency = parBeamFrequency;
        }
        this.updateColor();
    }

    public int getVideoChannel() {
        return this.videoChannel;
    }

    public void setVideoChannel(int parVideoChannel) {
        if (this.videoChannel != parVideoChannel) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(this + " Video channel updated from " + this.videoChannel + " to " + parVideoChannel);
            }
            this.videoChannel = parVideoChannel;
            this.packetSendTicks = 0;
            this.registryUpdateTicks = 0;
        }
    }

    private void playSoundCorrespondsEnergy(int energy) {
        if (energy <= 500000) {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d - 0.5f), (double)((float)this.field_145849_e + 0.5f), "warpdrive:lowlaser", 4.0f, 1.0f);
        } else if (energy > 500000 && energy <= 1000000) {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d - 0.5f), (double)((float)this.field_145849_e + 0.5f), "warpdrive:midlaser", 4.0f, 1.0f);
        } else if (energy > 1000000) {
            this.field_145850_b.func_72908_a((double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d - 0.5f), (double)((float)this.field_145849_e + 0.5f), "warpdrive:hilaser", 4.0f, 1.0f);
        }
    }

    private void updateColor() {
        if (this.beamFrequency <= 0) {
            this.r = 1.0f;
            this.g = 0.0f;
            this.b = 0.0f;
        } else if (this.beamFrequency <= 10000) {
            this.r = 1.0f;
            this.g = 0.0f;
            this.b = 0.0f + 0.5f * (float)this.beamFrequency / 10000.0f;
        } else if (this.beamFrequency <= 20000) {
            this.r = 1.0f;
            this.g = 0.0f + 1.0f * ((float)this.beamFrequency - 10000.0f) / 10000.0f;
            this.b = 0.5f - 0.5f * ((float)this.beamFrequency - 10000.0f) / 10000.0f;
        } else if (this.beamFrequency <= 30000) {
            this.r = 1.0f - 1.0f * ((float)this.beamFrequency - 20000.0f) / 10000.0f;
            this.g = 1.0f;
            this.b = 0.0f;
        } else if (this.beamFrequency <= 40000) {
            this.r = 0.0f;
            this.g = 1.0f - 1.0f * ((float)this.beamFrequency - 30000.0f) / 10000.0f;
            this.b = 0.0f + 1.0f * ((float)this.beamFrequency - 30000.0f) / 10000.0f;
        } else if (this.beamFrequency <= 50000) {
            this.r = 0.0f + 0.5f * ((float)this.beamFrequency - 40000.0f) / 10000.0f;
            this.g = 0.0f;
            this.b = 1.0f - 0.5f * ((float)this.beamFrequency - 40000.0f) / 10000.0f;
        } else if (this.beamFrequency <= 60000) {
            this.r = 0.5f + 0.5f * ((float)this.beamFrequency - 50000.0f) / 10000.0f;
            this.g = 0.0f;
            this.b = 0.5f - 0.5f * ((float)this.beamFrequency - 50000.0f) / 10000.0f;
        } else if (this.beamFrequency <= 65000) {
            int component = Math.round(4096.0f * ((float)this.beamFrequency - 60000.0f) / 5000.0f);
            this.r = 1.0f - 0.5f * (float)(component & 0xF);
            this.g = 0.5f + 0.5f * (float)(component >> 4 & 0xF);
            this.b = 0.5f + 0.5f * (float)(component >> 8 & 0xF);
        } else {
            this.r = 1.0f;
            this.g = 0.0f;
            this.b = 0.0f;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.setBeamFrequency(tag.func_74762_e("beamFrequency"));
        this.setVideoChannel(tag.func_74762_e("cameraFrequency") + tag.func_74762_e("videoChannel"));
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("beamFrequency", this.beamFrequency);
        tag.func_74768_a("videoChannel", this.videoChannel);
    }

    @Override
    public void func_145843_s() {
        WarpDrive.cameras.removeFromRegistry(this.field_145850_b, new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        WarpDrive.cameras.removeFromRegistry(this.field_145850_b, new ChunkPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        super.onChunkUnload();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] emitBeam(Context context, Arguments arguments) {
        return this.emitBeam(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] beamFrequency(Context context, Arguments arguments) {
        if (arguments.count() == 1) {
            this.setBeamFrequency(arguments.checkInteger(0));
        }
        return new Integer[]{this.beamFrequency};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getScanResult(Context context, Arguments arguments) {
        return this.getScanResult();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] videoChannel(Context context, Arguments arguments) {
        if (this.isWithCamera()) {
            if (arguments.count() == 1) {
                this.setVideoChannel(arguments.checkInteger(0));
            }
            return new Integer[]{this.videoChannel};
        }
        return null;
    }

    private Object[] emitBeam(Object[] arguments) {
        try {
            if (arguments.length == 2) {
                float newYaw = TileEntityLaser.toFloat(arguments[0]);
                float newPitch = TileEntityLaser.toFloat(arguments[1]);
                this.initiateBeamEmission(newYaw, newPitch);
            } else if (arguments.length == 3) {
                float deltaX = -TileEntityLaser.toFloat(arguments[0]);
                float deltaY = -TileEntityLaser.toFloat(arguments[1]);
                float deltaZ = TileEntityLaser.toFloat(arguments[2]);
                double horizontalDistance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
                float newYaw = (float)(Math.atan2(deltaX, deltaZ) * 180.0 / Math.PI);
                float newPitch = (float)(Math.atan2(deltaY, horizontalDistance) * 180.0 / Math.PI);
                this.initiateBeamEmission(newYaw, newPitch);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Object[]{false};
        }
        return new Object[]{true};
    }

    private Object[] getScanResult() {
        if (this.scanResult_type != ScanResultType.IDLE) {
            try {
                Object[] info = new Object[]{this.scanResult_type.name, this.scanResult_position.x, this.scanResult_position.y, this.scanResult_position.z, this.scanResult_blockUnlocalizedName, this.scanResult_blockMetadata, Float.valueOf(this.scanResult_blockResistance)};
                this.scanResult_type = ScanResultType.IDLE;
                this.scanResult_position = null;
                this.scanResult_blockUnlocalizedName = null;
                this.scanResult_blockMetadata = 0;
                this.scanResult_blockResistance = -2.0f;
                return info;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new Object[]{"!ERROR!", 0, 0, 0, null, 0, -3};
            }
        }
        return new Object[]{this.scanResult_type.name, 0, 0, 0, null, 0, -1};
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("emitBeam")) {
            return this.emitBeam(arguments);
        }
        if (methodName.equals("position")) {
            return new Integer[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
        }
        if (methodName.equals("beamFrequency")) {
            if (arguments.length == 1) {
                this.setBeamFrequency(TileEntityLaser.toInt(arguments[0]));
            }
            return new Integer[]{this.beamFrequency};
        }
        if (methodName.equals("getScanResult")) {
            return this.getScanResult();
        }
        if (methodName.equals("videoChannel")) {
            if (this.isWithCamera()) {
                if (arguments.length == 1) {
                    this.setVideoChannel(TileEntityLaser.toInt(arguments[0]));
                }
                return new Integer[]{this.videoChannel};
            }
            return null;
        }
        return super.callMethod(computer, context, method, arguments);
    }

    public String toString() {
        return String.format("%s Beam '%d' Camera '%d' @ '%s' %d, %d, %d", this.getClass().getSimpleName(), this.beamFrequency, this.videoChannel, this.field_145850_b == null ? "~NULL~" : this.field_145850_b.func_72912_H().func_76065_j(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static enum ScanResultType {
        IDLE("IDLE"),
        BLOCK("BLOCK"),
        NONE("NONE");

        public String name;

        private ScanResultType(String name) {
            this.name = name;
        }
    }
}

