/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.api.IUpgradable;
import cr0s.warpdrive.block.TileEntityAbstractChunkLoading;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.UpgradeType;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;

public class TileEntityChunkLoader
extends TileEntityAbstractChunkLoading
implements IUpgradable {
    private boolean canLoad = false;
    private boolean shouldLoad = false;
    private boolean inited = false;
    private ChunkCoordIntPair myChunk;
    int negDX;
    int posDX;
    int negDZ;
    int posDZ;
    int area = 1;

    public TileEntityChunkLoader() {
        this.IC2_sinkTier = 2;
        this.IC2_sourceTier = 2;
        this.negDX = 0;
        this.negDZ = 0;
        this.posDX = 0;
        this.posDZ = 0;
        this.peripheralName = "warpdriveChunkloader";
        this.addMethods(new String[]{"radius", "bounds", "active", "upgrades"});
    }

    @Override
    public int getMaxEnergyStored() {
        return WarpDriveConfig.CL_MAX_ENERGY;
    }

    @Override
    public boolean shouldChunkLoad() {
        return this.shouldLoad && this.canLoad;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.inited) {
            this.inited = true;
            this.myChunk = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76632_l();
            this.changedDistance();
        }
        this.canLoad = this.shouldLoad ? this.consumeEnergy(this.area * WarpDriveConfig.CL_RF_PER_CHUNKTICK, false) : this.consumeEnergy(this.area * WarpDriveConfig.CL_RF_PER_CHUNKTICK, true);
    }

    private void changedDistance() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.myChunk == null) {
            Chunk aChunk = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e);
            if (aChunk != null) {
                this.myChunk = aChunk.func_76632_l();
            } else {
                return;
            }
        }
        this.negDX = -TileEntityChunkLoader.clamp(0, WarpDriveConfig.CL_MAX_DISTANCE, this.negDX);
        this.posDX = TileEntityChunkLoader.clamp(0, WarpDriveConfig.CL_MAX_DISTANCE, this.posDX);
        this.negDZ = -TileEntityChunkLoader.clamp(0, WarpDriveConfig.CL_MAX_DISTANCE, this.negDZ);
        this.posDZ = TileEntityChunkLoader.clamp(0, WarpDriveConfig.CL_MAX_DISTANCE, this.posDZ);
        this.minChunk = new ChunkCoordIntPair(this.myChunk.field_77276_a + this.negDX, this.myChunk.field_77275_b + this.negDZ);
        this.maxChunk = new ChunkCoordIntPair(this.myChunk.field_77276_a + this.posDX, this.myChunk.field_77275_b + this.posDZ);
        this.area = (this.posDX - this.negDX + 1) * (this.posDZ - this.negDZ + 1);
        this.refreshLoading(true);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.negDX = nbt.func_74762_e("negDX");
        this.negDZ = nbt.func_74762_e("negDZ");
        this.posDX = nbt.func_74762_e("posDX");
        this.posDZ = nbt.func_74762_e("posDZ");
        this.changedDistance();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("negDX", this.negDX);
        nbt.func_74768_a("negDZ", this.negDZ);
        nbt.func_74768_a("posDX", this.posDX);
        nbt.func_74768_a("posDZ", this.posDZ);
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("radius")) {
            if (arguments.length == 1) {
                int dist;
                this.negDX = dist = TileEntityChunkLoader.toInt(arguments[0]);
                this.negDZ = dist;
                this.posDX = dist;
                this.posDZ = dist;
                this.changedDistance();
                return new Object[]{true};
            }
            return new Object[]{false};
        }
        if (methodName.equals("bounds")) {
            if (arguments.length == 4) {
                this.negDX = TileEntityChunkLoader.toInt(arguments[0]);
                this.posDX = TileEntityChunkLoader.toInt(arguments[1]);
                this.negDZ = TileEntityChunkLoader.toInt(arguments[2]);
                this.posDZ = TileEntityChunkLoader.toInt(arguments[3]);
                this.changedDistance();
            }
            return new Object[]{this.negDX, this.posDX, this.negDZ, this.posDZ};
        }
        if (methodName.equals("active")) {
            if (arguments.length == 1) {
                this.shouldLoad = TileEntityChunkLoader.toBool(arguments[0]);
            }
            return new Object[]{this.shouldChunkLoad()};
        }
        if (methodName.equals("upgrades")) {
            return this.getUpgrades();
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public boolean takeUpgrade(UpgradeType upgradeType, boolean simulate) {
        int max = 0;
        if (upgradeType == UpgradeType.Energy) {
            max = 2;
        } else if (upgradeType == UpgradeType.Power) {
            max = 2;
        }
        if (max == 0) {
            return false;
        }
        if (this.upgrades.containsKey((Object)upgradeType) && (Integer)this.upgrades.get((Object)upgradeType) >= max) {
            return false;
        }
        if (!simulate) {
            int c = 0;
            if (this.upgrades.containsKey((Object)upgradeType)) {
                c = (Integer)this.upgrades.get((Object)upgradeType);
            }
            this.upgrades.put(upgradeType, c + 1);
        }
        return true;
    }

    @Override
    public Map<UpgradeType, Integer> getInstalledUpgrades() {
        return this.upgrades;
    }
}

