/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cpw.mods.fml.common.FMLCommonHandler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAirGenerator
extends TileEntityAbstractEnergy {
    private int cooldownTicks = 0;
    private final int START_CONCENTRATION_VALUE = 15;

    public TileEntityAirGenerator() {
        this.peripheralName = "warpdriveAirGenerator";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (this.func_145837_r()) {
            return;
        }
        if (this.field_145850_b.field_73011_w.field_76574_g != WarpDriveConfig.G_SPACE_DIMENSION_ID && this.field_145850_b.field_73011_w.field_76574_g != WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID) {
            if (this.func_145832_p() != 0) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
            }
            return;
        }
        ++this.cooldownTicks;
        if (this.cooldownTicks > WarpDriveConfig.AIRGEN_AIR_GENERATION_TICKS) {
            if (this.consumeEnergy(WarpDriveConfig.AIRGEN_ENERGY_PER_NEWAIRBLOCK, true)) {
                if (this.func_145832_p() != 1) {
                    this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
                }
            } else if (this.func_145832_p() != 0) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
            }
            this.releaseAir(1, 0, 0);
            this.releaseAir(-1, 0, 0);
            this.releaseAir(0, 1, 0);
            this.releaseAir(0, -1, 0);
            this.releaseAir(0, 0, 1);
            this.releaseAir(0, 0, -1);
            this.cooldownTicks = 0;
        }
    }

    private void releaseAir(int xOffset, int yOffset, int zOffset) {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c + xOffset, this.field_145848_d + yOffset, this.field_145849_e + zOffset);
        if (block.isAir((IBlockAccess)this.field_145850_b, xOffset, yOffset, zOffset)) {
            int energy_cost;
            int n = energy_cost = !block.func_149667_c(WarpDrive.blockAir) ? WarpDriveConfig.AIRGEN_ENERGY_PER_NEWAIRBLOCK : WarpDriveConfig.AIRGEN_ENERGY_PER_EXISTINGAIRBLOCK;
            if (this.consumeEnergy(energy_cost, true)) {
                if (this.field_145850_b.func_147465_d(this.field_145851_c + xOffset, this.field_145848_d + yOffset, this.field_145849_e + zOffset, WarpDrive.blockAir, 15, 2)) {
                    this.consumeEnergy(WarpDriveConfig.AIRGEN_ENERGY_PER_NEWAIRBLOCK, false);
                } else {
                    this.consumeEnergy(WarpDriveConfig.AIRGEN_ENERGY_PER_EXISTINGAIRBLOCK, false);
                }
            } else if (block.func_149667_c(WarpDrive.blockAir)) {
                int metadata = this.field_145850_b.func_72805_g(this.field_145851_c + xOffset, this.field_145848_d + yOffset, this.field_145849_e + zOffset);
                if (metadata > 4) {
                    this.field_145850_b.func_72921_c(this.field_145851_c + xOffset, this.field_145848_d + yOffset, this.field_145849_e + zOffset, metadata - 4, 2);
                } else if (metadata > 1) {
                    this.field_145850_b.func_72921_c(this.field_145851_c + xOffset, this.field_145848_d + yOffset, this.field_145849_e + zOffset, 1, 2);
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
    }

    @Override
    public int getMaxEnergyStored() {
        return WarpDriveConfig.AIRGEN_MAX_ENERGY_STORED;
    }

    @Override
    public boolean canInputEnergy(ForgeDirection from) {
        return true;
    }
}

