/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.block.TileEntityAbstractInterfaced;
import cr0s.warpdrive.block.TileEntityLaserMedium;
import cr0s.warpdrive.config.WarpDriveConfig;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.LinkedList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityAbstractLaser
extends TileEntityAbstractInterfaced {
    protected ForgeDirection directionLaserMedium = ForgeDirection.UNKNOWN;
    protected ForgeDirection[] directionsValidLaserMedium = ForgeDirection.VALID_DIRECTIONS;
    protected int laserMediumMaxCount = 0;
    protected int laserMediumCount = 0;
    private final int updateInterval_ticks;
    private int updateTicks = this.updateInterval_ticks = 20 * WarpDriveConfig.SHIP_CONTROLLER_UPDATE_INTERVAL_SECONDS;
    private int bootTicks = 20;

    public TileEntityAbstractLaser() {
        this.addMethods(new String[]{"energy", "laserMediumDirection", "laserMediumCount"});
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (this.bootTicks > 0) {
            --this.bootTicks;
            if (this.directionLaserMedium == ForgeDirection.UNKNOWN) {
                this.updateTicks = 1;
            }
        }
        --this.updateTicks;
        if (this.updateTicks <= 0) {
            this.updateTicks = this.updateInterval_ticks;
            this.updateLaserMediumStatus();
        }
    }

    private void updateLaserMediumStatus() {
        for (ForgeDirection direction : this.directionsValidLaserMedium) {
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (tileEntity == null || !(tileEntity instanceof TileEntityLaserMedium)) continue;
            this.directionLaserMedium = direction;
            this.laserMediumCount = 0;
            while (tileEntity != null && tileEntity instanceof TileEntityLaserMedium && this.laserMediumCount < this.laserMediumMaxCount) {
                ++this.laserMediumCount;
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + (this.laserMediumCount + 1) * direction.offsetX, this.field_145848_d + (this.laserMediumCount + 1) * direction.offsetY, this.field_145849_e + (this.laserMediumCount + 1) * direction.offsetZ);
            }
            return;
        }
        this.directionLaserMedium = ForgeDirection.UNKNOWN;
    }

    protected int getEnergyStored() {
        return this.consumeCappedEnergyFromLaserMediums(Integer.MAX_VALUE, true);
    }

    protected boolean consumeEnergyFromLaserMediums(int amount, boolean simulate) {
        return amount <= this.consumeCappedEnergyFromLaserMediums(amount, simulate);
    }

    protected int consumeCappedEnergyFromLaserMediums(int amount, boolean simulate) {
        TileEntity tileEntity;
        int count;
        if (this.directionLaserMedium == ForgeDirection.UNKNOWN) {
            return 0;
        }
        int totalEnergy = 0;
        LinkedList<TileEntityLaserMedium> laserMediums = new LinkedList<TileEntityLaserMedium>();
        for (count = 1; count <= this.laserMediumMaxCount && (tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + count * this.directionLaserMedium.offsetX, this.field_145848_d + count * this.directionLaserMedium.offsetY, this.field_145849_e + count * this.directionLaserMedium.offsetZ)) instanceof TileEntityLaserMedium; ++count) {
            laserMediums.add((TileEntityLaserMedium)tileEntity);
            totalEnergy += ((TileEntityLaserMedium)tileEntity).getEnergyStored();
        }
        if (--count == 0) {
            return 0;
        }
        if (simulate) {
            return totalEnergy;
        }
        int energyAverage = amount / count;
        int energyLeftOver = amount - energyAverage * count;
        if (energyAverage >= WarpDriveConfig.LASER_MEDIUM_MAX_ENERGY_STORED) {
            energyAverage = WarpDriveConfig.LASER_MEDIUM_MAX_ENERGY_STORED;
            energyLeftOver = 0;
        }
        for (TileEntityLaserMedium laserMedium : laserMediums) {
            int energyStored = laserMedium.getEnergyStored();
            if (energyStored >= energyAverage) continue;
            energyLeftOver += energyAverage - energyStored;
        }
        int energyTotalConsumed = 0;
        for (TileEntityLaserMedium laserMedium : laserMediums) {
            int energyStored = laserMedium.getEnergyStored();
            int energyToConsume = Math.min(energyStored, energyAverage + energyLeftOver);
            energyLeftOver -= Math.max(0, energyToConsume - energyAverage);
            laserMedium.consumeEnergy(energyToConsume, simulate);
            energyTotalConsumed += energyToConsume;
        }
        return energyTotalConsumed;
    }

    protected Object[] energy() {
        TileEntity tileEntity;
        if (this.directionLaserMedium == ForgeDirection.UNKNOWN) {
            return new Object[]{0, 0};
        }
        int energyStored = 0;
        int energyStoredMax = 0;
        LinkedList<TileEntityLaserMedium> laserMediums = new LinkedList<TileEntityLaserMedium>();
        for (int count = 1; count <= this.laserMediumMaxCount && (tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + count * this.directionLaserMedium.offsetX, this.field_145848_d + count * this.directionLaserMedium.offsetY, this.field_145849_e + count * this.directionLaserMedium.offsetZ)) instanceof TileEntityLaserMedium; ++count) {
            laserMediums.add((TileEntityLaserMedium)tileEntity);
            energyStored += ((TileEntityLaserMedium)tileEntity).getEnergyStored();
            energyStoredMax += ((TileEntityLaserMedium)tileEntity).getMaxEnergyStored();
        }
        return new Object[]{energyStored, energyStoredMax};
    }

    protected Object[] laserMediumDirection() {
        return new Object[]{this.directionLaserMedium.name(), this.directionLaserMedium.offsetX, this.directionLaserMedium.offsetY, this.directionLaserMedium.offsetZ};
    }

    protected Object[] laserMediumCount() {
        return new Object[]{this.laserMediumCount};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] energy(Context context, Arguments arguments) {
        return this.energy();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] laserMediumDirection(Context context, Arguments arguments) {
        return this.laserMediumDirection();
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("energy")) {
            return this.energy();
        }
        if (methodName.equals("laserMediumDirection")) {
            return this.laserMediumDirection();
        }
        if (methodName.equals("laserMediumCount")) {
            return this.laserMediumCount();
        }
        return super.callMethod(computer, context, method, arguments);
    }
}

