/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.config.WarpDriveConfig;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import li.cil.oc.api.Network;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.Environment", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public abstract class TileEntityAbstractInterfaced
extends TileEntityAbstractBase
implements IPeripheral,
Environment {
    private boolean interfacedFirstTick = true;
    protected String peripheralName = null;
    private String[] methodsArray = new String[0];
    public static final String COMPUTER_ERROR_TAG = "!ERROR!";
    private volatile ManagedEnvironment OC_fileSystem = null;
    private volatile boolean CC_hasResource = false;
    private volatile boolean OC_hasResource = false;
    protected volatile List<String> CC_scripts = null;
    protected Node OC_node = null;
    protected boolean OC_addedToNetwork = false;
    protected HashMap<Integer, IComputerAccess> connectedComputers = new HashMap();

    public TileEntityAbstractInterfaced() {
        this.addMethods(new String[]{"interfaced", "position", "version"});
    }

    protected void addMethods(String[] methodsToAdd) {
        if (this.methodsArray == null) {
            this.methodsArray = methodsToAdd;
        } else {
            int currentLength = this.methodsArray.length;
            this.methodsArray = Arrays.copyOf(this.methodsArray, this.methodsArray.length + methodsToAdd.length);
            String[] arr$ = methodsToAdd;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String method;
                this.methodsArray[currentLength] = method = arr$[i$];
                ++currentLength;
            }
        }
    }

    protected String getMethodName(int methodIndex) {
        return this.methodsArray[methodIndex];
    }

    private boolean assetExist(String resourcePath) {
        URL url = this.getClass().getResource(resourcePath);
        return url != null;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.interfacedFirstTick) {
            if (WarpDriveConfig.isComputerCraftLoaded) {
                String CC_path = "/assets/" + "WarpDrive".toLowerCase() + "/lua.ComputerCraft/" + this.peripheralName;
                this.CC_hasResource = this.assetExist(CC_path);
            }
            if (WarpDriveConfig.isOpenComputersLoaded) {
                String OC_path = "/assets/" + "WarpDrive".toLowerCase() + "/lua.OpenComputers/" + this.peripheralName;
                this.OC_hasResource = this.assetExist(OC_path);
            }
            if (WarpDriveConfig.isOpenComputersLoaded) {
                this.OC_constructor();
            }
            this.interfacedFirstTick = false;
            return;
        }
        if (WarpDriveConfig.isOpenComputersLoaded && !this.OC_addedToNetwork) {
            this.OC_addedToNetwork = true;
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    public void func_145843_s() {
        if (WarpDriveConfig.isOpenComputersLoaded && this.OC_node != null) {
            this.OC_node.remove();
            this.OC_node = null;
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (WarpDriveConfig.isOpenComputersLoaded && this.OC_node != null) {
            this.OC_node.remove();
            this.OC_node = null;
        }
        super.onChunkUnload();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (WarpDriveConfig.isOpenComputersLoaded && this.OC_node != null && this.OC_node.host() == this) {
            this.OC_node.load(tag.func_74775_l("oc:node"));
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (WarpDriveConfig.isOpenComputersLoaded && this.OC_node != null && this.OC_node.host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.OC_node.save(nodeNbt);
            tag.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
    }

    public int hashCode() {
        return (((super.hashCode() + this.field_145850_b.field_73011_w.field_76574_g << 4) + this.field_145851_c << 4) + this.field_145848_d << 4) + this.field_145849_e;
    }

    @Optional.Method(modid="OpenComputers")
    protected Object[] argumentsOCtoCC(Arguments args) {
        Object[] arguments = new Object[args.count()];
        int index = 0;
        for (Object arg : args) {
            arguments[index] = arg;
            ++index;
        }
        return arguments;
    }

    public Object[] interfaced(Object[] arguments) {
        return new String[]{"I'm a WarpDrive computer interfaced tile entity."};
    }

    public Object[] position(Object[] arguments) {
        return new Integer[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    public Object[] version(Object[] arguments) {
        String[] strings = "1.3.13".split("-")[0].split("\\.");
        ArrayList<Integer> integers = new ArrayList<Integer>(strings.length);
        for (String string : strings) {
            integers.add(Integer.parseInt(string));
        }
        return integers.toArray();
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.peripheralName;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return this.methodsArray;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("interfaced")) {
            return this.interfaced(arguments);
        }
        if (methodName.equals("position")) {
            return this.position(arguments);
        }
        if (methodName.equals("version")) {
            return this.version(arguments);
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
        int id = computer.getID();
        this.connectedComputers.put(id, computer);
        if (this.CC_hasResource && WarpDriveConfig.G_LUA_SCRIPTS != 0) {
            computer.mount("/" + this.peripheralName, ComputerCraftAPI.createResourceMount(WarpDrive.class, (String)"WarpDrive".toLowerCase(), (String)("lua.ComputerCraft/" + this.peripheralName)));
            computer.mount("/warpupdater", ComputerCraftAPI.createResourceMount(WarpDrive.class, (String)"WarpDrive".toLowerCase(), (String)"lua.ComputerCraft/common/updater"));
            if (WarpDriveConfig.G_LUA_SCRIPTS == 2) {
                for (String script : this.CC_scripts) {
                    computer.mount("/" + script, ComputerCraftAPI.createResourceMount(WarpDrive.class, (String)"WarpDrive".toLowerCase(), (String)("lua.ComputerCraft/" + this.peripheralName + "/" + script)));
                }
            }
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
        int id = computer.getID();
        if (this.connectedComputers.containsKey(id)) {
            this.connectedComputers.remove(id);
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return other.hashCode() == this.hashCode();
    }

    protected void sendEvent(String eventName, Object[] arguments) {
        if (WarpDriveConfig.LOGGING_LUA) {
            WarpDrive.logger.info(this + " Sending event '" + eventName + "'");
        }
        if (WarpDriveConfig.isComputerCraftLoaded) {
            Set<Integer> keys = this.connectedComputers.keySet();
            for (Integer key : keys) {
                IComputerAccess comp = this.connectedComputers.get(key);
                comp.queueEvent(eventName, arguments);
            }
        }
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] position(Context context, Arguments arguments) {
        return this.position(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] version(Context context, Arguments arguments) {
        return this.version(this.argumentsOCtoCC(arguments));
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] interfaced(Context context, Arguments arguments) {
        return this.interfaced(this.argumentsOCtoCC(arguments));
    }

    @Optional.Method(modid="OpenComputers")
    private void OC_constructor() {
        this.OC_node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.peripheralName).create();
        if (this.OC_hasResource && WarpDriveConfig.G_LUA_SCRIPTS != 0) {
            this.OC_fileSystem = li.cil.oc.api.FileSystem.asManagedEnvironment((FileSystem)li.cil.oc.api.FileSystem.fromClass(this.getClass(), (String)"WarpDrive".toLowerCase(), (String)("lua.OpenComputers/" + this.peripheralName)), (String)this.peripheralName);
        }
    }

    @Optional.Method(modid="OpenComputers")
    public Node node() {
        return this.OC_node;
    }

    @Optional.Method(modid="OpenComputers")
    public void onConnect(Node node) {
        if (node.host() instanceof Context && this.OC_fileSystem != null) {
            node.connect(this.OC_fileSystem.node());
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onDisconnect(Node node) {
        if (this.OC_fileSystem != null) {
            if (node.host() instanceof Context) {
                node.disconnect(this.OC_fileSystem.node());
            } else if (node == this.OC_node) {
                this.OC_fileSystem.node().remove();
            }
        }
    }

    @Optional.Method(modid="OpenComputers")
    public void onMessage(Message message) {
    }
}

