/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cr0s.warpdrive.block.TileEntityAbstractInterfaced;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.UpgradeType;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHCore"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2API"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2API")})
public abstract class TileEntityAbstractEnergy
extends TileEntityAbstractInterfaced
implements IEnergyHandler,
IEnergySink,
IEnergySource {
    protected boolean addedToEnergyNet = false;
    protected int energyStored_internal = 0;
    private static final double EU_PER_INTERNAL = 1.0;
    private static final double RF_PER_INTERNAL = 4.114285714285714;
    protected int IC2_sinkTier = 3;
    protected int IC2_sourceTier = 3;
    private int scanTickCount = -1;
    private Object[] cofhEnergyHandlers;
    protected HashMap<UpgradeType, Integer> upgrades = new HashMap();

    public TileEntityAbstractEnergy() {
        if (WarpDriveConfig.isThermalExpansionLoaded) {
            this.RF_initialiseAPI();
        }
        this.addMethods(new String[]{"energy"});
    }

    public Object[] getUpgrades() {
        Object[] retVal = new Object[UpgradeType.values().length];
        for (UpgradeType type : UpgradeType.values()) {
            int am = 0;
            if (this.upgrades.containsKey((Object)type)) {
                am = this.upgrades.get((Object)type);
            }
            retVal[type.ordinal()] = type.toString() + ":" + am;
        }
        return retVal;
    }

    protected static int convertInternalToRF(int energy) {
        return (int)Math.round((double)energy * 4.114285714285714);
    }

    protected static int convertRFtoInternal(int energy) {
        return (int)Math.round((double)energy / 4.114285714285714);
    }

    protected static double convertInternalToEU(int energy) {
        return Math.round((double)energy * 1.0);
    }

    protected static int convertEUtoInternal(double amount) {
        return (int)Math.round(amount / 1.0);
    }

    public int getEnergyStored() {
        return this.energyStored_internal;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public int getPotentialEnergyOutput() {
        return 0;
    }

    protected void energyOutputDone(int energyOutput_internal) {
        this.consumeEnergy(energyOutput_internal, false);
    }

    public boolean canInputEnergy(ForgeDirection from) {
        return false;
    }

    public boolean canOutputEnergy(ForgeDirection to) {
        return false;
    }

    public boolean consumeEnergy(int amount_internal, boolean simulate) {
        double valueMul;
        int amountUpgraded = amount_internal;
        if (this.upgrades.containsKey((Object)UpgradeType.Power)) {
            valueMul = Math.pow(0.8, this.upgrades.get((Object)UpgradeType.Power).intValue());
            amountUpgraded = (int)Math.ceil(valueMul * (double)amountUpgraded);
        }
        if (this.upgrades.containsKey((Object)UpgradeType.Range)) {
            valueMul = Math.pow(1.2, this.upgrades.get((Object)UpgradeType.Range).intValue());
            amountUpgraded = (int)Math.ceil(valueMul * (double)amountUpgraded);
        }
        if (this.upgrades.containsKey((Object)UpgradeType.Speed)) {
            valueMul = Math.pow(1.2, this.upgrades.get((Object)UpgradeType.Speed).intValue());
            amountUpgraded = (int)Math.ceil(valueMul * (double)amountUpgraded);
        }
        if (this.getEnergyStored() >= amount_internal) {
            if (!simulate) {
                this.energyStored_internal -= amount_internal;
            }
            return true;
        }
        return false;
    }

    public int consumeAllEnergy() {
        int temp = this.energyStored_internal;
        this.energyStored_internal = 0;
        return temp;
    }

    public Object[] energy() {
        return new Object[]{this.getEnergyStored(), this.getMaxEnergyStored()};
    }

    public String getStatus() {
        if (this.getMaxEnergyStored() != 0) {
            return this.func_145838_q().func_149732_F() + String.format(" energy level is %.0f/%.0f EU.", TileEntityAbstractEnergy.convertInternalToEU(this.getEnergyStored()), TileEntityAbstractEnergy.convertInternalToEU(this.getMaxEnergyStored()));
        }
        return this.func_145838_q().func_149732_F();
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] energy(Context context, Arguments arguments) {
        return this.energy();
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("energy")) {
            return this.energy();
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (WarpDriveConfig.isIndustrialCraft2loaded) {
            this.IC2_addToEnergyNet();
        }
        if (WarpDriveConfig.isThermalExpansionLoaded) {
            ++this.scanTickCount;
            if (this.scanTickCount >= 20) {
                this.scanTickCount = 0;
                this.scanForEnergyHandlers();
            }
            this.outputEnergy();
        }
    }

    @Override
    public void onChunkUnload() {
        if (WarpDriveConfig.isIndustrialCraft2loaded) {
            this.IC2_removeFromEnergyNet();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        if (WarpDriveConfig.isIndustrialCraft2loaded) {
            this.IC2_removeFromEnergyNet();
        }
        super.func_145843_s();
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return Math.max(0.0, TileEntityAbstractEnergy.convertInternalToEU(this.getMaxEnergyStored() - this.energyStored_internal));
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection from, double amount_EU, double voltage) {
        int leftover_internal = 0;
        this.energyStored_internal += TileEntityAbstractEnergy.convertEUtoInternal(amount_EU);
        if (this.energyStored_internal > this.getMaxEnergyStored()) {
            leftover_internal = this.energyStored_internal - this.getMaxEnergyStored();
            this.energyStored_internal = this.getMaxEnergyStored();
        }
        return TileEntityAbstractEnergy.convertInternalToEU(leftover_internal);
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection from) {
        return this.canInputEnergy(from);
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        return TileEntityAbstractEnergy.convertInternalToEU(this.getPotentialEnergyOutput());
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount_EU) {
        this.energyOutputDone(TileEntityAbstractEnergy.convertEUtoInternal(amount_EU));
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection to) {
        return this.canOutputEnergy(to);
    }

    @Optional.Method(modid="IC2")
    private void IC2_addToEnergyNet() {
        if (!this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    @Optional.Method(modid="IC2")
    private void IC2_removeFromEnergyNet() {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return this.IC2_sinkTier;
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return this.IC2_sourceTier;
    }

    @Optional.Method(modid="CoFHCore")
    public int receiveEnergy(ForgeDirection from, int maxReceive_RF, boolean simulate) {
        if (!this.canInputEnergy(from)) {
            return 0;
        }
        int maxStored_RF = this.getMaxEnergyStored(from);
        if (maxStored_RF == 0) {
            return 0;
        }
        int energyStored_RF = this.getEnergyStored(from);
        int toAdd_RF = Math.min(maxReceive_RF, maxStored_RF - energyStored_RF);
        if (!simulate) {
            this.energyStored_internal = Math.min(this.getMaxEnergyStored(), this.energyStored_internal + TileEntityAbstractEnergy.convertRFtoInternal(toAdd_RF));
        }
        return toAdd_RF;
    }

    @Optional.Method(modid="CoFHCore")
    public int extractEnergy(ForgeDirection from, int maxExtract_RF, boolean simulate) {
        if (!this.canOutputEnergy(from)) {
            return 0;
        }
        int potentialEnergyOutput_internal = this.getPotentialEnergyOutput();
        int energyExtracted_internal = Math.min(TileEntityAbstractEnergy.convertRFtoInternal(maxExtract_RF), potentialEnergyOutput_internal);
        if (!simulate) {
            this.energyOutputDone(energyExtracted_internal);
        }
        return TileEntityAbstractEnergy.convertInternalToRF(energyExtracted_internal);
    }

    @Optional.Method(modid="CoFHCore")
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.getMaxEnergyStored() != 0 && (this.canInputEnergy(from) || this.canOutputEnergy(from));
    }

    @Optional.Method(modid="CoFHCore")
    public int getEnergyStored(ForgeDirection from) {
        if (this.canConnectEnergy(from)) {
            return TileEntityAbstractEnergy.convertInternalToRF(this.getEnergyStored());
        }
        return 0;
    }

    @Optional.Method(modid="CoFHCore")
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.canConnectEnergy(from) ? TileEntityAbstractEnergy.convertInternalToRF(this.getMaxEnergyStored()) : 0;
    }

    @Optional.Method(modid="CoFHCore")
    private void outputEnergy(ForgeDirection from, IEnergyHandler ieh) {
        int energyToOutput_RF;
        if (ieh == null || this.field_145850_b.func_147438_o(this.field_145851_c + from.offsetX, this.field_145848_d + from.offsetY, this.field_145849_e + from.offsetZ) == null) {
            return;
        }
        int potentialEnergyOutput_internal = this.getPotentialEnergyOutput();
        if (potentialEnergyOutput_internal > 0 && (energyToOutput_RF = ieh.receiveEnergy(from.getOpposite(), TileEntityAbstractEnergy.convertInternalToRF(potentialEnergyOutput_internal), true)) > 0) {
            int energyOutputed_RF = ieh.receiveEnergy(from.getOpposite(), energyToOutput_RF, false);
            this.energyOutputDone(TileEntityAbstractEnergy.convertRFtoInternal(energyOutputed_RF));
        }
    }

    @Optional.Method(modid="CoFHCore")
    private void outputEnergy() {
        for (ForgeDirection from : ForgeDirection.VALID_DIRECTIONS) {
            if (this.cofhEnergyHandlers[from.ordinal()] == null) continue;
            this.outputEnergy(from, (IEnergyHandler)this.cofhEnergyHandlers[from.ordinal()]);
        }
    }

    @Optional.Method(modid="CoFHCore")
    private void RF_initialiseAPI() {
        this.cofhEnergyHandlers = new IEnergyHandler[ForgeDirection.VALID_DIRECTIONS.length];
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energyStored_internal = tag.func_74762_e("energy");
        if (this.energyStored_internal > this.getMaxEnergyStored()) {
            this.energyStored_internal = this.getMaxEnergyStored();
        }
        if (tag.func_74764_b("upgrades")) {
            NBTTagCompound upgradeTag = tag.func_74775_l("upgrades");
            for (UpgradeType type : UpgradeType.values()) {
                if (!upgradeTag.func_74764_b(type.toString()) || upgradeTag.func_74762_e(type.toString()) == 0) continue;
                this.upgrades.put(type, upgradeTag.func_74762_e(type.toString()));
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.energyStored_internal < 0) {
            this.energyStored_internal = 0;
        }
        tag.func_74768_a("energy", this.energyStored_internal);
        if (this.upgrades.size() > 0) {
            NBTTagCompound upgradeTag = new NBTTagCompound();
            for (UpgradeType type : UpgradeType.values()) {
                if (!this.upgrades.containsKey((Object)type)) continue;
                upgradeTag.func_74768_a(type.toString(), this.upgrades.get((Object)type).intValue());
            }
            tag.func_74782_a("upgrades", (NBTBase)upgradeTag);
        }
    }

    @Override
    public void updatedNeighbours() {
        super.updatedNeighbours();
        if (WarpDriveConfig.isThermalExpansionLoaded) {
            this.scanForEnergyHandlers();
        }
    }

    @Optional.Method(modid="CoFHCore")
    private void scanForEnergyHandlers() {
        for (ForgeDirection from : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyHandler ieh;
            TileEntity te;
            boolean iehFound = false;
            if (this.canConnectEnergy(from) && (te = this.field_145850_b.func_147438_o(this.field_145851_c + from.offsetX, this.field_145848_d + from.offsetY, this.field_145849_e + from.offsetZ)) != null && te instanceof IEnergyHandler && (ieh = (IEnergyHandler)te).canConnectEnergy(from.getOpposite())) {
                iehFound = true;
                this.cofhEnergyHandlers[from.ordinal()] = ieh;
            }
            if (iehFound) continue;
            this.cofhEnergyHandlers[from.ordinal()] = null;
        }
    }
}

