/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import com.google.common.collect.ImmutableSet;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractEnergy;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.ForgeChunkManager;

public abstract class TileEntityAbstractChunkLoading
extends TileEntityAbstractEnergy {
    private ArrayList<ForgeChunkManager.Ticket> ticketList = new ArrayList();
    protected ChunkCoordIntPair minChunk = null;
    protected ChunkCoordIntPair maxChunk = null;
    protected boolean areChunksLoaded = false;

    public abstract boolean shouldChunkLoad();

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.shouldChunkLoad() != this.areChunksLoaded) {
            this.refreshLoading();
        }
        if (this.shouldChunkLoad()) {
            this.handleLoadedTick();
        }
    }

    public void handleLoadedTick() {
    }

    public synchronized void refreshLoading(boolean force) {
        boolean loadRequested = this.shouldChunkLoad();
        if (this.ticketList.size() != 0) {
            if (loadRequested && (!this.areChunksLoaded || force)) {
                int ticketSize = this.ticketList.get(0).getMaxChunkListDepth();
                ArrayList<ChunkCoordIntPair> chunkList = this.getChunksToLoad();
                int numTicketsRequired = (int)Math.ceil((double)chunkList.size() / (double)ticketSize);
                if (this.ticketList.size() != numTicketsRequired) {
                    for (int i = this.ticketList.size(); i < numTicketsRequired; ++i) {
                        WarpDrive.instance.getTicket(this);
                    }
                }
                int tickNum = 0;
                int chunkInTicket = 0;
                ForgeChunkManager.Ticket t = this.ticketList.get(0);
                for (ChunkCoordIntPair chunk : chunkList) {
                    if (chunkInTicket >= ticketSize) {
                        chunkInTicket = 0;
                        t = this.ticketList.get(++tickNum);
                    }
                    WarpDrive.logger.info("Attempting to force chunk" + chunk);
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)t, (ChunkCoordIntPair)chunk);
                    ++chunkInTicket;
                }
                this.areChunksLoaded = true;
            } else if (!loadRequested) {
                for (ForgeChunkManager.Ticket ticket : this.ticketList) {
                    ImmutableSet chunks = ticket.getChunkList();
                    for (ChunkCoordIntPair chunk : chunks) {
                        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
                    }
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                }
                this.ticketList.clear();
                this.areChunksLoaded = false;
            }
        } else if (loadRequested) {
            WarpDrive.instance.registerChunkLoadTE(this);
        }
    }

    public void refreshLoading() {
        this.refreshLoading(false);
    }

    public void giveTicket(ForgeChunkManager.Ticket t) {
        NBTTagCompound nbt = t.getModData();
        nbt.func_74768_a("ticketWorldObj", this.field_145850_b.field_73011_w.field_76574_g);
        nbt.func_74768_a("ticketX", this.field_145851_c);
        nbt.func_74768_a("ticketY", this.field_145848_d);
        nbt.func_74768_a("ticketZ", this.field_145849_e);
        this.ticketList.add(t);
    }

    private static int dX(int dir) {
        if (dir == 1) {
            return 1;
        }
        if (dir == 3) {
            return -1;
        }
        return 0;
    }

    private static int dZ(int dir) {
        if (dir == 0) {
            return 1;
        }
        if (dir == 2) {
            return -1;
        }
        return 0;
    }

    public ArrayList<ChunkCoordIntPair> getChunksFromCentre(ChunkCoordIntPair chunkA, ChunkCoordIntPair chunkB) {
        if (!this.shouldChunkLoad()) {
            return null;
        }
        int minX = Math.min(chunkA.field_77276_a, chunkB.field_77276_a);
        int maxX = Math.max(chunkA.field_77276_a, chunkB.field_77276_a);
        int minZ = Math.min(chunkA.field_77275_b, chunkB.field_77275_b);
        int maxZ = Math.max(chunkA.field_77275_b, chunkB.field_77275_b);
        WarpDrive.logger.info("ChunkLoading from " + minX + "," + minZ + " to " + maxX + "," + maxZ);
        int deltaX = maxX - minX + 1;
        int deltaZ = maxZ - minZ + 1;
        maxX = minX + deltaX - 1;
        maxZ = minZ + deltaZ - 1;
        WarpDrive.logger.info("Allocating " + deltaX + " x " + deltaZ + " blocks from " + minX + "," + minZ + " to " + maxX + "," + maxZ);
        int maxEnts = deltaX * deltaZ;
        ArrayList<ChunkCoordIntPair> chunkList = new ArrayList<ChunkCoordIntPair>(maxEnts);
        int dir = 1;
        int x = minX;
        int z = maxZ;
        for (int i = 0; i < maxEnts; ++i) {
            chunkList.add(new ChunkCoordIntPair(x, z));
            int dX = TileEntityAbstractChunkLoading.dX(dir);
            int dZ = TileEntityAbstractChunkLoading.dZ(dir);
            if (x + dX > maxX || x + dX < minX || z + dZ > maxZ || z + dZ < minZ) {
                if (++dir >= 4) {
                    dir = 0;
                }
                dX = TileEntityAbstractChunkLoading.dX(dir);
                dZ = TileEntityAbstractChunkLoading.dZ(dir);
                if (dX == 1) {
                    ++minX;
                }
                if (dX == -1) {
                    --maxX;
                }
                if (dZ == 1) {
                    ++minZ;
                }
                if (dZ == -1) {
                    --maxZ;
                }
            }
            x += dX;
            z += dZ;
        }
        return chunkList;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.minChunk == null) {
            this.minChunk = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76632_l();
        }
        if (this.maxChunk == null) {
            this.maxChunk = this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76632_l();
        }
        tag.func_74768_a("minChunkX", this.minChunk.field_77276_a);
        tag.func_74768_a("minChunkZ", this.minChunk.field_77275_b);
        tag.func_74768_a("maxChunkX", this.maxChunk.field_77276_a);
        tag.func_74768_a("maxChunkZ", this.maxChunk.field_77275_b);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("minChunkX")) {
            int mx = tag.func_74762_e("minChunkX");
            int mz = tag.func_74762_e("minChunkZ");
            this.minChunk = new ChunkCoordIntPair(mx, mz);
            mx = tag.func_74762_e("maxChunkX");
            mz = tag.func_74762_e("maxChunkZ");
            this.maxChunk = new ChunkCoordIntPair(mx, mz);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (ForgeChunkManager.Ticket t : this.ticketList) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)t);
        }
    }

    public ArrayList<ChunkCoordIntPair> getChunksToLoad() {
        if (this.minChunk == null || this.maxChunk == null) {
            ArrayList<ChunkCoordIntPair> chunkList = new ArrayList<ChunkCoordIntPair>(1);
            chunkList.add(this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76632_l());
            return chunkList;
        }
        return this.getChunksFromCentre(this.minChunk, this.maxChunk);
    }
}

