/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockUpdateDetector;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityAbstractBase
extends TileEntity
implements IBlockUpdateDetector {
    public static final ForgeDirection[] UP_DIRECTIONS = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};

    @Override
    public void updatedNeighbours() {
    }

    protected boolean isOnEarth() {
        return this.field_145850_b.field_73011_w.field_76574_g == 0;
    }

    protected void updateMetadata(int metadata) {
        if (this.func_145832_p() != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 2);
        }
    }

    public static ItemStack copyWithSize(ItemStack itemStack, int newSize) {
        ItemStack ret = itemStack.func_77946_l();
        ret.field_77994_a = newSize;
        return ret;
    }

    protected IInventory getFirstConnectedInventory() {
        TileEntity result = null;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            result = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
            if (result == null || !(result instanceof IInventory)) continue;
            return (IInventory)result;
        }
        return null;
    }

    protected boolean addToConnectedInventory(ItemStack itemStack) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(1);
        stacks.add(itemStack);
        return this.addToConnectedInventory(stacks);
    }

    protected boolean addToConnectedInventory(List<ItemStack> stacks) {
        boolean overflow = false;
        if (stacks != null) {
            int qtyLeft = 0;
            for (ItemStack stack : stacks) {
                qtyLeft = this.addToInventory(this.getFirstConnectedInventory(), stack);
                if (qtyLeft <= 0) continue;
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.info(this + " Overflow detected");
                }
                overflow = true;
                while (qtyLeft > 0) {
                    int transfer = Math.min(qtyLeft, stack.func_77976_d());
                    ItemStack dropItemStack = TileEntityAbstractBase.copyWithSize(stack, transfer);
                    EntityItem itemEnt = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5, dropItemStack);
                    this.field_145850_b.func_72838_d((Entity)itemEnt);
                    qtyLeft -= transfer;
                }
            }
        }
        return overflow;
    }

    private int addToInventory(IInventory inventory, ItemStack itemStackSource) {
        if (itemStackSource == null) {
            return 0;
        }
        int qtyLeft = itemStackSource.field_77994_a;
        if (inventory != null) {
            int transfer;
            ItemStack itemStack;
            int i;
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!inventory.func_94041_b(i, itemStackSource) || (itemStack = inventory.func_70301_a(i)) == null || !itemStack.func_77969_a(itemStackSource)) continue;
                transfer = Math.min(qtyLeft, itemStack.func_77976_d() - itemStack.field_77994_a);
                itemStack.field_77994_a += transfer;
                if ((qtyLeft -= transfer) > 0) continue;
                return 0;
            }
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!inventory.func_94041_b(i, itemStackSource) || (itemStack = inventory.func_70301_a(i)) != null) continue;
                transfer = Math.min(qtyLeft, itemStackSource.func_77976_d());
                ItemStack dest = TileEntityAbstractBase.copyWithSize(itemStackSource, transfer);
                inventory.func_70299_a(i, dest);
                if ((qtyLeft -= transfer) > 0) continue;
                return 0;
            }
        }
        return qtyLeft;
    }

    public static Set<VectorI> getConnectedBlocks(World world, VectorI start, ForgeDirection[] directions, HashSet<Block> whitelist, int maxRange, VectorI ... ignore) {
        return TileEntityAbstractBase.getConnectedBlocks(world, Arrays.asList(start), directions, whitelist, maxRange, ignore);
    }

    public static Set<VectorI> getConnectedBlocks(World world, Collection<VectorI> start, ForgeDirection[] directions, HashSet<Block> whitelist, int maxRange, VectorI ... ignore) {
        HashSet<VectorI> toIgnore = new HashSet<VectorI>();
        if (ignore != null) {
            toIgnore.addAll(Arrays.asList(ignore));
        }
        HashSet<VectorI> toIterate = new HashSet<VectorI>();
        toIterate.addAll(start);
        HashSet<VectorI> toIterateNext = null;
        HashSet<VectorI> iterated = new HashSet<VectorI>();
        for (int range = 0; !toIterate.isEmpty() && range < maxRange; ++range) {
            toIterateNext = new HashSet<VectorI>();
            for (VectorI current : toIterate) {
                if (whitelist.contains(current.getBlock_noChunkLoading((IBlockAccess)world))) {
                    iterated.add(current);
                }
                for (ForgeDirection direction : directions) {
                    VectorI next = current.clone(direction);
                    if (iterated.contains(next) || toIgnore.contains(next) || toIterate.contains(next) || toIterateNext.contains(next) || !whitelist.contains(next.getBlock_noChunkLoading((IBlockAccess)world))) continue;
                    toIterateNext.add(next);
                }
            }
            toIterate = toIterateNext;
        }
        return iterated;
    }

    protected static int toInt(double d) {
        return (int)Math.round(d);
    }

    protected static int toInt(Object o) {
        return TileEntityAbstractBase.toInt(TileEntityAbstractBase.toDouble(o));
    }

    protected static double toDouble(Object o) {
        return Double.parseDouble(o.toString());
    }

    protected static float toFloat(Object o) {
        return Float.parseFloat(o.toString());
    }

    protected static boolean toBool(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return o.toString() == "true" || o.toString() == "1.0" || o.toString() == "1" || o.toString() == "y" || o.toString() == "yes";
    }

    protected static int clamp(int min, int max, int value) {
        return Math.min(max, Math.max(value, min));
    }

    protected static double clamp(double min, double max, double value) {
        return Math.min(max, Math.max(value, min));
    }
}

