/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Stack;

public class LocalProfiler {
    private static Stack<StackElement> stack = new Stack();

    public static void start(String name) {
        if (WarpDriveConfig.LOGGING_PROFILING) {
            StackElement stackElement = new StackElement();
            stackElement.start = System.nanoTime();
            stackElement.internal = 0L;
            stackElement.name = name;
            stack.push(stackElement);
        }
    }

    public static void stop() {
        if (stack.isEmpty()) {
            return;
        }
        StackElement stackElement = stack.pop();
        long end = System.nanoTime();
        long dt = end - stackElement.start;
        if (!stack.isEmpty()) {
            StackElement nextStackElement = stack.peek();
            nextStackElement.internal += dt;
        }
        long self = (dt - stackElement.internal) / 1000L;
        long total = dt / 1000L;
        WarpDrive.logger.info("Profiling " + stackElement.name + ": " + (float)self / 1000.0f + " ms" + (total == self ? "" : ", total: " + (float)total / 1000.0f + " ms"));
    }

    private static class StackElement {
        public long start;
        public long internal;
        public String name;

        private StackElement() {
        }
    }
}

