/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive;

import am2.api.power.IPowerNode;
import am2.power.PowerNodeRegistry;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.MovingEntity;
import cr0s.warpdrive.data.Planet;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.world.SpaceTeleporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

public class EntityJump
extends Entity {
    private int moveX;
    private int moveY;
    private int moveZ;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private int dx;
    private int dz;
    private int distance;
    private int direction;
    public int shipLength;
    public int maxX;
    public int maxZ;
    public int maxY;
    public int minX;
    public int minZ;
    public int minY;
    private boolean isHyperspaceJump;
    private World targetWorld;
    private ForgeChunkManager.Ticket sourceWorldTicket;
    private ForgeChunkManager.Ticket targetWorldTicket;
    private boolean collisionDetected = false;
    private ArrayList<Vector3> collisionAtSource;
    private ArrayList<Vector3> collisionAtTarget;
    private float collisionStrength = 0.0f;
    public boolean on = false;
    private JumpBlock[] ship;
    private TileEntityShipCore shipCore;
    private static final int STATE_IDLE = 0;
    private static final int STATE_JUMPING = 1;
    private static final int STATE_REMOVING = 2;
    private int state = 0;
    private int currentIndexInShip = 0;
    private List<MovingEntity> entitiesOnShip;
    private boolean betweenWorlds;
    private int destX;
    private int destY;
    private int destZ;
    private boolean isCoordJump;
    private long msCounter = 0L;
    private int ticks = 0;

    public EntityJump(World world) {
        super(world);
        this.targetWorld = this.field_70170_p;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Entity created (empty) in dimension " + this.field_70170_p.func_72827_u() + " - " + this.field_70170_p.func_72912_H().func_76065_j());
        }
    }

    public EntityJump(World world, int x, int y, int z, int _dx, int _dz, TileEntityShipCore _reactor, boolean _isHyperspaceJump, int _distance, int _direction, boolean _isCoordJump, int _destX, int _destY, int _destZ) {
        super(world);
        this.field_70165_t = (double)x + 0.5;
        this.field_70163_u = (double)y + 0.5;
        this.field_70161_v = (double)z + 0.5;
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dx = _dx;
        this.dz = _dz;
        this.shipCore = _reactor;
        this.isHyperspaceJump = _isHyperspaceJump;
        this.distance = _distance;
        this.direction = _direction;
        this.isCoordJump = _isCoordJump;
        this.destX = _destX;
        this.destY = _destY;
        this.destZ = _destZ;
        this.minY = 0;
        this.minZ = 0;
        this.minX = 0;
        this.maxY = 0;
        this.maxZ = 0;
        this.maxX = 0;
        this.shipLength = 0;
        this.targetWorld = null;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Entity created");
        }
    }

    public void killEntity(String reason) {
        if (!this.on) {
            return;
        }
        this.on = false;
        if (WarpDriveConfig.LOGGING_JUMP) {
            if (reason == null || reason.isEmpty()) {
                WarpDrive.logger.info((Object)((Object)this) + " Killing jump entity...");
            } else {
                WarpDrive.logger.info((Object)((Object)this) + " Killing jump entity... (" + reason + ")");
            }
        }
        this.unforceChunks();
        this.field_70170_p.func_72900_e((Entity)this);
    }

    public boolean func_85032_ar() {
        return true;
    }

    public void func_70071_h_() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (!this.on) {
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info((Object)((Object)this) + " Removing from onUpdate...");
            }
            this.field_70170_p.func_72900_e((Entity)this);
            return;
        }
        if (this.minY < 0 || this.maxY > 255) {
            String msg = "Invalid Y coordinate(s), check ship dimensions...";
            this.messageToAllPlayersOnShip(msg);
            this.killEntity(msg);
            return;
        }
        ++this.ticks;
        if (this.state == 0) {
            this.prepareToJump();
            if (this.on) {
                this.state = 1;
            }
        } else if (this.state == 1) {
            if (this.currentIndexInShip < this.ship.length - 1) {
                this.moveShip();
            } else {
                this.moveEntities(false);
                this.currentIndexInShip = 0;
                this.state = 2;
            }
        } else if (this.state == 2) {
            this.removeShip();
            if (this.currentIndexInShip >= this.ship.length - 1) {
                this.finishJump();
                this.state = 0;
            }
        } else {
            String msg = "Invalid state, aborting jump...";
            this.messageToAllPlayersOnShip(msg);
            this.killEntity(msg);
            return;
        }
    }

    private boolean forceChunks(StringBuilder reason) {
        int z;
        int x;
        LocalProfiler.start("EntityJump.forceChunks");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Forcing chunks in " + this.field_70170_p.field_73011_w.func_80007_l() + " and " + this.targetWorld.field_73011_w.func_80007_l());
        }
        this.sourceWorldTicket = ForgeChunkManager.requestTicket((Object)WarpDrive.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.sourceWorldTicket == null) {
            reason.append("Chunkloading rejected in source world " + this.field_70170_p.func_72912_H().func_76065_j() + ". Aborting.");
            return false;
        }
        this.targetWorldTicket = ForgeChunkManager.requestTicket((Object)WarpDrive.instance, (World)this.targetWorld, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.targetWorldTicket == null) {
            reason.append("Chunkloading rejected in target world " + this.field_70170_p.func_72912_H().func_76065_j() + ". Aborting.");
            return false;
        }
        int x1 = this.minX >> 4;
        int x2 = this.maxX >> 4;
        int z1 = this.minZ >> 4;
        int z2 = this.maxZ >> 4;
        int chunkCount = 0;
        for (x = x1; x <= x2; ++x) {
            for (z = z1; z <= z2; ++z) {
                if (++chunkCount > this.sourceWorldTicket.getMaxChunkListDepth()) {
                    reason.append("Ship is extending over too many chunks in source world. Max is currently set to " + this.sourceWorldTicket.getMaxChunkListDepth() + " in forgeChunkLoading.cfg. Aborting.");
                    return false;
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.sourceWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
            }
        }
        x1 = this.minX + this.moveX >> 4;
        x2 = this.maxX + this.moveX >> 4;
        z1 = this.minZ + this.moveZ >> 4;
        z2 = this.maxZ + this.moveZ >> 4;
        chunkCount = 0;
        for (x = x1; x <= x2; ++x) {
            for (z = z1; z <= z2; ++z) {
                if (++chunkCount > this.targetWorldTicket.getMaxChunkListDepth()) {
                    reason.append("Ship is extending over too many chunks in target world. Max is currently set to " + this.targetWorldTicket.getMaxChunkListDepth() + " in forgeChunkLoading.cfg. Aborting.");
                    return false;
                }
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.targetWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
            }
        }
        LocalProfiler.stop();
        return true;
    }

    private void unforceChunks() {
        int z;
        int x;
        int z2;
        int z1;
        int x2;
        int x1;
        LocalProfiler.start("EntityJump.unforceChunks");
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Unforcing chunks");
        }
        if (this.sourceWorldTicket != null) {
            x1 = this.minX >> 4;
            x2 = this.maxX >> 4;
            z1 = this.minZ >> 4;
            z2 = this.maxZ >> 4;
            for (x = x1; x <= x2; ++x) {
                for (z = z1; z <= z2; ++z) {
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.sourceWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.sourceWorldTicket);
            this.sourceWorldTicket = null;
        }
        if (this.targetWorldTicket != null) {
            x1 = this.minX + this.moveX >> 4;
            x2 = this.maxX + this.moveX >> 4;
            z1 = this.minZ + this.moveZ >> 4;
            z2 = this.maxZ + this.moveZ >> 4;
            for (x = x1; x <= x2; ++x) {
                for (z = z1; z <= z2; ++z) {
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.targetWorldTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.targetWorldTicket);
            this.targetWorldTicket = null;
        }
        LocalProfiler.stop();
    }

    private void messageToAllPlayersOnShip(String msg) {
        if (this.entitiesOnShip == null) {
            this.shipCore.messageToAllPlayersOnShip(msg);
        } else {
            WarpDrive.logger.info((Object)((Object)this) + " messageToAllPlayersOnShip: " + msg);
            for (MovingEntity me : this.entitiesOnShip) {
                if (!(me.entity instanceof EntityPlayer)) continue;
                WarpDrive.addChatMessage((ICommandSender)((EntityPlayer)me.entity), "[" + (this.shipCore != null && this.shipCore.shipName.length() > 0 ? this.shipCore.shipName : "WarpCore") + "] " + msg);
            }
        }
    }

    public static String getDirectionLabel(int direction) {
        switch (direction) {
            case -1: {
                return "UP";
            }
            case -2: {
                return "DOWN";
            }
            case 0: {
                return "FRONT";
            }
            case 180: {
                return "BACK";
            }
            case 90: {
                return "LEFT";
            }
            case 255: {
                return "RIGHT";
            }
        }
        return direction + " degrees";
    }

    private void prepareToJump() {
        String msg;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Preparing to jump...");
        }
        LocalProfiler.start("EntityJump.prepareToJump");
        StringBuilder reason = new StringBuilder();
        boolean isInSpace = this.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_SPACE_DIMENSION_ID;
        boolean isInHyperSpace = this.field_70170_p.field_73011_w.field_76574_g == WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID;
        boolean toSpace = this.direction == -1 && this.maxY + this.distance > 255 && !isInSpace && !isInHyperSpace;
        boolean fromSpace = this.direction == -2 && this.minY - this.distance < 0 && isInSpace;
        this.betweenWorlds = fromSpace || toSpace || this.isHyperspaceJump;
        this.moveZ = 0;
        this.moveY = 0;
        this.moveX = 0;
        if (!this.isHyperspaceJump && toSpace) {
            Boolean planetFound = false;
            Boolean planetValid = false;
            int closestPlanetDistance = Integer.MAX_VALUE;
            Planet closestPlanet = null;
            for (int iPlane = 0; !planetValid.booleanValue() && iPlane < WarpDriveConfig.PLANETS.length; ++iPlane) {
                Planet planet = WarpDriveConfig.PLANETS[iPlane];
                if (this.field_70170_p.field_73011_w.field_76574_g != planet.dimensionId) continue;
                planetFound = true;
                int planetDistance = planet.isValidToSpace(new VectorI(this));
                if (planetDistance == 0) {
                    planetValid = true;
                    this.moveX = planet.spaceCenterX - planet.dimensionCenterX;
                    this.moveZ = planet.spaceCenterZ - planet.dimensionCenterZ;
                    this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(WarpDriveConfig.G_SPACE_DIMENSION_ID);
                    if (this.targetWorld != null) continue;
                    LocalProfiler.stop();
                    String msg2 = "Unable to load Space dimension " + WarpDriveConfig.G_SPACE_DIMENSION_ID + ", aborting jump.";
                    this.messageToAllPlayersOnShip(msg2);
                    this.killEntity(msg2);
                    return;
                }
                if (closestPlanetDistance <= planetDistance) continue;
                closestPlanetDistance = planetDistance;
                closestPlanet = planet;
            }
            if (!planetFound.booleanValue()) {
                LocalProfiler.stop();
                String msg3 = "Unable to reach space!\nThere's no valid transition plane for current dimension " + this.field_70170_p.field_73011_w.func_80007_l() + " (" + this.field_70170_p.field_73011_w.field_76574_g + ")";
                this.messageToAllPlayersOnShip(msg3);
                this.killEntity(msg3);
                return;
            }
            if (!planetValid.booleanValue()) {
                LocalProfiler.stop();
                assert (closestPlanet != null);
                String msg4 = "Ship is outside border, unable to reach space!\nClosest transition plane is ~" + closestPlanetDistance + " m away (" + (closestPlanet.dimensionCenterX - closestPlanet.borderSizeX) + ", 250," + (closestPlanet.dimensionCenterZ - closestPlanet.borderSizeZ) + ") to (" + (closestPlanet.dimensionCenterX + closestPlanet.borderSizeX) + ", 255," + (closestPlanet.dimensionCenterZ + closestPlanet.borderSizeZ) + ")";
                this.messageToAllPlayersOnShip(msg4);
                this.killEntity(msg4);
                return;
            }
        } else if (!this.isHyperspaceJump && fromSpace) {
            Boolean planeFound = false;
            int closestPlaneDistance = Integer.MAX_VALUE;
            Planet closestTransitionPlane = null;
            for (int iPlanet = 0; !planeFound.booleanValue() && iPlanet < WarpDriveConfig.PLANETS.length; ++iPlanet) {
                Planet planet = WarpDriveConfig.PLANETS[iPlanet];
                int planeDistance = planet.isValidFromSpace(new VectorI(this));
                if (planeDistance == 0) {
                    planeFound = true;
                    this.moveX = planet.dimensionCenterX - planet.spaceCenterX;
                    this.moveZ = planet.dimensionCenterZ - planet.spaceCenterZ;
                    this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(planet.dimensionId);
                    if (this.targetWorld != null) continue;
                    LocalProfiler.stop();
                    String msg5 = "Undefined dimension " + planet.dimensionId + ", aborting jump. Check your server configuration!";
                    this.messageToAllPlayersOnShip(msg5);
                    this.killEntity(msg5);
                    return;
                }
                if (closestPlaneDistance <= planeDistance) continue;
                closestPlaneDistance = planeDistance;
                closestTransitionPlane = planet;
            }
            if (!planeFound.booleanValue()) {
                LocalProfiler.stop();
                String msg6 = "";
                msg6 = closestTransitionPlane == null ? "No planet defined, unable to enter atmosphere!" : "No planet in range, unable to enter atmosphere!\nClosest transition plane is " + closestPlaneDistance + " m away (" + (closestTransitionPlane.spaceCenterX - closestTransitionPlane.borderSizeX) + ", 250," + (closestTransitionPlane.spaceCenterZ - closestTransitionPlane.borderSizeZ) + ") to (" + (closestTransitionPlane.spaceCenterX + closestTransitionPlane.borderSizeX) + ", 255," + (closestTransitionPlane.spaceCenterZ + closestTransitionPlane.borderSizeZ) + ")";
                this.messageToAllPlayersOnShip(msg6);
                this.killEntity(msg6);
                return;
            }
        } else if (this.isHyperspaceJump && isInHyperSpace) {
            this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(WarpDriveConfig.G_SPACE_DIMENSION_ID);
            if (this.targetWorld == null) {
                LocalProfiler.stop();
                String msg7 = "Unable to load Space dimension " + WarpDriveConfig.G_SPACE_DIMENSION_ID + ", aborting jump.";
                this.messageToAllPlayersOnShip(msg7);
                this.killEntity(msg7);
                return;
            }
        } else if (this.isHyperspaceJump && isInSpace) {
            this.targetWorld = MinecraftServer.func_71276_C().func_71218_a(WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID);
            if (this.targetWorld == null) {
                LocalProfiler.stop();
                String msg8 = "Unable to load Hyperspace dimension " + WarpDriveConfig.G_HYPERSPACE_DIMENSION_ID + ", aborting jump.";
                this.messageToAllPlayersOnShip(msg8);
                this.killEntity(msg8);
                return;
            }
        } else {
            this.targetWorld = this.field_70170_p;
        }
        if (this.isCoordJump) {
            this.moveX = this.destX - this.xCoord;
            this.moveZ = this.destZ - this.zCoord;
            this.moveY = this.destY - this.yCoord;
            this.distance = 0;
        } else if (this.isHyperspaceJump) {
            this.distance = 0;
            if (!isInSpace && !isInHyperSpace) {
                msg = "Unable to reach hyperspace from a planet";
                this.killEntity(msg);
                this.messageToAllPlayersOnShip(msg);
                LocalProfiler.stop();
                return;
            }
        } else if (toSpace) {
            this.moveY = 0;
        } else if (fromSpace) {
            this.moveY = 245 - this.maxY;
        } else {
            if (this.distance < 256) {
                this.distance = this.getPossibleJumpDistance();
            }
            int[] movementVector = this.getVector(this.direction);
            this.moveX = movementVector[0] * this.distance;
            this.moveY = movementVector[1] * this.distance;
            this.moveZ = movementVector[2] * this.distance;
            if (this.maxY + this.moveY > 255) {
                this.moveY = 255 - this.maxY;
            }
            if (this.minY + this.moveY < 5) {
                this.moveY = 5 - this.minY;
            }
        }
        if (this.betweenWorlds && WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " From world " + this.field_70170_p.field_73011_w.func_80007_l() + " to " + this.targetWorld.field_73011_w.func_80007_l());
        }
        if (!this.betweenWorlds && Math.abs(this.moveX) <= this.maxX - this.minX + 1 && Math.abs(this.moveY) <= this.maxY - this.minY + 1 && Math.abs(this.moveZ) <= this.maxZ - this.minZ + 1) {
            this.doCollisionDamage(false);
            msg = "Not enough space for jump!";
            this.killEntity(msg);
            this.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        if (!this.forceChunks(reason)) {
            msg = reason.toString();
            this.killEntity(msg);
            this.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        msg = this.saveEntities();
        if (msg != null) {
            this.killEntity(msg);
            this.messageToAllPlayersOnShip(msg);
            LocalProfiler.stop();
            return;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Saved " + this.entitiesOnShip.size() + " entities from ship");
        }
        if (this.isHyperspaceJump && isInSpace) {
            this.messageToAllPlayersOnShip("Entering HYPERSPACE...");
        } else if (this.isHyperspaceJump && isInHyperSpace) {
            this.messageToAllPlayersOnShip("Leaving HYPERSPACE..");
        } else if (this.isCoordJump) {
            this.messageToAllPlayersOnShip("Jumping to coordinates (" + this.destX + "; " + this.yCoord + "; " + this.destZ + ")!");
        } else {
            this.messageToAllPlayersOnShip("Jumping " + EntityJump.getDirectionLabel(this.direction) + " by " + this.distance + " blocks");
        }
        int shipVolume = this.getRealShipVolume_checkBedrock(reason);
        if (shipVolume == -1) {
            String msg9 = reason.toString();
            this.killEntity(msg9);
            this.messageToAllPlayersOnShip(msg9);
            LocalProfiler.stop();
            return;
        }
        this.saveShip(shipVolume);
        this.currentIndexInShip = 0;
        this.msCounter = System.currentTimeMillis();
        LocalProfiler.stop();
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info("Removing TE duplicates: tileEntities in target world before jump: " + this.targetWorld.field_147482_g.size());
        }
    }

    private int getRealShipVolume_checkBedrock(StringBuilder reason) {
        int x;
        LocalProfiler.start("EntityJump.getRealShipVolume_checkBedrock");
        int shipVolume = 0;
        for (x = this.minX; x <= this.maxX; ++x) {
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                for (int y = this.minY; y <= this.maxY; ++y) {
                    Block block = this.field_70170_p.func_147439_a(x, y, z);
                    if (block == Blocks.field_150350_a || WarpDriveConfig.BLOCKS_LEFTBEHIND.contains(block)) continue;
                    ++shipVolume;
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        WarpDrive.logger.info("Block(" + x + ", " + y + ", " + z + ") is " + block.func_149739_a() + "@" + this.field_70170_p.func_72805_g(x, y, z));
                    }
                    if (!WarpDriveConfig.BLOCKS_ANCHOR.contains(block)) continue;
                    reason.append(block.func_149739_a() + " detected onboard at " + x + ", " + y + ", " + z + ". Aborting.");
                    LocalProfiler.stop();
                    return -1;
                }
            }
        }
        for (x = this.minX - 1; x <= this.maxX + 1; ++x) {
            boolean xBorder = x == this.minX - 1 || x == this.maxX + 1;
            for (int z = this.minZ - 1; z <= this.maxZ + 1; ++z) {
                boolean zBorder = z == this.minZ - 1 || z == this.maxZ + 1;
                for (int y = this.minY - 1; y <= this.maxY + 1; ++y) {
                    TileEntity tileEntity;
                    boolean yBorder;
                    boolean bl = yBorder = y == this.minY - 1 || y == this.maxY + 1;
                    if (y < 0 || y > 255 || !xBorder && !yBorder && !zBorder) continue;
                    Block block = this.field_70170_p.func_147439_a(x, y, z);
                    if (this.field_70170_p.func_147437_c(x, y, z) || WarpDriveConfig.BLOCKS_LEFTBEHIND.contains(block) || WarpDriveConfig.BLOCKS_ANCHOR.contains(block) || (tileEntity = this.field_70170_p.func_147438_o(x, y, z)) == null) continue;
                    reason.append("Ship snagged by " + block.func_149732_F() + " at " + x + ", " + y + ", " + z + ". Damage report pending...");
                    this.field_70170_p.func_72876_a((Entity)null, (double)x, (double)y, (double)z, Math.min(120.0f, 4.0f * (float)(shipVolume / 50)), false);
                    LocalProfiler.stop();
                    return -1;
                }
            }
        }
        LocalProfiler.stop();
        return shipVolume;
    }

    private void saveShip(int shipVolume) {
        LocalProfiler.start("EntityJump.saveShip");
        try {
            JumpBlock[][] placeTimeJumpBlocks = new JumpBlock[][]{new JumpBlock[shipVolume], new JumpBlock[shipVolume], new JumpBlock[shipVolume], new JumpBlock[shipVolume], new JumpBlock[shipVolume]};
            int[] placeTimeIndexes = new int[]{0, 0, 0, 0, 0};
            int xc1 = this.minX >> 4;
            int xc2 = this.maxX >> 4;
            int zc1 = this.minZ >> 4;
            int zc2 = this.maxZ >> 4;
            for (int xc = xc1; xc <= xc2; ++xc) {
                int x1 = Math.max(this.minX, xc << 4);
                int x2 = Math.min(this.maxX, (xc << 4) + 15);
                for (int zc = zc1; zc <= zc2; ++zc) {
                    int z1 = Math.max(this.minZ, zc << 4);
                    int z2 = Math.min(this.maxZ, (zc << 4) + 15);
                    for (int y = this.minY; y <= this.maxY; ++y) {
                        for (int x = x1; x <= x2; ++x) {
                            for (int z = z1; z <= z2; ++z) {
                                Integer placeTime;
                                Block block = this.field_70170_p.func_147439_a(x, y, z);
                                if (block == Blocks.field_150350_a || WarpDriveConfig.BLOCKS_LEFTBEHIND.contains(block)) continue;
                                int blockMeta = this.field_70170_p.func_72805_g(x, y, z);
                                TileEntity tileEntity = this.field_70170_p.func_147438_o(x, y, z);
                                JumpBlock jumpBlock = new JumpBlock(block, blockMeta, tileEntity, x, y, z);
                                if (WarpDriveConfig.isArsMagica2Loaded) {
                                    this.arsMagica2_energySave(tileEntity, jumpBlock);
                                }
                                if (WarpDriveConfig.isImmersiveEngineeringLoaded) {
                                    this.immersiveEngineering_energySave(tileEntity, jumpBlock);
                                }
                                if ((placeTime = WarpDriveConfig.BLOCKS_PLACE.get(block)) == null) {
                                    placeTime = tileEntity == null ? Integer.valueOf(2) : Integer.valueOf(3);
                                }
                                placeTimeJumpBlocks[placeTime.intValue()][placeTimeIndexes[placeTime.intValue()]] = jumpBlock;
                                int n = placeTime;
                                placeTimeIndexes[n] = placeTimeIndexes[n] + 1;
                            }
                        }
                    }
                }
            }
            this.ship = new JumpBlock[shipVolume];
            int indexShip = 0;
            for (int placeTime = 0; placeTime < 5; ++placeTime) {
                for (int placeTimeIndex = 0; placeTimeIndex < placeTimeIndexes[placeTime]; ++placeTimeIndex) {
                    this.ship[indexShip] = placeTimeJumpBlocks[placeTime][placeTimeIndex];
                    ++indexShip;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.killEntity("Exception during jump preparation (saveShip)!");
            LocalProfiler.stop();
            return;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Ship saved as " + this.ship.length + " blocks");
        }
        LocalProfiler.stop();
    }

    private void moveShip() {
        LocalProfiler.start("EntityJump.moveShip");
        int blocksToMove = Math.min(WarpDriveConfig.G_BLOCKS_PER_TICK, this.ship.length - this.currentIndexInShip);
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Moving ship blocks " + this.currentIndexInShip + " to " + (this.currentIndexInShip + blocksToMove - 1) + " / " + (this.ship.length - 1));
        }
        for (int index = 0; index < blocksToMove && this.currentIndexInShip < this.ship.length; ++index) {
            JumpBlock jb = this.ship[this.currentIndexInShip];
            if (jb != null) {
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info("Deploying from " + jb.x + ", " + jb.y + ", " + jb.z + " of " + jb.block + "@" + jb.blockMeta);
                }
                jb.deploy(this.targetWorld, this.moveX, this.moveY, this.moveZ);
                if (jb.nbtArsMagica2 != null) {
                    this.arsMagica2_energyRemove(jb);
                }
                if (jb.nbtImmersiveEngineering != null) {
                    this.immersiveEngineering_energyRemove(jb);
                }
                this.field_70170_p.func_147475_p(jb.x, jb.y, jb.z);
            }
            ++this.currentIndexInShip;
        }
        LocalProfiler.stop();
    }

    private void removeShip() {
        LocalProfiler.start("EntityJump.removeShip");
        int blocksToMove = Math.min(WarpDriveConfig.G_BLOCKS_PER_TICK, this.ship.length - this.currentIndexInShip);
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Removing ship blocks " + this.currentIndexInShip + " to " + (this.currentIndexInShip + blocksToMove - 1) + " / " + (this.ship.length - 1));
        }
        for (int index = 0; index < blocksToMove && this.currentIndexInShip < this.ship.length; ++index) {
            JumpBlock jb = this.ship[this.ship.length - this.currentIndexInShip - 1];
            if (jb == null) {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info((Object)((Object)this) + " Removing ship part: unexpected null found at ship[" + this.currentIndexInShip + "]");
                }
                ++this.currentIndexInShip;
                continue;
            }
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info("Removing block " + jb.block + "@" + jb.blockMeta + " at " + jb.x + ", " + jb.y + ", " + jb.z);
            }
            if (jb.blockTileEntity != null) {
                if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                    WarpDrive.logger.info("Removing tile entity at " + jb.x + ", " + jb.y + ", " + jb.z);
                }
                if (jb.nbtArsMagica2 != null) {
                    this.arsMagica2_energyPlace(jb);
                }
                if (jb.nbtImmersiveEngineering != null) {
                    this.immersiveEngineering_energyPlace(jb);
                }
                this.field_70170_p.func_147475_p(jb.x, jb.y, jb.z);
            }
            this.field_70170_p.func_147465_d(jb.x, jb.y, jb.z, Blocks.field_150350_a, 0, 2);
            JumpBlock.refreshBlockStateOnClient(this.targetWorld, jb.x + this.moveX, jb.y + this.moveY, jb.z + this.moveZ);
            ++this.currentIndexInShip;
        }
        LocalProfiler.stop();
    }

    @Optional.Method(modid="arsmagica2")
    private void arsMagica2_energySave(TileEntity tileEntity, JumpBlock jumpBlock) {
        if (tileEntity instanceof IPowerNode) {
            jumpBlock.nbtArsMagica2 = PowerNodeRegistry.For((World)this.field_70170_p).getDataCompoundForNode((IPowerNode)tileEntity);
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info("Saved ArsMagica2 energy at " + jumpBlock.x + ", " + jumpBlock.y + ", " + jumpBlock.z + " " + jumpBlock.nbtArsMagica2);
            }
        }
    }

    @Optional.Method(modid="arsmagica2")
    private void arsMagica2_energyRemove(JumpBlock jumpBlock) {
        PowerNodeRegistry.For((World)jumpBlock.blockTileEntity.func_145831_w()).removePowerNode((IPowerNode)jumpBlock.blockTileEntity);
    }

    @Optional.Method(modid="arsmagica2")
    private void arsMagica2_energyPlace(JumpBlock jumpBlock) {
        NBTTagCompound nbtTagCompound;
        NBTTagList powerPathList;
        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
            WarpDrive.logger.info("Restoring ArsMagica2 energy at " + jumpBlock.x + ", " + jumpBlock.y + ", " + jumpBlock.z + " " + jumpBlock.nbtArsMagica2);
        }
        if ((powerPathList = (nbtTagCompound = (NBTTagCompound)jumpBlock.nbtArsMagica2.func_74737_b()).func_150295_c("powerPathList", 10)) != null) {
            for (int powerPathIndex = 0; powerPathIndex < powerPathList.func_74745_c(); ++powerPathIndex) {
                NBTTagCompound powerPathEntry = (NBTTagCompound)powerPathList.func_74744_a(0);
                NBTTagList nodePaths = powerPathEntry.func_150295_c("nodePaths", 9);
                if (nodePaths != null) {
                    for (int nodePathIndex = 0; nodePathIndex < nodePaths.func_74745_c(); ++nodePathIndex) {
                        NBTTagList nodeList = (NBTTagList)nodePaths.func_74744_a(0);
                        if (nodeList == null) continue;
                        for (int nodeIndex = 0; nodeIndex < nodeList.func_74745_c(); ++nodeIndex) {
                            NBTTagCompound node = (NBTTagCompound)nodeList.func_74744_a(0);
                            node.func_74776_a("Vec3_x", node.func_74760_g("Vec3_x") + (float)this.moveX);
                            node.func_74776_a("Vec3_y", node.func_74760_g("Vec3_y") + (float)this.moveY);
                            node.func_74776_a("Vec3_z", node.func_74760_g("Vec3_z") + (float)this.moveZ);
                            nodeList.func_74742_a((NBTBase)node);
                        }
                        nodePaths.func_74742_a((NBTBase)nodeList);
                    }
                    powerPathEntry.func_74782_a("nodePaths", (NBTBase)nodePaths);
                }
                powerPathList.func_74742_a((NBTBase)powerPathEntry);
            }
            nbtTagCompound.func_74782_a("powerPathList", (NBTBase)powerPathList);
        }
        PowerNodeRegistry.For((World)this.targetWorld).setDataCompoundForNode((IPowerNode)this.targetWorld.func_147438_o(jumpBlock.x + this.moveX, jumpBlock.y + this.moveY, jumpBlock.z + this.moveZ), nbtTagCompound);
    }

    @Optional.Method(modid="ImmersiveEngineering")
    private void immersiveEngineering_energySave(TileEntity tileEntity, JumpBlock jumpBlock) {
        if (tileEntity instanceof IImmersiveConnectable) {
            ChunkCoordinates node = new ChunkCoordinates(jumpBlock.blockTileEntity.field_145851_c, jumpBlock.blockTileEntity.field_145848_d, jumpBlock.blockTileEntity.field_145849_e);
            List connections = ImmersiveNetHandler.INSTANCE.getConnections(tileEntity.func_145831_w(), node);
            if (connections != null) {
                jumpBlock.nbtImmersiveEngineering = new NBTTagList();
                for (ImmersiveNetHandler.Connection connection : connections) {
                    jumpBlock.nbtImmersiveEngineering.func_74742_a((NBTBase)connection.writeToNBT());
                }
                ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(node, this.field_70170_p);
            }
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info("Saved ImmersiveEngineering energy at " + jumpBlock.x + ", " + jumpBlock.y + ", " + jumpBlock.z + " " + jumpBlock.nbtImmersiveEngineering);
            }
        }
    }

    @Optional.Method(modid="ImmersiveEngineering")
    private void immersiveEngineering_energyRemove(JumpBlock jumpBlock) {
    }

    @Optional.Method(modid="ImmersiveEngineering")
    private void immersiveEngineering_energyPlace(JumpBlock jumpBlock) {
        if (jumpBlock.nbtImmersiveEngineering == null) {
            return;
        }
        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
            WarpDrive.logger.info("Restoring ImmersiveEngineering energy at " + jumpBlock.x + ", " + jumpBlock.y + ", " + jumpBlock.z + " " + jumpBlock.nbtImmersiveEngineering);
        }
        for (int connectionIndex = 0; connectionIndex < jumpBlock.nbtImmersiveEngineering.func_74745_c(); ++connectionIndex) {
            ImmersiveNetHandler.Connection connection = ImmersiveNetHandler.Connection.readFromNBT((NBTTagCompound)jumpBlock.nbtImmersiveEngineering.func_150305_b(connectionIndex));
            connection.start.field_71574_a += this.moveX;
            connection.start.field_71572_b += this.moveY;
            connection.start.field_71573_c += this.moveZ;
            connection.end.field_71574_a += this.moveX;
            connection.end.field_71572_b += this.moveY;
            connection.end.field_71573_c += this.moveZ;
            ImmersiveNetHandler.INSTANCE.addConnection(this.targetWorld, new ChunkCoordinates(connection.start.field_71574_a, connection.start.field_71572_b, connection.start.field_71573_c), connection);
        }
    }

    private void finishJump() {
        block5: {
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info((Object)((Object)this) + " Jump done in " + (float)(System.currentTimeMillis() - this.msCounter) / 1000.0f + " seconds and " + this.ticks + " ticks");
            }
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info("Removing TE duplicates: tileEntities in target world after jump, before cleanup: " + this.targetWorld.field_147482_g.size());
            }
            LocalProfiler.start("EntityJump.removeDuplicates()");
            try {
                this.targetWorld.field_147482_g = EntityJump.removeDuplicates(this.targetWorld.field_147482_g);
            }
            catch (Exception exception) {
                if (!WarpDriveConfig.LOGGING_JUMP) break block5;
                WarpDrive.logger.info("TE Duplicates removing exception: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        this.doCollisionDamage(true);
        LocalProfiler.stop();
        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
            WarpDrive.logger.info("Removing TE duplicates: tileEntities in target world after jump, after cleanup: " + this.targetWorld.field_147482_g.size());
        }
        this.killEntity("Jump done");
    }

    private int getPossibleJumpDistance() {
        int testDistance;
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Calculating possible jump distance...");
        }
        int blowPoints = 0;
        this.collisionDetected = false;
        CheckMovementResult result = null;
        for (testDistance = this.distance; testDistance >= 0 && (result = this.checkMovement(testDistance, false)) != null; --testDistance) {
            if (!result.isCollision) continue;
            ++blowPoints;
        }
        if (this.distance != testDistance && WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Jump distance adjusted to " + testDistance + " after " + blowPoints + " collisions");
        }
        if (blowPoints > WarpDriveConfig.SHIP_COLLISION_TOLERANCE_BLOCKS) {
            result = this.checkMovement(Math.max(1, testDistance + 1), true);
            if (result != null) {
                float massCorrection = 0.5f + (float)Math.sqrt(Math.min(1.0, Math.max(0.0, (double)(this.shipCore.shipMass - WarpDriveConfig.SHIP_VOLUME_MAX_ON_PLANET_SURFACE)) / (double)WarpDriveConfig.SHIP_VOLUME_MIN_FOR_HYPERSPACE));
                this.collisionDetected = true;
                this.collisionStrength = (4.0f + (float)blowPoints - (float)WarpDriveConfig.SHIP_COLLISION_TOLERANCE_BLOCKS) * massCorrection;
                this.collisionAtSource = result.atSource;
                this.collisionAtTarget = result.atTarget;
                WarpDrive.logger.info((Object)((Object)this) + " Reporting " + this.collisionAtTarget.size() + " collisions coordinates " + blowPoints + " blowPoints with massCorrection of " + String.format("%.2f", Float.valueOf(massCorrection)) + " => strength " + String.format("%.2f", Float.valueOf(this.collisionStrength)));
            } else {
                WarpDrive.logger.error("WarpDrive error: unable to compute collision points, ignoring...");
            }
        }
        return testDistance;
    }

    private void doCollisionDamage(boolean atTarget) {
        if (!this.collisionDetected) {
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info((Object)((Object)this) + " doCollisionDamage No collision detected...");
            }
            return;
        }
        ArrayList<Vector3> collisionPoints = atTarget ? this.collisionAtTarget : this.collisionAtSource;
        Vector3 min = collisionPoints.get(0);
        Vector3 max = collisionPoints.get(0);
        for (Vector3 v : collisionPoints) {
            if (min.x > v.x) {
                min.x = v.x;
            } else if (max.x < v.x) {
                max.x = v.x;
            }
            if (min.y > v.y) {
                min.y = v.y;
            } else if (max.y < v.y) {
                max.y = v.y;
            }
            if (min.z > v.z) {
                min.z = v.z;
                continue;
            }
            if (!(max.z < v.z)) continue;
            max.z = v.z;
        }
        double rx = Math.round(min.x + (double)this.field_70170_p.field_73012_v.nextInt(Math.max(1, (int)(max.x - min.x))));
        double ry = Math.round(min.y + (double)this.field_70170_p.field_73012_v.nextInt(Math.max(1, (int)(max.y - min.y))));
        double rz = Math.round(min.z + (double)this.field_70170_p.field_73012_v.nextInt(Math.max(1, (int)(max.z - min.z))));
        this.messageToAllPlayersOnShip("Ship collision detected around " + (int)rx + ", " + (int)ry + ", " + (int)rz + ". Damage report pending...");
        int nbExplosions = Math.min(5, collisionPoints.size());
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info("doCollisionDamage nbExplosions " + nbExplosions + "/" + collisionPoints.size());
        }
        for (int i = 0; i < nbExplosions; ++i) {
            Vector3 current;
            if (nbExplosions < collisionPoints.size()) {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info("doCollisionDamage random #" + i);
                }
                current = collisionPoints.get(this.field_70170_p.field_73012_v.nextInt(collisionPoints.size()));
            } else {
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info("doCollisionDamage get " + i);
                }
                current = collisionPoints.get(i);
            }
            float strength = Math.max(4.0f, this.collisionStrength / (float)nbExplosions - 2.0f + 2.0f * this.field_70170_p.field_73012_v.nextFloat());
            (atTarget ? this.targetWorld : this.field_70170_p).func_72885_a((Entity)null, current.x, current.y, current.z, strength, atTarget, atTarget);
            WarpDrive.logger.info("Ship collision caused explosion at " + current.x + ", " + current.y + ", " + current.z + " with strength " + strength);
        }
    }

    private String saveEntities() {
        String result = null;
        this.entitiesOnShip = new ArrayList<MovingEntity>();
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)this.minX, (double)this.minY, (double)this.minZ, (double)((double)this.maxX + 0.99), (double)((double)this.maxY + 0.99), (double)((double)this.maxZ + 0.99));
        List list = this.field_70170_p.func_72839_b(null, axisalignedbb);
        for (Entity entity : list) {
            if (entity == null || entity instanceof EntityJump) continue;
            String id = EntityList.func_75621_b((Entity)entity);
            if (WarpDriveConfig.ENTITIES_ANCHOR.contains(id)) {
                result = "Anchor entity " + id + " detected at " + Math.floor(entity.field_70165_t) + ", " + Math.floor(entity.field_70163_u) + ", " + Math.floor(entity.field_70161_v) + ", aborting jump...";
                continue;
            }
            if (WarpDriveConfig.ENTITIES_LEFTBEHIND.contains(id)) {
                if (!WarpDriveConfig.LOGGING_JUMPBLOCKS) continue;
                WarpDrive.logger.info("Leaving entity " + id + " behind: " + entity);
                continue;
            }
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS && WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info("Adding entity " + id + ": " + entity);
            }
            MovingEntity movingEntity = new MovingEntity(entity);
            this.entitiesOnShip.add(movingEntity);
        }
        return result;
    }

    private boolean moveEntities(boolean restorePositions) {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info((Object)((Object)this) + " Moving entities");
        }
        LocalProfiler.start("EntityJump.moveEntities");
        if (this.entitiesOnShip != null) {
            for (MovingEntity me : this.entitiesOnShip) {
                double newEntityZ;
                double newEntityY;
                double newEntityX;
                Entity entity = me.entity;
                if (entity == null) continue;
                double oldEntityX = me.oldX;
                double oldEntityY = me.oldY;
                double oldEntityZ = me.oldZ;
                if (restorePositions) {
                    newEntityX = oldEntityX;
                    newEntityY = oldEntityY;
                    newEntityZ = oldEntityZ;
                } else {
                    newEntityX = oldEntityX + (double)this.moveX;
                    newEntityY = oldEntityY + (double)this.moveY;
                    newEntityZ = oldEntityZ + (double)this.moveZ;
                }
                if (WarpDriveConfig.LOGGING_JUMP) {
                    WarpDrive.logger.info("Entity moving: old (" + oldEntityX + " " + oldEntityY + " " + oldEntityZ + ") -> new (" + newEntityX + " " + newEntityY + " " + newEntityZ);
                }
                if (this.betweenWorlds && !restorePositions) {
                    MinecraftServer server = MinecraftServer.func_71276_C();
                    WorldServer from = server.func_71218_a(this.field_70170_p.field_73011_w.field_76574_g);
                    WorldServer to = server.func_71218_a(this.targetWorld.field_73011_w.field_76574_g);
                    SpaceTeleporter teleporter = new SpaceTeleporter(to, 0, MathHelper.func_76128_c((double)newEntityX), MathHelper.func_76128_c((double)newEntityY), MathHelper.func_76128_c((double)newEntityZ));
                    if (entity instanceof EntityPlayerMP) {
                        EntityPlayerMP player = (EntityPlayerMP)entity;
                        server.func_71203_ab().transferPlayerToDimension(player, this.targetWorld.field_73011_w.field_76574_g, (Teleporter)teleporter);
                        player.func_71016_p();
                    } else {
                        server.func_71203_ab().transferEntityToWorld(entity, this.field_70170_p.field_73011_w.field_76574_g, from, to, (Teleporter)teleporter);
                    }
                }
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)entity;
                    ChunkCoordinates bedLocation = player.getBedLocation(player.field_70170_p.field_73011_w.field_76574_g);
                    if (bedLocation != null && this.minX <= bedLocation.field_71574_a && this.maxX >= bedLocation.field_71574_a && this.minY <= bedLocation.field_71572_b && this.maxY >= bedLocation.field_71572_b && this.minZ <= bedLocation.field_71573_c && this.maxZ >= bedLocation.field_71573_c) {
                        bedLocation.field_71574_a += this.moveX;
                        bedLocation.field_71572_b += this.moveY;
                        bedLocation.field_71573_c += this.moveZ;
                        player.func_71063_a(bedLocation, false);
                    }
                    player.func_70634_a(newEntityX, newEntityY, newEntityZ);
                    continue;
                }
                entity.func_70107_b(newEntityX, newEntityY, newEntityZ);
            }
        }
        LocalProfiler.stop();
        return true;
    }

    public int[] getVector(int i) {
        int[] v = new int[]{0, 0, 0};
        switch (i) {
            case -1: {
                v[1] = 1;
                break;
            }
            case -2: {
                v[1] = -1;
                break;
            }
            case 0: {
                v[0] = this.dx;
                v[2] = this.dz;
                break;
            }
            case 180: {
                v[0] = -this.dx;
                v[2] = -this.dz;
                break;
            }
            case 90: {
                v[0] = this.dz;
                v[2] = -this.dx;
                break;
            }
            case 270: {
                v[0] = -this.dz;
                v[2] = this.dx;
                break;
            }
            default: {
                WarpDrive.logger.error((Object)((Object)this) + "Invalid direction " + i);
            }
        }
        return v;
    }

    private CheckMovementResult checkMovement(int testDistance, boolean fullCollisionDetails) {
        CheckMovementResult result = new CheckMovementResult();
        if (this.direction == -1 && this.maxY + testDistance > 255 && !this.betweenWorlds) {
            result.add(this.xCoord, this.maxY + testDistance, this.zCoord, (double)this.xCoord + 0.5, (double)(this.maxY + testDistance) + 1.0, (double)this.zCoord + 0.5, false, "Reactor will blow due +high limit");
            return result;
        }
        if (this.direction == -2 && this.minY - testDistance <= 8 && !this.betweenWorlds) {
            result.add(this.xCoord, this.minY - testDistance, this.zCoord, (double)this.xCoord + 0.5, this.maxY - testDistance, (double)this.zCoord + 0.5, false, "Reactor will blow due -low limit");
            return result;
        }
        int[] movementVector = this.getVector(this.direction);
        int lmoveX = movementVector[0] * testDistance;
        int lmoveY = movementVector[1] * testDistance;
        int lmoveZ = movementVector[2] * testDistance;
        for (int y = this.minY; y <= this.maxY; ++y) {
            int newY = y + lmoveY;
            for (int x = this.minX; x <= this.maxX; ++x) {
                int newX = x + lmoveX;
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    int newZ = z + lmoveZ;
                    Block blockSource = this.field_70170_p.func_147439_a(x, y, z);
                    Block blockTarget = this.field_70170_p.func_147439_a(newX, newY, newZ);
                    if (WarpDriveConfig.BLOCKS_ANCHOR.contains(blockTarget)) {
                        result.add(x, y, z, (double)newX + 0.5 - (double)movementVector[0] * 1.0, (double)newY + 0.5 - (double)movementVector[1] * 1.0, (double)newZ + 0.5 - (double)movementVector[2] * 1.0, true, "Unpassable block " + blockTarget + " detected at destination (" + newX + ";" + newY + ";" + newZ + ")");
                        if (!fullCollisionDetails) {
                            return result;
                        }
                    }
                    if (blockSource == Blocks.field_150350_a || WarpDriveConfig.BLOCKS_EXPANDABLE.contains(blockSource) || blockTarget == Blocks.field_150350_a || WarpDriveConfig.BLOCKS_EXPANDABLE.contains(blockTarget)) continue;
                    result.add(x, y, z, (double)newX + 0.5 + (double)movementVector[0] * 0.1, (double)newY + 0.5 + (double)movementVector[1] * 0.1, (double)newZ + 0.5 + (double)movementVector[2] * 0.1, true, "Obstacle block #" + blockTarget + " detected at (" + newX + ", " + newY + ", " + newZ + ")");
                    if (fullCollisionDetails) continue;
                    return result;
                }
            }
        }
        if (fullCollisionDetails && result.isCollision) {
            return result;
        }
        return null;
    }

    private static ArrayList<Object> removeDuplicates(List<TileEntity> l) {
        TreeSet<TileEntity> s = new TreeSet<TileEntity>(new Comparator<TileEntity>(){

            @Override
            public int compare(TileEntity o1, TileEntity o2) {
                if (o1.field_145851_c == o2.field_145851_c && o1.field_145848_d == o2.field_145848_d && o1.field_145849_e == o2.field_145849_e) {
                    if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                        WarpDrive.logger.info("Removed duplicated TE: " + o1 + ", " + o2);
                    }
                    return 0;
                }
                return 1;
            }
        });
        s.addAll(l);
        return new ArrayList<Object>(Arrays.asList(s.toArray()));
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        WarpDrive.logger.error((Object)((Object)this) + " readEntityFromNBT()");
    }

    protected void func_70088_a() {
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.warn((Object)((Object)this) + " entityInit()");
        }
    }

    protected void func_70014_b(NBTTagCompound var1) {
        WarpDrive.logger.error((Object)((Object)this) + " writeEntityToNBT()");
    }

    public void setMinMaxes(int minXV, int maxXV, int minYV, int maxYV, int minZV, int maxZV) {
        this.minX = minXV;
        this.maxX = maxXV;
        this.minY = minYV;
        this.maxY = maxYV;
        this.minZ = minZV;
        this.maxZ = maxZV;
    }

    public String toString() {
        return String.format("%s/%d '%s' @ '%s' %.2f, %.2f, %.2f #%d", ((Object)((Object)this)).getClass().getSimpleName(), this.func_145782_y(), this.shipCore == null ? "~NULL~" : this.shipCore.uuid + ":" + this.shipCore.shipName, this.field_70170_p == null ? "~NULL~" : this.field_70170_p.func_72912_H().func_76065_j(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.ticks);
    }

    class CheckMovementResult {
        public ArrayList<Vector3> atSource = new ArrayList(1);
        public ArrayList<Vector3> atTarget = new ArrayList(1);
        public boolean isCollision = false;
        public String reason = "Unknown reason";

        CheckMovementResult() {
        }

        public void add(double sx, double sy, double sz, double tx, double ty, double tz, boolean pisCollision, String preason) {
            this.atSource.add(new Vector3(sx, sy, sz));
            this.atTarget.add(new Vector3(tx, ty, tz));
            this.isCollision = this.isCollision || pisCollision;
            this.reason = preason;
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info("CheckMovementResult " + sx + ", " + sy + ", " + sz + " -> " + tx + ", " + ty + ", " + tz + " " + this.isCollision + " '" + this.reason + "'");
            }
        }
    }
}

