/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.client.gui;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import kihira.foxlib.client.gui.GuiList;
import kihira.foxlib.client.gui.IListCallback;
import kihira.tails.client.FakeEntity;
import kihira.tails.client.PartRegistry;
import kihira.tails.client.gui.GuiEditor;
import kihira.tails.client.gui.Panel;
import kihira.tails.client.render.RenderPart;
import kihira.tails.common.PartInfo;
import kihira.tails.common.PartsData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class PartsPanel
extends Panel<GuiEditor>
implements IListCallback<PartEntry> {
    private GuiList<PartEntry> partList;
    private final FakeEntity fakeEntity;

    public PartsPanel(GuiEditor parent, int left, int top, int right, int bottom) {
        super(parent, left, top, right, bottom);
        this.fakeEntity = new FakeEntity((World)Minecraft.func_71410_x().field_71441_e);
    }

    public void func_73866_w_() {
        this.initPartList();
        super.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        this.field_73735_i = -100.0f;
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -872415232, -872415232);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.partList.func_148128_a(mouseX, mouseY, p_73863_3_);
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
    }

    void initPartList() {
        ArrayList<PartEntry> partList = new ArrayList<PartEntry>();
        PartsData.PartType partType = ((GuiEditor)this.parent).getPartType();
        partList.add(new PartEntry(new PartInfo(false, 0, 0, 0, -65536, -16711936, -16776961, null, partType)));
        List<RenderPart> parts = PartRegistry.getParts(partType);
        for (int type = 0; type < parts.size(); ++type) {
            for (int subType = 0; subType <= parts.get(type).getAvailableSubTypes(); ++subType) {
                PartInfo partInfo = new PartInfo(true, type, subType, 0, -65536, -16711936, -16776961, null, partType);
                partList.add(new PartEntry(partInfo));
            }
        }
        this.partList = new GuiList((IListCallback)this, this.field_146294_l, this.field_146295_m, 0, this.field_146295_m, 55, partList);
        this.partList.field_148155_a = this.field_146294_l;
        this.selectDefaultListEntry();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        this.partList.func_148179_a(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    public void func_146281_b() {
        for (PartEntry entry : this.partList.getEntries()) {
            entry.partInfo.setTexture(null);
        }
    }

    public boolean onEntrySelected(GuiList guiList, int index, PartEntry entry) {
        ((GuiEditor)this.parent).textureID = 0;
        PartInfo partInfo = new PartInfo(entry.partInfo.hasPart, entry.partInfo.typeid, entry.partInfo.subid, entry.partInfo.textureID, (int[])((GuiEditor)this.parent).getEditingPartInfo().tints.clone(), entry.partInfo.partType, null);
        ((GuiEditor)this.parent).setPartsInfo(partInfo);
        return true;
    }

    void selectDefaultListEntry() {
        for (GuiListExtended.IGuiListEntry entry : this.partList.getEntries()) {
            PartEntry partEntry = (PartEntry)entry;
            PartInfo partInfo = ((GuiEditor)this.parent).getEditingPartInfo();
            if ((partEntry.partInfo.hasPart || partInfo.hasPart) && (!partInfo.hasPart || !partEntry.partInfo.hasPart || partEntry.partInfo.typeid != partInfo.typeid || partEntry.partInfo.subid != partInfo.subid)) continue;
            this.partList.setCurrrentIndex(this.partList.getEntries().indexOf(partEntry));
            break;
        }
    }

    private void renderPart(int x, int y, int z, int scale, PartInfo partInfo) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glScalef((float)(-scale), (float)scale, (float)1.0f);
        RenderHelper.func_74519_b();
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        PartRegistry.getRenderPart(partInfo.partType, partInfo.typeid).render((EntityLivingBase)this.fakeEntity, partInfo, 0.0, 0.0, 0.0, 0.0f);
        RenderHelper.func_74518_a();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glPopMatrix();
    }

    public class PartEntry
    implements GuiListExtended.IGuiListEntry {
        public final PartInfo partInfo;

        public PartEntry(PartInfo partInfo) {
            this.partInfo = partInfo;
        }

        public void func_148279_a(int index, int x, int y, int listWidth, int p_148279_5_, Tessellator tessellator, int mouseX, int mouseY, boolean mouseOver) {
            if (this.partInfo.hasPart) {
                RenderPart renderPart;
                boolean currentPart = PartsPanel.this.partList.getCurrrentIndex() == index;
                PartsPanel.this.renderPart(PartsPanel.this.right - 25, y - 25, currentPart ? 10 : 1, 50, this.partInfo);
                PartsPanel.this.field_146289_q.func_78276_b(I18n.func_135052_a((String)PartRegistry.getRenderPart(this.partInfo.partType, this.partInfo.typeid).getUnlocalisedName(this.partInfo.subid), (Object[])new Object[0]), 5, y + 17, 0xFFFFFF);
                if (currentPart && (renderPart = PartRegistry.getRenderPart(((GuiEditor)PartsPanel.this.parent).getPartType(), this.partInfo.typeid)).getModelAuthor() != null) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)5.0f, (float)(y + 27), (float)0.0f);
                    GL11.glScalef((float)0.6f, (float)0.6f, (float)1.0f);
                    PartsPanel.this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.createdby", (Object[])new Object[0]) + ":", 0, 0, 0xFFFFFF);
                    GL11.glTranslatef((float)0.0f, (float)10.0f, (float)0.0f);
                    PartsPanel.this.field_146289_q.func_78276_b(EnumChatFormatting.AQUA + renderPart.getModelAuthor(), 0, 0, 0xFFFFFF);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                }
            } else {
                PartsPanel.this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tail.none.name", (Object[])new Object[0]), 5, y + ((PartsPanel)PartsPanel.this).partList.field_148149_f / 2 - 5, 0xFFFFFF);
            }
        }

        public boolean func_148278_a(int index, int mouseX, int mouseY, int mouseEvent, int mouseSlotX, int mouseSlotY) {
            String author;
            RenderPart renderPart = PartRegistry.getRenderPart(((GuiEditor)PartsPanel.this.parent).getPartType(), this.partInfo.typeid);
            if (PartsPanel.this.partList.getCurrrentIndex() == index && renderPart.hasAuthor(this.partInfo.subid, this.partInfo.textureID) && (author = renderPart.getAuthor(this.partInfo.subid, this.partInfo.textureID)).startsWith("@")) {
                float authorNameWidth = (float)PartsPanel.this.field_146289_q.func_78256_a(author) * 0.6f;
                if (mouseSlotX > 5 && (float)mouseSlotX < 5.0f + authorNameWidth && mouseSlotY > 30 && mouseSlotY < 38) {
                    try {
                        Desktop.getDesktop().browse(URI.create("https://twitter.com/" + author.replace("@", "")));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return false;
        }

        public void func_148277_b(int index, int mouseX, int mouseY, int mouseEvent, int mouseSlotX, int mouseSlotY) {
        }
    }
}

