/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.ITileHandler;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.logistics.api.Info;
import sonar.logistics.common.handlers.InfoReaderHandler;
import sonar.logistics.helpers.InfoHelper;
import sonar.logistics.info.types.CategoryInfo;

public class PacketProviders
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public List<Info> info;

    public PacketProviders() {
    }

    public PacketProviders(int xCoord, int yCoord, int zCoord, List<Info> info) {
        this.info = info;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
    }

    public void fromBytes(ByteBuf buf) {
        TileHandler handler;
        TileEntity tile;
        Object target;
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        if (buf.readBoolean()) {
            this.info = new ArrayList<Info>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.info.add(InfoHelper.readInfo(buf));
            }
        }
        if ((target = FMPHelper.checkObject((Object)(tile = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_147438_o(this.xCoord, this.yCoord, this.zCoord)))) != null && target instanceof ITileHandler && (handler = ((ITileHandler)target).getTileHandler()) != null && handler instanceof InfoReaderHandler) {
            InfoReaderHandler reader = (InfoReaderHandler)handler;
            if (this.info != null) {
                ArrayList<Info> newInfo = new ArrayList<Info>();
                Info lastInfo = null;
                for (Info blockInfo : this.info) {
                    if (lastInfo == null || !lastInfo.getCategory().equals(blockInfo.getCategory())) {
                        newInfo.add(CategoryInfo.createInfo(blockInfo.getCategory()));
                    }
                    newInfo.add(blockInfo);
                    lastInfo = blockInfo;
                }
                reader.clientInfo = newInfo;
            } else {
                reader.clientInfo = null;
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        if (this.info != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.info.size());
            for (int i = 0; i < this.info.size(); ++i) {
                InfoHelper.writeInfo(buf, this.info.get(i));
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketProviders, IMessage> {
        public IMessage onMessage(PacketProviders message, MessageContext ctx) {
            return null;
        }
    }
}

