/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.ITileHandler;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.logistics.common.handlers.InventoryReaderHandler;

public class PacketInventoryReader
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public ItemStack selected;

    public PacketInventoryReader() {
    }

    public PacketInventoryReader(int xCoord, int yCoord, int zCoord, ItemStack selected) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.selected = selected;
    }

    public void fromBytes(ByteBuf buf) {
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.selected = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.selected);
    }

    public static class Handler
    implements IMessageHandler<PacketInventoryReader, IMessage> {
        public IMessage onMessage(PacketInventoryReader message, MessageContext ctx) {
            TileHandler handler;
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            TileEntity te = world.func_147438_o(message.xCoord, message.yCoord, message.zCoord);
            if (te == null) {
                return null;
            }
            Object target = FMPHelper.checkObject((Object)te);
            if (target != null && target instanceof ITileHandler && (handler = ((ITileHandler)target).getTileHandler()) != null && handler instanceof InventoryReaderHandler) {
                InventoryReaderHandler reader = (InventoryReaderHandler)handler;
                reader.slots[0] = message.selected;
            }
            return null;
        }
    }
}

