/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.ITileHandler;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.logistics.api.Info;
import sonar.logistics.common.handlers.InfoReaderHandler;
import sonar.logistics.helpers.InfoHelper;

public class PacketInfoBlock
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public Info info;
    public boolean primary;
    public boolean setNull;

    public PacketInfoBlock() {
    }

    public PacketInfoBlock(int xCoord, int yCoord, int zCoord, boolean primary) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.primary = primary;
        this.setNull = true;
    }

    public PacketInfoBlock(int xCoord, int yCoord, int zCoord, Info info, boolean primary) {
        this.info = info;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.primary = primary;
    }

    public void fromBytes(ByteBuf buf) {
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.setNull = buf.readBoolean();
        this.primary = buf.readBoolean();
        if (!this.setNull) {
            this.info = InfoHelper.readInfo(buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        buf.writeBoolean(this.setNull);
        buf.writeBoolean(this.primary);
        if (!this.setNull) {
            InfoHelper.writeInfo(buf, this.info);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketInfoBlock, IMessage> {
        public IMessage onMessage(PacketInfoBlock message, MessageContext ctx) {
            TileHandler handler;
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            TileEntity te = world.func_147438_o(message.xCoord, message.yCoord, message.zCoord);
            if (te == null) {
                return null;
            }
            Object target = FMPHelper.checkObject((Object)te);
            if (target != null && target instanceof ITileHandler && (handler = ((ITileHandler)target).getTileHandler()) != null && handler instanceof InfoReaderHandler) {
                InfoReaderHandler reader = (InfoReaderHandler)handler;
                if (message.primary) {
                    reader.primaryInfo.setInfo(message.info);
                } else {
                    reader.secondaryInfo.setInfo(message.info);
                }
            }
            return null;
        }
    }
}

