/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.ITileHandler;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.logistics.common.handlers.FluidReaderHandler;

public class PacketFluidReader
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public FluidStack selected;

    public PacketFluidReader() {
    }

    public PacketFluidReader(int xCoord, int yCoord, int zCoord, FluidStack selected) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.selected = selected;
    }

    public void fromBytes(ByteBuf buf) {
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.selected = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        NBTTagCompound tag = new NBTTagCompound();
        this.selected.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<PacketFluidReader, IMessage> {
        public IMessage onMessage(PacketFluidReader message, MessageContext ctx) {
            TileHandler handler;
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            TileEntity te = world.func_147438_o(message.xCoord, message.yCoord, message.zCoord);
            if (te == null) {
                return null;
            }
            Object target = FMPHelper.checkObject((Object)te);
            if (target != null && target instanceof ITileHandler && (handler = ((ITileHandler)target).getTileHandler()) != null && handler instanceof FluidReaderHandler) {
                FluidReaderHandler reader = (FluidReaderHandler)handler;
                reader.current = message.selected;
            }
            return null;
        }
    }
}

