/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.logistics.api.DataEmitter;
import sonar.logistics.common.tileentity.TileEntityDataReceiver;

public class PacketDataReceiver
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public DataEmitter coords;

    public PacketDataReceiver() {
    }

    public PacketDataReceiver(int xCoord, int yCoord, int zCoord, DataEmitter info) {
        this.coords = info;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
    }

    public void fromBytes(ByteBuf buf) {
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        this.coords = DataEmitter.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        NBTTagCompound tag = new NBTTagCompound();
        DataEmitter.writeToNBT(tag, this.coords);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<PacketDataReceiver, IMessage> {
        public IMessage onMessage(PacketDataReceiver message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            TileEntity te = world.func_147438_o(message.xCoord, message.yCoord, message.zCoord);
            if (te == null) {
                return null;
            }
            if (te != null && te instanceof TileEntityDataReceiver) {
                TileEntityDataReceiver receiver = (TileEntityDataReceiver)te;
                receiver.emitter.setEmitter(message.coords);
            }
            return null;
        }
    }
}

