/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import sonar.logistics.api.DataEmitter;
import sonar.logistics.common.tileentity.TileEntityDataReceiver;

public class PacketDataEmitters
implements IMessage {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public List<DataEmitter> coords;

    public PacketDataEmitters() {
    }

    public PacketDataEmitters(int xCoord, int yCoord, int zCoord, List<DataEmitter> emitters) {
        this.coords = emitters;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
    }

    public void fromBytes(ByteBuf buf) {
        TileEntity tile;
        this.xCoord = buf.readInt();
        this.yCoord = buf.readInt();
        this.zCoord = buf.readInt();
        if (buf.readBoolean()) {
            this.coords = new ArrayList<DataEmitter>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.coords.add(DataEmitter.readFromNBT(ByteBufUtils.readTag((ByteBuf)buf)));
            }
        }
        if ((tile = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_147438_o(this.xCoord, this.yCoord, this.zCoord)) != null && tile instanceof TileEntityDataReceiver) {
            TileEntityDataReceiver receiver = (TileEntityDataReceiver)tile;
            receiver.emitters = this.coords;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeInt(this.yCoord);
        buf.writeInt(this.zCoord);
        if (this.coords != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.coords.size());
            for (int i = 0; i < this.coords.size(); ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                DataEmitter.writeToNBT(tag, this.coords.get(i));
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
            }
        } else {
            buf.writeBoolean(false);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketDataEmitters, IMessage> {
        public IMessage onMessage(PacketDataEmitters message, MessageContext ctx) {
            return null;
        }
    }
}

