/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.network.sync.ISyncPart;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.Info;
import sonar.logistics.helpers.InfoHelper;

public class SyncInfo
implements ISyncPart {
    private Info c;
    private Info last;
    private byte id;

    public SyncInfo(int id) {
        this.id = (byte)id;
    }

    public SyncInfo(int id, Info def) {
        this.id = (byte)id;
        this.c = def;
        this.last = def;
    }

    public boolean equal() {
        if (this.c == null && this.last != null) {
            return false;
        }
        if (this.last == null) {
            return false;
        }
        return this.c.isEqualType(this.last) && this.c.isDataEqualType(this.last);
    }

    public void writeToBuf(ByteBuf buf) {
        if (!this.equal()) {
            buf.writeBoolean(true);
            InfoHelper.writeInfo(buf, this.c);
            this.last = this.c;
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readFromBuf(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.c = InfoHelper.readInfo(buf);
        }
    }

    public void writeToNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound infoTag;
        if (type == NBTHelper.SyncType.SYNC && !this.equal()) {
            infoTag = new NBTTagCompound();
            InfoHelper.writeInfo(infoTag, this.c);
            nbt.func_74782_a(String.valueOf(this.id), (NBTBase)infoTag);
            this.last = this.c;
        }
        if (type == NBTHelper.SyncType.SAVE) {
            infoTag = new NBTTagCompound();
            InfoHelper.writeInfo(infoTag, this.c);
            nbt.func_74782_a(String.valueOf(this.id), (NBTBase)infoTag);
        }
    }

    public void readFromNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC && nbt.func_74764_b(String.valueOf(this.id))) {
            this.c = InfoHelper.readInfo(nbt.func_74775_l(String.valueOf(this.id)));
        }
        if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b(String.valueOf(this.id))) {
            this.c = InfoHelper.readInfo(nbt.func_74775_l(String.valueOf(this.id)));
        }
    }

    public void setInfo(Info value) {
        this.c = value;
    }

    public Info getInfo() {
        return this.c;
    }
}

