/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.network.sync.ISyncPart;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.DataEmitter;

public class SyncEmitter
implements ISyncPart {
    private DataEmitter c;
    private DataEmitter last;
    private byte id;

    public SyncEmitter(int id) {
        this.id = (byte)id;
    }

    public SyncEmitter(int id, DataEmitter def) {
        this.id = (byte)id;
        this.c = def;
        this.last = def;
    }

    public boolean equal() {
        if (this.c == null && this.last != null) {
            return false;
        }
        if (this.last == null) {
            return false;
        }
        return BlockCoords.equalCoords((BlockCoords)this.c.coords, (BlockCoords)this.last.coords) && this.c.name.equals(this.last.name);
    }

    public void writeToBuf(ByteBuf buf) {
        if (!this.equal()) {
            buf.writeBoolean(true);
            DataEmitter.writeInfo(buf, this.c);
            this.last = this.c;
        } else {
            buf.writeBoolean(false);
        }
    }

    public void readFromBuf(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.c = DataEmitter.readInfo(buf);
        }
    }

    public void writeToNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound infoTag;
        if (type == NBTHelper.SyncType.SYNC && !this.equal()) {
            infoTag = new NBTTagCompound();
            DataEmitter.writeToNBT(infoTag, this.c);
            nbt.func_74782_a(String.valueOf(this.id), (NBTBase)infoTag);
            this.last = this.c;
        }
        if (type == NBTHelper.SyncType.SAVE) {
            infoTag = new NBTTagCompound();
            DataEmitter.writeToNBT(infoTag, this.c);
            nbt.func_74782_a(String.valueOf(this.id), (NBTBase)infoTag);
        }
    }

    public void readFromNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (type == NBTHelper.SyncType.SYNC && nbt.func_74764_b(String.valueOf(this.id))) {
            this.c = DataEmitter.readFromNBT(nbt.func_74775_l(String.valueOf(this.id)));
        }
        if (type == NBTHelper.SyncType.SAVE && nbt.func_74764_b(String.valueOf(this.id))) {
            this.c = DataEmitter.readFromNBT(nbt.func_74775_l(String.valueOf(this.id)));
        }
    }

    public void setEmitter(DataEmitter value) {
        this.c = value;
    }

    public DataEmitter getEmitter() {
        return this.c;
    }
}

