/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network;

import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.core.integration.fmp.FMPHelper;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.core.network.utils.ISyncTile;
import sonar.logistics.Logistics;
import sonar.logistics.client.gui.GuiDataModifier;
import sonar.logistics.client.gui.GuiDataReceiver;
import sonar.logistics.client.gui.GuiEntityNode;
import sonar.logistics.client.gui.GuiFluidReader;
import sonar.logistics.client.gui.GuiHammer;
import sonar.logistics.client.gui.GuiInfoCreator;
import sonar.logistics.client.gui.GuiInfoReader;
import sonar.logistics.client.gui.GuiInventoryReader;
import sonar.logistics.client.gui.GuiRedstoneSignaller;
import sonar.logistics.client.gui.GuiRenameEmitter;
import sonar.logistics.common.containers.ContainerDataReceiver;
import sonar.logistics.common.containers.ContainerEmptySync;
import sonar.logistics.common.containers.ContainerFluidReader;
import sonar.logistics.common.containers.ContainerHammer;
import sonar.logistics.common.containers.ContainerInfoNode;
import sonar.logistics.common.containers.ContainerInventoryReader;
import sonar.logistics.common.handlers.DataModifierHandler;
import sonar.logistics.common.handlers.FluidReaderHandler;
import sonar.logistics.common.handlers.InfoCreatorHandler;
import sonar.logistics.common.handlers.InfoReaderHandler;
import sonar.logistics.common.handlers.InventoryReaderHandler;
import sonar.logistics.common.tileentity.TileEntityDataEmitter;
import sonar.logistics.common.tileentity.TileEntityDataModifier;
import sonar.logistics.common.tileentity.TileEntityDataReceiver;
import sonar.logistics.common.tileentity.TileEntityEntityNode;
import sonar.logistics.common.tileentity.TileEntityFluidReader;
import sonar.logistics.common.tileentity.TileEntityHammer;
import sonar.logistics.common.tileentity.TileEntityInfoCreator;
import sonar.logistics.common.tileentity.TileEntityInfoReader;
import sonar.logistics.common.tileentity.TileEntityInventoryReader;
import sonar.logistics.common.tileentity.TileEntityRedstoneSignaller;
import sonar.logistics.integration.multipart.DataModifierPart;
import sonar.logistics.integration.multipart.FluidReaderPart;
import sonar.logistics.integration.multipart.InfoCreatorPart;
import sonar.logistics.integration.multipart.InfoReaderPart;
import sonar.logistics.integration.multipart.InventoryReaderPart;
import sonar.logistics.network.packets.PacketDataEmitters;
import sonar.logistics.network.packets.PacketDataReceiver;
import sonar.logistics.network.packets.PacketFluidReader;
import sonar.logistics.network.packets.PacketInfoBlock;
import sonar.logistics.network.packets.PacketInventoryReader;
import sonar.logistics.network.packets.PacketProviders;

public class LogisticsCommon
implements IGuiHandler {
    private static final Map<String, NBTTagCompound> extendedEntityData = new HashMap<String, NBTTagCompound>();

    public static void registerPackets() {
        Logistics.network.registerMessage(PacketProviders.Handler.class, PacketProviders.class, 0, Side.CLIENT);
        Logistics.network.registerMessage(PacketInfoBlock.Handler.class, PacketInfoBlock.class, 1, Side.SERVER);
        Logistics.network.registerMessage(PacketDataEmitters.Handler.class, PacketDataEmitters.class, 2, Side.CLIENT);
        Logistics.network.registerMessage(PacketDataReceiver.Handler.class, PacketDataReceiver.class, 3, Side.SERVER);
        Logistics.network.registerMessage(PacketInventoryReader.Handler.class, PacketInventoryReader.class, 4, Side.SERVER);
        Logistics.network.registerMessage(PacketFluidReader.Handler.class, PacketFluidReader.class, 5, Side.SERVER);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        Object entity = FMPHelper.checkObject((Object)tile);
        if (entity != null) {
            switch (ID) {
                case 1: {
                    TileHandler handler;
                    if ((entity instanceof TileEntityInfoReader || entity instanceof InfoReaderPart) && (handler = FMPHelper.getHandler((Object)tile)) != null && handler instanceof InfoReaderHandler) {
                        return new ContainerInfoNode((InfoReaderHandler)handler, tile);
                    }
                }
                case 2: {
                    if (entity instanceof TileEntityDataReceiver) {
                        return new ContainerDataReceiver((TileEntityDataReceiver)entity, player.field_71071_by);
                    }
                }
                case 3: {
                    if (entity instanceof TileEntityDataEmitter) {
                        return new ContainerEmptySync((TileEntity)((TileEntityDataEmitter)entity));
                    }
                }
                case 4: {
                    TileHandler handler;
                    if ((entity instanceof TileEntityInventoryReader || entity instanceof InventoryReaderPart) && (handler = FMPHelper.getHandler((Object)tile)) != null && handler instanceof InventoryReaderHandler) {
                        return new ContainerInventoryReader((InventoryReaderHandler)handler, tile, player.field_71071_by);
                    }
                }
                case 5: {
                    if (entity instanceof TileEntityRedstoneSignaller) {
                        return new ContainerEmptySync((TileEntity)((TileEntityRedstoneSignaller)entity));
                    }
                }
                case 6: {
                    TileHandler handler;
                    if ((entity instanceof TileEntityDataModifier || entity instanceof DataModifierPart) && (handler = FMPHelper.getHandler((Object)tile)) != null && handler instanceof DataModifierHandler) {
                        return new ContainerEmptySync((ISyncTile)((DataModifierHandler)handler), tile);
                    }
                }
                case 7: {
                    TileHandler handler;
                    if ((entity instanceof TileEntityInfoCreator || entity instanceof InfoCreatorPart) && (handler = FMPHelper.getHandler((Object)tile)) != null && handler instanceof InfoCreatorHandler) {
                        return new ContainerEmptySync((ISyncTile)((InfoCreatorHandler)handler), tile);
                    }
                }
                case 8: {
                    if (entity instanceof TileEntityHammer) {
                        return new ContainerHammer(player.field_71071_by, (TileEntityHammer)((Object)entity));
                    }
                }
                case 9: {
                    if (entity instanceof TileEntityEntityNode) {
                        return new ContainerEmptySync((TileEntity)((TileEntityEntityNode)entity));
                    }
                }
                case 10: {
                    TileHandler handler;
                    if (!(entity instanceof TileEntityFluidReader) && !(entity instanceof FluidReaderPart) || (handler = FMPHelper.getHandler((Object)tile)) == null || !(handler instanceof FluidReaderHandler)) break;
                    return new ContainerFluidReader((FluidReaderHandler)handler, tile, player.field_71071_by);
                }
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        Object entity = FMPHelper.checkObject((Object)tile);
        if (entity != null) {
            switch (ID) {
                case 1: {
                    TileHandler handler;
                    if ((entity instanceof TileEntityInfoReader || entity instanceof InfoReaderPart) && (handler = FMPHelper.getHandler((Object)tile)) != null && handler instanceof InfoReaderHandler) {
                        return new GuiInfoReader((InfoReaderHandler)handler, tile);
                    }
                }
                case 2: {
                    if (entity instanceof TileEntityDataReceiver) {
                        return new GuiDataReceiver(player.field_71071_by, (TileEntityDataReceiver)entity);
                    }
                }
                case 3: {
                    if (entity instanceof TileEntityDataEmitter) {
                        return new GuiRenameEmitter.DataEmitter((TileEntityDataEmitter)entity);
                    }
                }
                case 4: {
                    TileHandler handler;
                    if ((entity instanceof TileEntityInventoryReader || entity instanceof InventoryReaderPart) && (handler = FMPHelper.getHandler((Object)tile)) != null && handler instanceof InventoryReaderHandler) {
                        return new GuiInventoryReader((InventoryReaderHandler)handler, tile, player.field_71071_by);
                    }
                }
                case 5: {
                    if (entity instanceof TileEntityRedstoneSignaller) {
                        return new GuiRedstoneSignaller.RedstoneSignaller((TileEntityRedstoneSignaller)entity);
                    }
                }
                case 6: {
                    TileHandler handler;
                    if ((entity instanceof TileEntityDataModifier || entity instanceof DataModifierPart) && (handler = FMPHelper.getHandler((Object)tile)) != null && handler instanceof DataModifierHandler) {
                        return new GuiDataModifier((DataModifierHandler)handler, tile);
                    }
                }
                case 7: {
                    TileHandler handler;
                    if ((entity instanceof TileEntityInfoCreator || entity instanceof InfoCreatorPart) && (handler = FMPHelper.getHandler((Object)tile)) != null && handler instanceof InfoCreatorHandler) {
                        return new GuiInfoCreator((InfoCreatorHandler)handler, tile);
                    }
                }
                case 8: {
                    if (entity instanceof TileEntityHammer) {
                        return new GuiHammer(player.field_71071_by, (TileEntityHammer)((Object)entity));
                    }
                }
                case 9: {
                    if (entity instanceof TileEntityEntityNode) {
                        return new GuiEntityNode.EntityNode((TileEntityEntityNode)entity);
                    }
                }
                case 10: {
                    TileHandler handler;
                    if (!(entity instanceof TileEntityFluidReader) && !(entity instanceof FluidReaderPart) || (handler = FMPHelper.getHandler((Object)tile)) == null || !(handler instanceof FluidReaderHandler)) break;
                    return new GuiFluidReader((FluidReaderHandler)handler, tile, player.field_71071_by);
                }
            }
        }
        return null;
    }

    public void registerRenderThings() {
    }
}

