/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration.multipart;

import codechicken.lib.vec.Cuboid6;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.integration.fmp.SonarHandlerPart;
import sonar.core.integration.fmp.handlers.TileHandler;
import sonar.logistics.Logistics;
import sonar.logistics.api.Info;
import sonar.logistics.api.connecting.IDataConnection;
import sonar.logistics.api.connecting.IInfoReader;
import sonar.logistics.client.renderers.RenderHandlers;
import sonar.logistics.common.handlers.InfoReaderHandler;
import sonar.logistics.registries.BlockRegistry;

public class InfoReaderPart
extends SonarHandlerPart
implements IDataConnection,
IInfoReader {
    public InfoReaderHandler handler = new InfoReaderHandler(true);

    public InfoReaderPart() {
    }

    public InfoReaderPart(int meta) {
        super(meta);
    }

    public TileHandler getTileHandler() {
        return this.handler;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return this.handler.canConnect((TileEntity)this.tile(), dir);
    }

    @Override
    public Info getSecondaryInfo() {
        return this.handler.getSecondaryInfo((TileEntity)this.tile());
    }

    @Override
    public Info currentInfo() {
        return this.handler.currentInfo((TileEntity)this.tile());
    }

    public void sendAvailableData(EntityPlayer player) {
        this.handler.sendAvailableData((TileEntity)this.tile(), player);
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition pos, ItemStack stack) {
        if (player != null) {
            this.sendAvailableData(player);
            player.openGui((Object)Logistics.instance, 1, this.tile().func_145831_w(), this.x(), this.y(), this.z());
            return true;
        }
        return false;
    }

    public Cuboid6 getBounds() {
        if (this.meta == 2 || this.meta == 3) {
            return new Cuboid6(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
        }
        if (this.meta == 4 || this.meta == 5) {
            return new Cuboid6(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
        }
        return new Cuboid6(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    }

    public Object getSpecialRenderer() {
        return new RenderHandlers.InfoReader();
    }

    public Block getBlock() {
        return BlockRegistry.infoReader;
    }

    public String getType() {
        return "Info Reader";
    }
}

