/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration.multipart;

import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import sonar.logistics.integration.multipart.DataCablePart;
import sonar.logistics.integration.multipart.DataModifierPart;
import sonar.logistics.integration.multipart.DisplayScreenPart;
import sonar.logistics.integration.multipart.FluidReaderPart;
import sonar.logistics.integration.multipart.InfoCreatorPart;
import sonar.logistics.integration.multipart.InfoReaderPart;
import sonar.logistics.integration.multipart.InventoryReaderPart;
import sonar.logistics.registries.BlockRegistry;

public class ForgeMultipartHandler
implements MultiPartRegistry.IPartFactory,
MultiPartRegistry.IPartConverter {
    public static ForgeMultipartHandler instance;

    public TMultiPart createPart(String name, boolean client) {
        if (name.equals("Screen Part")) {
            return new DisplayScreenPart();
        }
        if (name.equals("Cable Part")) {
            return new DataCablePart();
        }
        if (name.equals("Info Reader")) {
            return new InfoReaderPart();
        }
        if (name.equals("Inventory Reader")) {
            return new InventoryReaderPart();
        }
        if (name.equals("Info Creator")) {
            return new InfoCreatorPart();
        }
        if (name.equals("Data Modifier")) {
            return new DataModifierPart();
        }
        if (name.equals("Fluid Reader")) {
            return new FluidReaderPart();
        }
        return null;
    }

    public static void init() {
        instance = new ForgeMultipartHandler();
        MultiPartRegistry.registerConverter((MultiPartRegistry.IPartConverter)instance);
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)instance, (String[])new String[]{"Screen Part", "Cable Part", "Info Reader", "Inventory Reader", "Info Creator", "Data Modifier", "Fluid Reader"});
    }

    public Iterable<Block> blockTypes() {
        return Arrays.asList(BlockRegistry.displayScreen, BlockRegistry.dataCable, BlockRegistry.infoReader, BlockRegistry.inventoryReader, BlockRegistry.infoCreator, BlockRegistry.dataModifier, BlockRegistry.fluidReader);
    }

    public TMultiPart convert(World world, BlockCoord pos) {
        Block b = world.func_147439_a(pos.x, pos.y, pos.z);
        int meta = world.func_72805_g(pos.x, pos.y, pos.z);
        if (b == BlockRegistry.displayScreen) {
            return new DisplayScreenPart(meta);
        }
        if (b == BlockRegistry.dataCable) {
            return new DataCablePart(meta);
        }
        if (b == BlockRegistry.infoReader) {
            return new InfoReaderPart(meta);
        }
        if (b == BlockRegistry.inventoryReader) {
            return new InventoryReaderPart(meta);
        }
        if (b == BlockRegistry.infoCreator) {
            return new InfoCreatorPart(meta);
        }
        if (b == BlockRegistry.dataModifier) {
            return new DataModifierPart(meta);
        }
        if (b == BlockRegistry.fluidReader) {
            return new FluidReaderPart(meta);
        }
        return null;
    }
}

