/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration.multipart;

import codechicken.lib.vec.Cuboid6;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.integration.fmp.SonarTilePart;
import sonar.core.utils.BlockCoords;
import sonar.core.utils.helpers.NBTHelper;
import sonar.logistics.api.connecting.IDataCable;
import sonar.logistics.client.renderers.RenderHandlers;
import sonar.logistics.helpers.CableHelper;
import sonar.logistics.registries.BlockRegistry;

public class DataCablePart
extends SonarTilePart
implements IDataCable {
    public BlockCoords coords;
    public boolean occlusion;
    final double SHORTER = 0.375;
    final double LONGER = 0.625;
    final double MIN_DIRECTION = 0.0;
    final double MAX_DIRECTION = 1.0;
    final Cuboid6[] SIDE_TESTS = new Cuboid6[]{new Cuboid6(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new Cuboid6(0.375, 0.625, 0.375, 0.625, 1.0, 0.625), new Cuboid6(0.375, 0.375, 0.0, 0.625, 0.625, 0.375), new Cuboid6(0.375, 0.375, 0.625, 0.625, 0.625, 1.0), new Cuboid6(0.0, 0.375, 0.375, 0.375, 0.625, 0.625), new Cuboid6(0.625, 0.375, 0.375, 1.0, 0.625, 0.625)};

    public DataCablePart() {
    }

    public DataCablePart(int meta) {
        super(meta);
    }

    public Cuboid6 getBounds() {
        return new Cuboid6(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
    }

    public Object getSpecialRenderer() {
        return new RenderHandlers.BlockCable();
    }

    public Block getBlock() {
        return BlockRegistry.dataCable;
    }

    public String getType() {
        return "Cable Part";
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        if (this.occlusion) {
            return Collections.emptyList();
        }
        return super.getOcclusionBoxes();
    }

    @Override
    public boolean isBlocked(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN || this.tile() == null) {
            return false;
        }
        this.occlusion = true;
        boolean blocked = !this.tile().canAddPart((TMultiPart)new NormallyOccludedPart(this.SIDE_TESTS[side.ordinal()]));
        this.occlusion = false;
        return blocked;
    }

    @Override
    public boolean canRenderConnection(ForgeDirection dir) {
        if (this.isBlocked(dir)) {
            return false;
        }
        return CableHelper.canRenderConnection((TileEntity)this.tile(), dir);
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if ((type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) && nbt.func_74764_b("coords")) {
            this.coords = nbt.func_74775_l("coords").func_74767_n("hasCoords") ? BlockCoords.readFromNBT((NBTTagCompound)nbt.func_74775_l("coords")) : null;
        }
    }

    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.SAVE || type == NBTHelper.SyncType.SYNC) {
            NBTTagCompound infoTag = new NBTTagCompound();
            if (this.coords != null) {
                BlockCoords.writeToNBT((NBTTagCompound)infoTag, (BlockCoords)this.coords);
                infoTag.func_74757_a("hasCoords", true);
            } else {
                infoTag.func_74757_a("hasCoords", false);
            }
            nbt.func_74782_a("coords", (NBTBase)infoTag);
        }
    }

    @Override
    public BlockCoords getCoords() {
        return this.coords;
    }

    @Override
    public void setCoords(BlockCoords coords) {
        if (!BlockCoords.equalCoords((BlockCoords)this.coords, (BlockCoords)coords)) {
            this.coords = coords;
            CableHelper.updateAdjacentCoords((TileEntity)this.tile(), coords, true);
        }
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        CableHelper.updateAdjacentCoords((TileEntity)this.tile(), this.coords, true);
    }

    public void onNeighborChanged() {
        super.onNeighborChanged();
        CableHelper.updateAdjacentCoords((TileEntity)this.tile(), this.coords, true);
    }

    public void onWorldSeparate() {
        super.onWorldSeparate();
        CableHelper.updateAdjacentCoords(this.tile().func_145831_w(), this.x(), this.y(), this.z(), null, true);
    }

    public void onPartChanged(TMultiPart part) {
        this.coords = null;
        CableHelper.removeAllBlockedAdjacentCoords((TileEntity)this.tile());
    }
}

