/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.integration;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sonar.core.utils.helpers.RecipeHelper;
import sonar.logistics.utils.HammerRecipes;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.logistics.hammer")
public class HammerHandler {
    @ZenMethod
    public static void addRecipe(IIngredient input1, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(input1, MineTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input1) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(input1));
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private Object input1;
        private ItemStack output;

        public RemoveRecipeAction(Object input1) {
            if (input1 instanceof IItemStack) {
                input1 = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input1));
            }
            if (input1 instanceof IOreDictEntry) {
                input1 = new RecipeHelper.OreStack(((IOreDictEntry)input1).getName(), 1);
            }
            if (input1 instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)"A liquid was passed into a Forging Hammer Recipe, aborting!");
                this.output = null;
                input1 = null;
            }
            this.input1 = input1;
            ItemStack dummyInput1 = null;
            if (input1 instanceof ItemStack) {
                dummyInput1 = (ItemStack)input1;
            }
            if (input1 instanceof RecipeHelper.OreStack) {
                dummyInput1 = (ItemStack)OreDictionary.getOres((String)((RecipeHelper.OreStack)input1).oreString).get(0);
            }
            this.output = HammerRecipes.instance().getCraftingResult(new ItemStack[]{dummyInput1});
        }

        public void apply() {
            if (this.input1 == null || this.output == null) {
                return;
            }
            HammerRecipes.instance().removeRecipe(new Object[]{this.input1});
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            if (this.input1 == null || this.output == null) {
                return;
            }
            HammerRecipes.instance().addRecipe(new Object[]{this.input1, this.output});
        }

        public String describe() {
            return String.format("Removing Forging Hammer Recipe (%s = %s)", this.input1, this.output);
        }

        public String describeUndo() {
            return String.format("Reverting /%s/", this.describe());
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private Object input1;
        private ItemStack output;

        public AddRecipeAction(Object input1, ItemStack output) {
            if (input1 instanceof IItemStack) {
                input1 = MineTweakerMC.getItemStack((IItemStack)((IItemStack)input1));
            }
            if (input1 instanceof IOreDictEntry) {
                input1 = new RecipeHelper.OreStack(((IOreDictEntry)input1).getName(), 1);
            }
            if (input1 instanceof ILiquidStack) {
                MineTweakerAPI.logError((String)"A liquid was passed into a Forging Hammer Recipe, aborting!");
                output = null;
                input1 = null;
            }
            this.input1 = input1;
            this.output = output;
        }

        public void apply() {
            if (this.input1 == null || this.output == null) {
                return;
            }
            HammerRecipes.instance().addRecipe(new Object[]{this.input1, this.output});
        }

        public void undo() {
            if (this.input1 == null || this.output == null) {
                return;
            }
            HammerRecipes.instance().removeRecipe(new Object[]{this.input1});
        }

        public String describe() {
            return String.format("Adding Forging Hammer recipe (%s = %s)", this.input1, this.output);
        }

        public String describeUndo() {
            return String.format("Reverting /%s/", this.describe());
        }

        public boolean canUndo() {
            return true;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

