/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.info.types;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;
import sonar.logistics.api.StandardInfo;
import sonar.logistics.api.render.InfoRenderer;
import thaumcraft.api.aspects.Aspect;

public class ThaumcraftAspectInfo
extends StandardInfo {
    public String tex;

    @Override
    public String getName() {
        return "Aspect-Info";
    }

    public ThaumcraftAspectInfo() {
    }

    public ThaumcraftAspectInfo(byte providerID, String category, String subCategory, Object data, String suffix, String tex) {
        super(providerID, category, subCategory, data, suffix);
        this.tex = tex;
    }

    public ThaumcraftAspectInfo(byte providerID, String category, String subCategory, Object data, String tex) {
        super((int)providerID, category, subCategory, data);
        this.tex = tex;
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        super.readFromBuf(buf);
        this.tex = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        super.writeToBuf(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.tex);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.tex = tag.func_74779_i("tex");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74778_a("tex", this.tex.toString());
    }

    @Override
    public void renderInfo(Tessellator tess, TileEntity tile, float minX, float minY, float maxX, float maxY, float zOffset, float scale) {
        FontRenderer rend = Minecraft.func_71410_x().field_71466_p;
        GL11.glTranslated((double)0.0, (double)0.0, (double)zOffset);
        float width = 1.0f;
        float height = 1.0f;
        double scaled = scale / 400.0f;
        GL11.glScaled((double)scaled, (double)scaled, (double)scaled);
        if (this.tex != null) {
            GL11.glTranslated((double)-0.7, (double)-0.55, (double)0.0);
            Aspect aspect = Aspect.getAspect((String)this.tex);
            if (aspect != null) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(aspect.getImage());
                GL11.glBlendFunc((int)770, (int)aspect.getBlend());
                tess.func_78382_b();
                tess.func_78384_a(aspect.getColor(), 128);
                tess.func_78374_a((double)minX, 0.0, 0.0, 0.0, 0.0);
                tess.func_78374_a((double)minX, (double)height, 0.0, 0.0, (double)height);
                tess.func_78374_a((double)(minX + width), (double)height, 0.0, (double)width, (double)height);
                tess.func_78374_a((double)(minX + width), 0.0, 0.0, (double)width, 0.0);
                tess.func_78381_a();
            }
            GL11.glTranslated((double)0.7, (double)0.55, (double)0.0);
        }
        GL11.glTranslated((double)0.5, (double)0.0, (double)0.0);
        GL11.glScaled((double)(1.0 / scaled), (double)(1.0 / scaled), (double)(1.0 / scaled));
        GL11.glTranslated((double)0.0, (double)0.0, (double)(-zOffset));
        InfoRenderer.renderStandardInfo(this, rend, minX, minY, maxX, maxY, zOffset, scale);
    }

    @Override
    public ThaumcraftAspectInfo newInfo() {
        return new ThaumcraftAspectInfo();
    }
}

